/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.RelationshipSelection;

public abstract class DefaultPooledCursorsTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static long startNode;
    private static long relationship;
    private static long propNode;
    private static final String NODE_PROP_INDEX_NAME = "nodeProp";

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().indexFor(Label.label((String)"Node")).on("prop").withName(NODE_PROP_INDEX_NAME).create();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            Node a = tx.createNode(new Label[]{Label.label((String)"Foo")});
            Node b = tx.createNode(new Label[]{Label.label((String)"Bar")});
            startNode = a.getId();
            relationship = a.createRelationshipTo(b, RelationshipType.withName((String)"REL")).getId();
            propNode = this.createNodeWithProperty(tx, "prop", true);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldReuseNodeCursor() {
        NodeCursor c1 = this.cursors.allocateNodeCursor(CursorContext.NULL);
        this.read.singleNode(startNode, c1);
        c1.close();
        NodeCursor c2 = this.cursors.allocateNodeCursor(CursorContext.NULL);
        Assertions.assertThat((Object)c1).isSameAs((Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseFullAccessNodeCursor() {
        NodeCursor c1 = this.cursors.allocateFullAccessNodeCursor(CursorContext.NULL);
        this.read.singleNode(startNode, c1);
        c1.close();
        NodeCursor c2 = this.cursors.allocateFullAccessNodeCursor(CursorContext.NULL);
        Assertions.assertThat((Object)c1).isSameAs((Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseRelationshipScanCursor() {
        RelationshipScanCursor c1 = this.cursors.allocateRelationshipScanCursor(CursorContext.NULL);
        this.read.singleRelationship(relationship, c1);
        c1.close();
        RelationshipScanCursor c2 = this.cursors.allocateRelationshipScanCursor(CursorContext.NULL);
        Assertions.assertThat((Object)c1).isSameAs((Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseFullAccessRelationshipScanCursor() {
        RelationshipScanCursor c1 = this.cursors.allocateFullAccessRelationshipScanCursor(CursorContext.NULL);
        this.read.singleRelationship(relationship, c1);
        c1.close();
        RelationshipScanCursor c2 = this.cursors.allocateFullAccessRelationshipScanCursor(CursorContext.NULL);
        Assertions.assertThat((Object)c1).isSameAs((Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseRelationshipTraversalCursor() {
        NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL);
        RelationshipTraversalCursor c1 = this.cursors.allocateRelationshipTraversalCursor(CursorContext.NULL);
        this.read.singleNode(startNode, node);
        node.next();
        node.relationships(c1, RelationshipSelection.ALL_RELATIONSHIPS);
        node.close();
        c1.close();
        RelationshipTraversalCursor c2 = this.cursors.allocateRelationshipTraversalCursor(CursorContext.NULL);
        Assertions.assertThat((Object)c1).isSameAs((Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseFullAccessRelationshipTraversalCursor() {
        NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL);
        RelationshipTraversalCursor c1 = this.cursors.allocateFullAccessRelationshipTraversalCursor(CursorContext.NULL);
        this.read.singleNode(startNode, node);
        node.next();
        node.relationships(c1, RelationshipSelection.ALL_RELATIONSHIPS);
        node.close();
        c1.close();
        RelationshipTraversalCursor c2 = this.cursors.allocateFullAccessRelationshipTraversalCursor(CursorContext.NULL);
        Assertions.assertThat((Object)c1).isSameAs((Object)c2);
        c2.close();
    }

    @Test
    void shouldReusePropertyCursor() {
        NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL);
        PropertyCursor c1 = this.cursors.allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.read.singleNode(propNode, node);
        node.next();
        node.properties(c1);
        node.close();
        c1.close();
        PropertyCursor c2 = this.cursors.allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((Object)c1).isSameAs((Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseFullAccessPropertyCursor() {
        NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL);
        PropertyCursor c1 = this.cursors.allocateFullAccessPropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.read.singleNode(propNode, node);
        node.next();
        node.properties(c1);
        node.close();
        c1.close();
        PropertyCursor c2 = this.cursors.allocateFullAccessPropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((Object)c1).isSameAs((Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseNodeValueIndexCursor() throws Exception {
        int prop = this.token.propertyKey("prop");
        IndexDescriptor indexDescriptor = this.tx.schemaRead().indexGetForName(NODE_PROP_INDEX_NAME);
        Predicates.awaitEx(() -> this.tx.schemaRead().indexGetState(indexDescriptor) == InternalIndexState.ONLINE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        IndexReadSession indexSession = this.tx.dataRead().indexReadSession(indexDescriptor);
        NodeValueIndexCursor c1 = this.cursors.allocateNodeValueIndexCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.read.nodeIndexSeek(indexSession, c1, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)"zero")});
        c1.close();
        NodeValueIndexCursor c2 = this.cursors.allocateNodeValueIndexCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((Object)c1).isSameAs((Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseFullAccessNodeValueIndexCursor() throws Exception {
        int prop = this.token.propertyKey("prop");
        IndexDescriptor indexDescriptor = this.tx.schemaRead().indexGetForName(NODE_PROP_INDEX_NAME);
        Predicates.awaitEx(() -> this.tx.schemaRead().indexGetState(indexDescriptor) == InternalIndexState.ONLINE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        IndexReadSession indexSession = this.tx.dataRead().indexReadSession(indexDescriptor);
        NodeValueIndexCursor c1 = this.cursors.allocateFullAccessNodeValueIndexCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.read.nodeIndexSeek(indexSession, c1, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)"zero")});
        c1.close();
        NodeValueIndexCursor c2 = this.cursors.allocateFullAccessNodeValueIndexCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((Object)c1).isSameAs((Object)c2);
        c2.close();
    }

    @Test
    void shouldReuseNodeLabelIndexCursor() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            NodeLabelIndexCursor c1 = tx.cursors().allocateNodeLabelIndexCursor(CursorContext.NULL);
            tx.dataRead().nodeLabelScan(DefaultPooledCursorsTestBase.getTokenReadSession(tx, EntityType.NODE), c1, IndexQueryConstraints.unconstrained(), new TokenPredicate(1));
            c1.close();
            NodeLabelIndexCursor c2 = tx.cursors().allocateNodeLabelIndexCursor(CursorContext.NULL);
            Assertions.assertThat((Object)c1).isSameAs((Object)c2);
            c2.close();
        }
    }

    @Test
    void shouldReuseFullAccessNodeLabelIndexCursor() throws Exception {
        try (KernelTransaction tx = this.beginTransaction();){
            NodeLabelIndexCursor c1 = tx.cursors().allocateFullAccessNodeLabelIndexCursor(CursorContext.NULL);
            tx.dataRead().nodeLabelScan(DefaultPooledCursorsTestBase.getTokenReadSession(tx, EntityType.NODE), c1, IndexQueryConstraints.unconstrained(), new TokenPredicate(1));
            c1.close();
            NodeLabelIndexCursor c2 = tx.cursors().allocateFullAccessNodeLabelIndexCursor(CursorContext.NULL);
            Assertions.assertThat((Object)c1).isSameAs((Object)c2);
            c2.close();
        }
    }

    @Test
    void shouldReuseRelationshipIndexCursors() throws Exception {
        IndexDescriptor index;
        int name;
        int connection;
        String indexName = "myIndex";
        try (KernelTransaction tx = this.beginTransaction();){
            connection = tx.tokenWrite().relationshipTypeGetOrCreateForName("Connection");
            name = tx.tokenWrite().propertyKeyGetOrCreateForName("name");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])this.array(connection), (int[])this.array(name));
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR).withName(indexName).withIndexType(IndexType.FULLTEXT);
            index = tx.schemaWrite().indexCreate(prototype);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        Predicates.awaitEx(() -> this.tx.schemaRead().indexGetState(index) == InternalIndexState.ONLINE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
        RelationshipValueIndexCursor c1 = this.cursors.allocateRelationshipValueIndexCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        IndexReadSession indexSession = this.tx.dataRead().indexReadSession(index);
        this.read.relationshipIndexSeek(indexSession, c1, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"hello")});
        c1.close();
        RelationshipValueIndexCursor c2 = this.cursors.allocateRelationshipValueIndexCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((Object)c1).isSameAs((Object)c2);
        c2.close();
    }

    private int[] array(int ... elements) {
        return elements;
    }

    private long createNodeWithProperty(Transaction tx, String propertyKey, Object value) {
        Node p = tx.createNode();
        p.setProperty(propertyKey, value);
        return p.getId();
    }

    private static TokenReadSession getTokenReadSession(KernelTransaction tx, EntityType entityType) throws IndexNotFoundKernelException {
        Iterator indexes = tx.schemaRead().index((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)entityType));
        IndexDescriptor index = (IndexDescriptor)indexes.next();
        Assertions.assertThat((boolean)indexes.hasNext()).isFalse();
        return tx.dataRead().tokenReadSession(index);
    }
}

