/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheSupportExtension;
import org.neo4j.test.rule.PageCacheConfig;

@Neo4jLayoutExtension
class RelationshipGroupStoreTest {
    @RegisterExtension
    static final PageCacheSupportExtension pageCacheExtension = new PageCacheSupportExtension(PageCacheConfig.config().withInconsistentReads(false));
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    private int defaultThreshold;
    private GraphDatabaseAPI db;
    private DatabaseManagementService managementService;
    private PageCache pageCache;

    RelationshipGroupStoreTest() {
    }

    @BeforeEach
    void before() {
        this.defaultThreshold = (Integer)GraphDatabaseSettings.dense_node_threshold.defaultValue();
        this.pageCache = pageCacheExtension.getPageCache(this.fs);
    }

    @AfterEach
    void after() {
        if (this.db != null) {
            this.managementService.shutdown();
        }
        this.pageCache.close();
    }

    @Test
    void createWithDefaultThreshold() {
        this.createAndVerify(null);
    }

    @Test
    void createWithCustomThreshold() {
        this.createAndVerify(this.defaultThreshold * 2);
    }

    @Test
    void createDenseNodeWithLowThreshold() {
        Node node;
        this.newDb(2);
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST2);
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)node.getDegree());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)node.getDegree((RelationshipType)MyRelTypes.TEST));
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)node.getDegree((RelationshipType)MyRelTypes.TEST2));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(node.getId()).createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.managementService.shutdown();
    }

    private void newDb(int denseNodeThreshold) {
        this.managementService = new TestDatabaseManagementServiceBuilder().impermanent().setConfig(GraphDatabaseSettings.dense_node_threshold, (Object)denseNodeThreshold).build();
        this.db = (GraphDatabaseAPI)this.managementService.database("neo4j");
        this.fs = (FileSystemAbstraction)this.db.getDependencyResolver().resolveDependency(FileSystemAbstraction.class);
    }

    private void createAndVerify(Integer customThreshold) {
        int expectedThreshold = customThreshold != null ? customThreshold : this.defaultThreshold;
        StoreFactory factory = this.factory(customThreshold);
        NeoStores neoStores = factory.openAllNeoStores(true);
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedThreshold, (int)neoStores.getRelationshipGroupStore().getStoreHeaderInt());
        neoStores.close();
        neoStores = factory.openAllNeoStores();
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedThreshold, (int)neoStores.getRelationshipGroupStore().getStoreHeaderInt());
        neoStores.close();
        factory = this.factory(999999);
        neoStores = factory.openAllNeoStores();
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedThreshold, (int)neoStores.getRelationshipGroupStore().getStoreHeaderInt());
        neoStores.close();
    }

    private StoreFactory factory(Integer customThreshold) {
        return this.factory(customThreshold, this.pageCache);
    }

    private StoreFactory factory(Integer customThreshold, PageCache pageCache) {
        Config.Builder config = Config.newBuilder();
        if (customThreshold != null) {
            config.set(GraphDatabaseSettings.dense_node_threshold, (Object)customThreshold);
        }
        return new StoreFactory(this.databaseLayout, config.build(), (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs, RecoveryCleanupWorkCollector.immediate(), this.databaseLayout.getDatabaseName()), pageCache, this.fs, (LogProvider)NullLogProvider.getInstance(), PageCacheTracer.NULL, DatabaseReadOnlyChecker.writable());
    }

    @Test
    void makeSureRelationshipGroupsNextAndPrevGetsAssignedCorrectly() {
        this.newDb(1);
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            Node node0 = tx.createNode();
            Node node2 = tx.createNode();
            node0.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            node.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            for (Relationship rel : node.getRelationships()) {
                rel.delete();
            }
            node.delete();
            tx.commit();
        }
        this.managementService.shutdown();
    }

    @Test
    void verifyRecordsForDenseNodeWithOneRelType() {
        Relationship rel6;
        Relationship rel5;
        Relationship rel4;
        Relationship rel3;
        Relationship rel2;
        Relationship rel1;
        Node node;
        this.newDb(2);
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            rel1 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel2 = tx.createNode().createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            rel3 = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            rel4 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel5 = tx.createNode().createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            rel6 = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            tx.commit();
        }
        NeoStores neoStores = ((RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        NodeStore nodeStore = neoStores.getNodeStore();
        NodeRecord nodeRecord = (NodeRecord)nodeStore.getRecord(node.getId(), (AbstractBaseRecord)((NodeRecord)nodeStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
        long group = nodeRecord.getNextRel();
        RelationshipGroupStore groupStore = neoStores.getRelationshipGroupStore();
        RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)groupStore.getRecord(group, (AbstractBaseRecord)((RelationshipGroupRecord)groupStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)groupRecord.getNext());
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)groupRecord.getPrev());
        RelationshipGroupStoreTest.assertRelationshipChain(neoStores.getRelationshipStore(), node, groupRecord.getFirstOut(), rel1.getId(), rel4.getId());
        RelationshipGroupStoreTest.assertRelationshipChain(neoStores.getRelationshipStore(), node, groupRecord.getFirstIn(), rel2.getId(), rel5.getId());
        RelationshipGroupStoreTest.assertRelationshipChain(neoStores.getRelationshipStore(), node, groupRecord.getFirstLoop(), rel3.getId(), rel6.getId());
    }

    @Test
    void verifyRecordsForDenseNodeWithTwoRelTypes() {
        Relationship rel6;
        Relationship rel5;
        Relationship rel4;
        Relationship rel3;
        Relationship rel2;
        Relationship rel1;
        Node node;
        this.newDb(2);
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            rel1 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel2 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel3 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            rel4 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST2);
            rel5 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST2);
            rel6 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST2);
            tx.commit();
        }
        NeoStores neoStores = ((RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        NodeStore nodeStore = neoStores.getNodeStore();
        NodeRecord nodeRecord = (NodeRecord)nodeStore.getRecord(node.getId(), (AbstractBaseRecord)((NodeRecord)nodeStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
        long group = nodeRecord.getNextRel();
        RelationshipGroupStore groupStore = neoStores.getRelationshipGroupStore();
        RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)groupStore.getRecord(group, (AbstractBaseRecord)((RelationshipGroupRecord)groupStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertNotEquals((long)groupRecord.getNext(), (long)-1L);
        RelationshipGroupStoreTest.assertRelationshipChain(neoStores.getRelationshipStore(), node, groupRecord.getFirstOut(), rel1.getId(), rel2.getId(), rel3.getId());
        RelationshipGroupRecord otherGroupRecord = (RelationshipGroupRecord)groupStore.getRecord(groupRecord.getNext(), (AbstractBaseRecord)((RelationshipGroupRecord)groupStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)otherGroupRecord.getNext());
        RelationshipGroupStoreTest.assertRelationshipChain(neoStores.getRelationshipStore(), node, otherGroupRecord.getFirstOut(), rel4.getId(), rel5.getId(), rel6.getId());
    }

    @Test
    void verifyGroupIsDeletedWhenNeeded() {
        this.newDb(2);
        Transaction tx = this.db.beginTx();
        Node node = tx.createNode();
        Relationship rel1 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
        Relationship rel2 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
        Relationship rel3 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
        Relationship rel4 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST2);
        Relationship rel5 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST2);
        Relationship rel6 = node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST2);
        tx.commit();
        NeoStores neoStores = ((RecordStorageEngine)this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores();
        NodeStore nodeStore = neoStores.getNodeStore();
        NodeRecord nodeRecord = (NodeRecord)nodeStore.getRecord(node.getId(), (AbstractBaseRecord)((NodeRecord)nodeStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
        long group = nodeRecord.getNextRel();
        RelationshipGroupStore groupStore = neoStores.getRelationshipGroupStore();
        RelationshipGroupRecord groupRecord = (RelationshipGroupRecord)groupStore.getRecord(group, (AbstractBaseRecord)((RelationshipGroupRecord)groupStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertNotEquals((long)groupRecord.getNext(), (long)-1L);
        RelationshipGroupRecord otherGroupRecord = (RelationshipGroupRecord)groupStore.getRecord(groupRecord.getNext(), (AbstractBaseRecord)((RelationshipGroupRecord)groupStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)otherGroupRecord.getNext());
    }

    @Test
    void checkingIfRecordIsInUseMustHappenAfterConsistentRead() {
        AtomicBoolean nextReadIsInconsistent = new AtomicBoolean(false);
        try (PageCache pageCache = pageCacheExtension.getPageCache(this.fs, PageCacheConfig.config().withInconsistentReads(nextReadIsInconsistent));){
            StoreFactory factory = this.factory(null, pageCache);
            try (NeoStores neoStores = factory.openAllNeoStores(true);){
                RelationshipGroupStore relationshipGroupStore = neoStores.getRelationshipGroupStore();
                RelationshipGroupRecord record = new RelationshipGroupRecord(1L).initialize(true, 2, 3L, 4L, 5L, 6L, (long)Record.NO_NEXT_RELATIONSHIP.intValue());
                relationshipGroupStore.updateRecord((AbstractBaseRecord)record, CursorContext.NULL);
                nextReadIsInconsistent.set(true);
                RelationshipGroupRecord readBack = (RelationshipGroupRecord)relationshipGroupStore.getRecord(1L, (AbstractBaseRecord)((RelationshipGroupRecord)relationshipGroupStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
                Assertions.assertThat((String)readBack.toString()).isEqualTo(record.toString());
            }
        }
    }

    private static void assertRelationshipChain(RelationshipStore relationshipStore, Node node, long firstId, long ... chainedIds) {
        long nodeId = node.getId();
        RelationshipRecord record = (RelationshipRecord)relationshipStore.getRecord(firstId, (AbstractBaseRecord)((RelationshipRecord)relationshipStore.newRecord()), RecordLoad.NORMAL, CursorContext.NULL);
        HashSet<Long> readChain = new HashSet<Long>();
        readChain.add(firstId);
        while (true) {
            long nextId;
            long l = nextId = record.getFirstNode() == nodeId ? record.getFirstNextRel() : record.getSecondNextRel();
            if (nextId == -1L) break;
            readChain.add(nextId);
            relationshipStore.getRecord(nextId, (AbstractBaseRecord)record, RecordLoad.NORMAL, CursorContext.NULL);
        }
        HashSet<Long> expectedChain = new HashSet<Long>(Collections.singletonList(firstId));
        for (long id : chainedIds) {
            expectedChain.add(id);
        }
        org.junit.jupiter.api.Assertions.assertEquals(expectedChain, readChain);
    }
}

