/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelIndexedNodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.TestTokenScanConsumer;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class LabelScanNodeViewTracingIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private RecordStorageEngine storageEngine;
    @Inject
    private LockService lockService;
    @Inject
    private JobScheduler jobScheduler;
    @Inject
    private IndexingService indexingService;

    LabelScanNodeViewTracingIT() {
    }

    @Test
    void tracePageCacheAccess() throws Exception {
        int nodeCount = 1000;
        Label label = Label.label((String)"marker");
        try (Transaction tx = this.database.beginTx();){
            for (int i = 0; i < nodeCount; ++i) {
                Node node = tx.createNode(new Label[]{label});
                node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)10));
            }
            tx.commit();
        }
        int labelId = this.getLabelId(label);
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        IndexProxy indexProxy = this.indexingService.getIndexProxy(this.findTokenIndex());
        LabelIndexedNodeStoreScan scan = new LabelIndexedNodeStoreScan(Config.defaults(), (StorageReader)this.storageEngine.newReader(), this.lockService, indexProxy.newTokenReader(), (TokenScanConsumer)new TestTokenScanConsumer(), null, new int[]{labelId}, any -> false, false, this.jobScheduler, (PageCacheTracer)cacheTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        scan.run(StoreScan.NO_EXTERNAL_UPDATES);
        Assertions.assertThat((long)cacheTracer.pins()).isEqualTo(3L);
        Assertions.assertThat((long)cacheTracer.unpins()).isEqualTo(3L);
        Assertions.assertThat((long)cacheTracer.hits()).isEqualTo(3L);
    }

    private int getLabelId(Label label) {
        try (Transaction tx = this.database.beginTx();){
            int n = ((InternalTransaction)tx).kernelTransaction().tokenRead().nodeLabel(label.name());
            return n;
        }
    }

    private IndexDescriptor findTokenIndex() {
        try (Transaction tx = this.database.beginTx();){
            Optional<IndexDescriptor> nodeIndex = StreamSupport.stream(tx.schema().getIndexes().spliterator(), false).map(indexDef -> ((IndexDefinitionImpl)indexDef).getIndexReference()).filter(index -> index.isTokenIndex() && index.schema().entityType() == EntityType.NODE).findFirst();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeIndex.isPresent());
            IndexDescriptor indexDescriptor = nodeIndex.get();
            return indexDescriptor;
        }
    }
}

