/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;

@TestDirectoryExtension
@DbmsExtension
class DbmsRuntimeVersionTest {
    @Inject
    private DatabaseManager<DatabaseContext> databaseManager;
    @Inject
    private DbmsRuntimeRepository dbmsRuntimeRepository;
    private GraphDatabaseService systemDb;

    DbmsRuntimeVersionTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.systemDb = ((DatabaseContext)this.databaseManager.getDatabaseContext(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID).get()).databaseFacade();
    }

    @Test
    void testBasicVersionLifecycle() {
        Assertions.assertSame((Object)DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION, (Object)this.dbmsRuntimeRepository.getVersion());
        this.setRuntimeVersion(DbmsRuntimeVersion.V4_1);
        Assertions.assertSame((Object)DbmsRuntimeVersion.V4_1, (Object)this.dbmsRuntimeRepository.getVersion());
        this.systemDb.executeTransactionally("CALL dbms.upgrade()");
        Assertions.assertSame((Object)DbmsRuntimeVersion.LATEST_DBMS_RUNTIME_COMPONENT_VERSION, (Object)this.dbmsRuntimeRepository.getVersion());
    }

    private void setRuntimeVersion(DbmsRuntimeVersion runtimeVersion) {
        try (Transaction tx = this.systemDb.beginTx();){
            tx.findNodes(SystemGraphComponent.VERSION_LABEL).stream().forEach(dbmsRuntimeNode -> dbmsRuntimeNode.setProperty("dbms-runtime", (Object)runtimeVersion.getVersion()));
            tx.commit();
        }
        this.dbmsRuntimeRepository.setVersion(runtimeVersion);
    }
}

