/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.aligned;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.StoreVersion;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StoreIdProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class AlignedRecordFormatIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private StoreIdProvider storeIdProvider;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.record_format, (Object)"alignedV4_1");
    }

    @Test
    void databaseCanBeStartedWithAlignedFormat() {
        Assertions.assertEquals((Object)StoreVersion.ALIGNED_V4_1.versionString(), (Object)MetaDataStore.versionLongToString((long)this.storeIdProvider.getStoreId().getStoreVersion()));
    }

    @Test
    void nodeAndRelationshipTransaction() {
        try (Transaction transaction = this.database.beginTx();){
            Node source = transaction.createNode(new Label[]{Label.label((String)"marker")});
            Node target = transaction.createNode();
            source.createRelationshipTo(target, RelationshipType.withName((String)"link"));
            transaction.commit();
        }
        transaction = this.database.beginTx();
        try {
            Assertions.assertEquals((long)2L, (long)Iterables.count((Iterable)transaction.getAllNodes()));
            Assertions.assertEquals((long)1L, (long)Iterables.count((Iterable)transaction.getAllRelationships()));
            Assertions.assertEquals((long)1L, (long)Iterables.count((Iterable)transaction.getAllLabels()));
            Assertions.assertEquals((long)1L, (long)Iterables.count((Iterable)transaction.getAllRelationshipTypes()));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void nodesWithIndexedProperties() {
        Label indexLabel = Label.label((String)"indexMarker");
        String propertyName = "property";
        String value = "value";
        int nodesCount = 100;
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < nodesCount; ++i) {
                Node node = transaction.createNode(new Label[]{indexLabel});
                node.setProperty(propertyName, (Object)value);
            }
            transaction.commit();
        }
        try (Transaction tx = this.database.beginTx();){
            tx.schema().indexFor(indexLabel).on(propertyName).create();
            tx.commit();
        }
        tx = this.database.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        transaction = this.database.beginTx();
        try {
            Assertions.assertEquals((long)nodesCount, (long)Iterators.count((Iterator)transaction.findNodes(indexLabel, propertyName, (Object)value)));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void nodesWithBigStringProperties() {
        Label label = Label.label((String)"marker");
        String propertyName = "property";
        int nodesCount = 10;
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < nodesCount; ++i) {
                Node node = transaction.createNode(new Label[]{label});
                node.setProperty(propertyName, (Object)RandomStringUtils.randomAlphabetic((int)((int)ByteUnit.mebiBytes((long)1L))));
            }
            transaction.commit();
        }
        transaction = this.database.beginTx();
        try {
            Assertions.assertEquals((long)nodesCount, (long)Iterators.count((Iterator)transaction.findNodes(label)));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void nodesWithBigArrayProperties() {
        Label label = Label.label((String)"marker");
        String propertyName = "property";
        int nodesCount = 10;
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < nodesCount; ++i) {
                Node node = transaction.createNode(new Label[]{label});
                node.setProperty(propertyName, (Object)RandomStringUtils.randomAlphabetic((int)((int)ByteUnit.mebiBytes((long)1L))).toCharArray());
            }
            transaction.commit();
        }
        transaction = this.database.beginTx();
        try {
            Assertions.assertEquals((long)nodesCount, (long)Iterators.count((Iterator)transaction.findNodes(label)));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }
}

