/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelections;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class RelationshipSelectionsIT {
    private static final RelationshipType relationshipType = RelationshipType.withName((String)"relType");
    @Inject
    private GraphDatabaseAPI database;

    @Test
    void tracePageCacheAccessOnOutgoingCursor() {
        long nodeId = this.getSparseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(CursorContext.NULL);){
                this.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                CursorContext cursorContext = kernelTransaction.cursorContext();
                this.assertZeroCursor(cursorContext);
                try (RelationshipTraversalCursor cursor = RelationshipSelections.outgoingCursor((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (CursorContext)cursorContext);){
                    this.consumeCursor(cursor);
                }
                this.assertOneCursor(cursorContext);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnIncomingCursor() {
        long nodeId = this.getSparseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(CursorContext.NULL);){
                this.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                CursorContext cursorContext = kernelTransaction.cursorContext();
                this.assertZeroCursor(cursorContext);
                try (RelationshipTraversalCursor cursor = RelationshipSelections.incomingCursor((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (CursorContext)cursorContext);){
                    this.consumeCursor(cursor);
                }
                this.assertOneCursor(cursorContext);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnAllCursor() {
        long nodeId = this.getSparseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(CursorContext.NULL);){
                this.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                CursorContext cursorContext = kernelTransaction.cursorContext();
                this.assertZeroCursor(cursorContext);
                try (RelationshipTraversalCursor cursor = RelationshipSelections.allCursor((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (CursorContext)cursorContext);){
                    this.consumeCursor(cursor);
                }
                this.assertOneCursor(cursorContext);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnOutgoingIterator() {
        long nodeId = this.getSparseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(CursorContext.NULL);){
                this.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                CursorContext cursorContext = kernelTransaction.cursorContext();
                this.assertZeroCursor(cursorContext);
                try (ResourceIterator iterator = RelationshipSelections.outgoingIterator((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (id, startNodeId, typeId1, endNodeId) -> id, (CursorContext)cursorContext);){
                    org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)Iterators.count((Iterator)iterator));
                }
                this.assertOneCursor(cursorContext);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnIncomingIterator() {
        long nodeId = this.getSparseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(CursorContext.NULL);){
                this.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                CursorContext cursorContext = kernelTransaction.cursorContext();
                this.assertZeroCursor(cursorContext);
                try (ResourceIterator iterator = RelationshipSelections.incomingIterator((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (id, startNodeId, typeId1, endNodeId) -> id, (CursorContext)cursorContext);){
                    org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)Iterators.count((Iterator)iterator));
                }
                this.assertOneCursor(cursorContext);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnAllIterator() {
        long nodeId = this.getSparseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(CursorContext.NULL);){
                this.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                CursorContext cursorContext = kernelTransaction.cursorContext();
                this.assertZeroCursor(cursorContext);
                try (ResourceIterator iterator = RelationshipSelections.allIterator((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (id, startNodeId, typeId1, endNodeId) -> id, (CursorContext)cursorContext);){
                    org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)Iterators.count((Iterator)iterator));
                }
                this.assertOneCursor(cursorContext);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnOutgoingDenseCursor() {
        long nodeId = this.getDenseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(CursorContext.NULL);){
                this.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                CursorContext cursorContext = kernelTransaction.cursorContext();
                this.assertZeroCursor(cursorContext);
                try (RelationshipTraversalCursor cursor = RelationshipSelections.outgoingCursor((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (CursorContext)cursorContext);){
                    this.consumeCursor(cursor);
                }
                this.assertTwoCursor(cursorContext);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnIncomingDenseCursor() {
        long nodeId = this.getDenseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(CursorContext.NULL);){
                this.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                CursorContext cursorContext = kernelTransaction.cursorContext();
                this.assertZeroCursor(cursorContext);
                try (RelationshipTraversalCursor cursor = RelationshipSelections.incomingCursor((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (CursorContext)cursorContext);){
                    this.consumeCursor(cursor);
                }
                this.assertTwoCursor(cursorContext);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnAllDenseCursor() {
        long nodeId = this.getDenseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(CursorContext.NULL);){
                this.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                CursorContext cursorContext = kernelTransaction.cursorContext();
                this.assertZeroCursor(cursorContext);
                try (RelationshipTraversalCursor cursor = RelationshipSelections.allCursor((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (CursorContext)cursorContext);){
                    this.consumeCursor(cursor);
                }
                this.assertTwoCursor(cursorContext);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnOutgoingDenseIterator() {
        long nodeId = this.getDenseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(CursorContext.NULL);){
                this.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                CursorContext cursorContext = kernelTransaction.cursorContext();
                this.assertZeroCursor(cursorContext);
                try (ResourceIterator iterator = RelationshipSelections.outgoingIterator((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (id, startNodeId, typeId1, endNodeId) -> id, (CursorContext)cursorContext);){
                    org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)Iterators.count((Iterator)iterator));
                }
                this.assertTwoCursor(cursorContext);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnIncomingDenseIterator() {
        long nodeId = this.getDenseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(CursorContext.NULL);){
                this.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                CursorContext cursorContext = kernelTransaction.cursorContext();
                this.assertZeroCursor(cursorContext);
                try (ResourceIterator iterator = RelationshipSelections.incomingIterator((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (id, startNodeId, typeId1, endNodeId) -> id, (CursorContext)cursorContext);){
                    org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)Iterators.count((Iterator)iterator));
                }
                this.assertTwoCursor(cursorContext);
            }
        }
    }

    @Test
    void tracePageCacheAccessOnAllDenseIterator() {
        long nodeId = this.getDenseNodeId();
        try (Transaction transaction = this.database.beginTx();){
            KernelTransaction kernelTransaction = ((InternalTransaction)transaction).kernelTransaction();
            CursorFactory cursors = kernelTransaction.cursors();
            int typeId = kernelTransaction.tokenRead().relationshipType(relationshipType.name());
            try (NodeCursor nodeCursor = cursors.allocateNodeCursor(CursorContext.NULL);){
                this.setNodeCursor(nodeId, kernelTransaction, nodeCursor);
                CursorContext cursorContext = kernelTransaction.cursorContext();
                this.assertZeroCursor(cursorContext);
                try (ResourceIterator iterator = RelationshipSelections.allIterator((CursorFactory)cursors, (NodeCursor)nodeCursor, (int[])new int[]{typeId}, (id, startNodeId, typeId1, endNodeId) -> id, (CursorContext)cursorContext);){
                    org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)Iterators.count((Iterator)iterator));
                }
                this.assertTwoCursor(cursorContext);
            }
        }
    }

    private long getSparseNodeId() {
        try (Transaction tx = this.database.beginTx();){
            Node source = tx.createNode();
            Node endNode1 = tx.createNode();
            Node endNode2 = tx.createNode();
            source.createRelationshipTo(endNode1, relationshipType);
            source.createRelationshipTo(endNode2, relationshipType);
            endNode1.createRelationshipTo(source, relationshipType);
            endNode2.createRelationshipTo(source, relationshipType);
            long nodeId = source.getId();
            tx.commit();
            long l = nodeId;
            return l;
        }
    }

    private long getDenseNodeId() {
        try (Transaction tx = this.database.beginTx();){
            Node source = tx.createNode();
            Node endNode1 = tx.createNode();
            Node endNode2 = tx.createNode();
            source.createRelationshipTo(endNode1, relationshipType);
            source.createRelationshipTo(endNode2, relationshipType);
            endNode1.createRelationshipTo(source, relationshipType);
            endNode2.createRelationshipTo(source, relationshipType);
            RelationshipType other = RelationshipType.withName((String)"other");
            for (int i = 0; i < 100; ++i) {
                Node node = tx.createNode();
                source.createRelationshipTo(node, other);
            }
            long nodeId = source.getId();
            tx.commit();
            long l = nodeId;
            return l;
        }
    }

    private void setNodeCursor(long nodeId, KernelTransaction kernelTransaction, NodeCursor nodeCursor) {
        kernelTransaction.dataRead().singleNode(nodeId, nodeCursor);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)nodeCursor.next());
    }

    private void consumeCursor(RelationshipTraversalCursor cursor) {
        while (cursor.next()) {
        }
    }

    private void assertTwoCursor(CursorContext cursorContext) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(2L);
        Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(2L);
        Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(2L);
    }

    private void assertOneCursor(CursorContext cursorContext) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.hits()).isOne();
        Assertions.assertThat((long)cursorTracer.pins()).isOne();
        Assertions.assertThat((long)cursorTracer.unpins()).isOne();
    }

    private void assertZeroCursor(CursorContext cursorContext) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.hits()).isZero();
        Assertions.assertThat((long)cursorTracer.pins()).isZero();
        Assertions.assertThat((long)cursorTracer.unpins()).isZero();
        Assertions.assertThat((long)cursorTracer.faults()).isZero();
    }
}

