/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.configuration.Config;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.TokenIndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

@Ignore(value="Not a test. This is a compatibility suite that provides test cases for verifying IndexProvider implementations. Each index provider that is to be tested by this suite must create their own test class extending TokenIndexProviderCompatibilityTestSuite. The @Ignore annotation doesn't prevent these tests to run, it rather removes some annoying errors or warnings in some IDEs about test classes needing a public zero-arg constructor.")
public class TokenIndexPopulatorCompatibility
extends TokenIndexProviderCompatibilityTestSuite.Compatibility {
    public TokenIndexPopulatorCompatibility(TokenIndexProviderCompatibilityTestSuite testSuite) {
        super(testSuite, testSuite.indexPrototype());
    }

    @Test
    public void shouldStorePopulationFailedForRetrievalFromProviderLater() throws Exception {
        String failure = "The contrived failure";
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.markAsFailed(failure)), false);
        Assertions.assertThat((String)this.indexProvider.getPopulationFailure(this.descriptor, CursorContext.NULL)).contains(new CharSequence[]{failure});
    }

    @Test
    public void shouldReportInitialStateAsFailedIfPopulationFailed() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            String failure = "The contrived failure";
            p.markAsFailed(failure);
            p.close(false, CursorContext.NULL);
            Assert.assertEquals((Object)InternalIndexState.FAILED, (Object)this.indexProvider.getInitialState(this.descriptor, CursorContext.NULL));
        }), false);
    }

    @Test
    public void shouldBeAbleToDropAClosedIndexPopulator() {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        IndexPopulator p = this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        p.close(false, CursorContext.NULL);
        p.drop();
    }
}

