/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.TestKernelReadTracer;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class KernelReadTracerTxStateTest
extends KernelAPIWriteTestBase<WriteTestSupport> {
    KernelReadTracerTxStateTest() {
    }

    @Test
    void shouldTraceAllNodesScan() throws Exception {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             NodeCursor cursor = tx.cursors().allocateNodeCursor(tx.cursorContext());){
            tx.dataWrite().nodeCreate();
            tx.dataWrite().nodeCreate();
            cursor.setTracer((KernelReadTracer)tracer);
            tx.dataRead().allNodesScan(cursor);
            tracer.assertEvents(TestKernelReadTracer.ON_ALL_NODES_SCAN);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnNode(cursor.nodeReference()));
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnNode(cursor.nodeReference()));
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTraceLabelScan() throws KernelException {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(CursorContext.NULL);){
            int barId = tx.tokenWrite().labelGetOrCreateForName("Bar");
            long n = tx.dataWrite().nodeCreate();
            tx.dataWrite().nodeAddLabel(n, barId);
            cursor.setTracer((KernelReadTracer)tracer);
            tx.dataRead().nodeLabelScan(KernelReadTracerTxStateTest.getTokenReadSession(tx, EntityType.NODE), cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(barId));
            tracer.assertEvents(TestKernelReadTracer.OnLabelScan(barId));
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnNode(cursor.nodeReference()));
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTraceIndexSeek() throws KernelException {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        String indexName = this.createIndex("User", "name");
        try (KernelTransaction tx = this.beginTransaction();
             NodeValueIndexCursor cursor = tx.cursors().allocateNodeValueIndexCursor(CursorContext.NULL, tx.memoryTracker());){
            int name = tx.token().propertyKey("name");
            int user = tx.token().nodeLabel("User");
            long n = tx.dataWrite().nodeCreate();
            tx.dataWrite().nodeAddLabel(n, user);
            tx.dataWrite().nodeSetProperty(n, name, (Value)Values.stringValue((String)"Bosse"));
            IndexDescriptor index = tx.schemaRead().indexGetForName(indexName);
            IndexReadSession session = tx.dataRead().indexReadSession(index);
            this.assertIndexSeekTracing(tracer, tx, cursor, session, IndexOrder.NONE, false, user);
            this.assertIndexSeekTracing(tracer, tx, cursor, session, IndexOrder.NONE, true, user);
            this.assertIndexSeekTracing(tracer, tx, cursor, session, IndexOrder.ASCENDING, false, user);
            this.assertIndexSeekTracing(tracer, tx, cursor, session, IndexOrder.ASCENDING, true, user);
        }
    }

    private void assertIndexSeekTracing(TestKernelReadTracer tracer, KernelTransaction tx, NodeValueIndexCursor cursor, IndexReadSession session, IndexOrder order, boolean needsValues, int user) throws KernelException {
        cursor.setTracer((KernelReadTracer)tracer);
        tx.dataRead().nodeIndexSeek(session, cursor, IndexQueryConstraints.constrained((IndexOrder)order, (boolean)needsValues), new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)user, (TextValue)Values.stringValue((String)"B"))});
        tracer.assertEvents(TestKernelReadTracer.OnIndexSeek());
        Assertions.assertTrue((boolean)cursor.next());
        tracer.assertEvents(TestKernelReadTracer.OnNode(cursor.nodeReference()));
        Assertions.assertFalse((boolean)cursor.next());
        tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
    }

    @Test
    void shouldTraceSingleRelationship() throws Exception {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(tx.cursorContext());){
            long n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            long r = tx.dataWrite().relationshipCreate(n1, tx.token().relationshipTypeGetOrCreateForName("R"), n2);
            cursor.setTracer((KernelReadTracer)tracer);
            tx.dataRead().singleRelationship(r, cursor);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnRelationship(r));
            long deleted = tx.dataWrite().relationshipCreate(n1, tx.token().relationshipTypeGetOrCreateForName("R"), n2);
            tx.dataWrite().relationshipDelete(deleted);
            tx.dataRead().singleRelationship(deleted, cursor);
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTraceRelationshipTraversal() throws Exception {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());
             RelationshipTraversalCursor cursor = tx.cursors().allocateRelationshipTraversalCursor(tx.cursorContext());){
            long n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            long r = tx.dataWrite().relationshipCreate(n1, tx.token().relationshipTypeGetOrCreateForName("R"), n2);
            cursor.setTracer((KernelReadTracer)tracer);
            tx.dataRead().singleNode(n1, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.relationships(cursor, RelationshipSelection.ALL_RELATIONSHIPS);
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnRelationship(r));
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTracePropertyAccess() throws Exception {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
            long n = tx.dataWrite().nodeCreate();
            int name = tx.token().propertyKey("name");
            tx.dataWrite().nodeSetProperty(n, name, (Value)Values.stringValue((String)"Bosse"));
            propertyCursor.setTracer((KernelReadTracer)tracer);
            tx.dataRead().singleNode(n, nodeCursor);
            Assertions.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor);
            Assertions.assertTrue((boolean)propertyCursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnProperty(name));
            Assertions.assertFalse((boolean)propertyCursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTraceRelationshipIndexCursor() throws KernelException, TimeoutException {
        IndexDescriptor index;
        int name;
        int connection;
        String indexName = "myIndex";
        try (KernelTransaction tx = this.beginTransaction();){
            connection = tx.tokenWrite().relationshipTypeGetOrCreateForName("Connection");
            name = tx.tokenWrite().propertyKeyGetOrCreateForName("name");
            tx.commit();
        }
        tx = this.beginTransaction();
        try {
            FulltextSchemaDescriptor schema = SchemaDescriptor.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])this.array(connection), (int[])this.array(name));
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema, (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR).withName(indexName).withIndexType(IndexType.FULLTEXT);
            index = tx.schemaWrite().indexCreate(prototype);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.beginTransaction();
        try {
            Predicates.awaitEx(() -> tx.schemaRead().indexGetState(index) == InternalIndexState.ONLINE, (long)1L, (TimeUnit)TimeUnit.MINUTES);
            long n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            long r = tx.dataWrite().relationshipCreate(n1, connection, n2);
            tx.dataWrite().relationshipSetProperty(r, name, (Value)Values.stringValue((String)"transformational"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             RelationshipValueIndexCursor cursor = tx.cursors().allocateRelationshipValueIndexCursor(CursorContext.NULL, tx.memoryTracker());){
            cursor.setTracer((KernelReadTracer)tracer);
            IndexReadSession indexReadSession = tx.dataRead().indexReadSession(index);
            tx.dataRead().relationshipIndexSeek(indexReadSession, cursor, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.fulltextSearch((String)"transformational")});
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnIndexSeek(), TestKernelReadTracer.OnRelationship(cursor.relationshipReference()));
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    @Test
    void shouldTraceRelationshipTypeScan() throws KernelException {
        TestKernelReadTracer tracer = new TestKernelReadTracer();
        try (KernelTransaction tx = this.beginTransaction();
             RelationshipTypeIndexCursor cursor = tx.cursors().allocateRelationshipTypeIndexCursor(CursorContext.NULL);){
            int rType = tx.token().relationshipTypeGetOrCreateForName("R");
            long n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            tx.dataWrite().relationshipCreate(n1, rType, n2);
            cursor.setTracer((KernelReadTracer)tracer);
            tx.dataRead().relationshipTypeScan(KernelReadTracerTxStateTest.getTokenReadSession(tx, EntityType.RELATIONSHIP), cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(rType));
            tracer.assertEvents(TestKernelReadTracer.OnRelationshipTypeScan(rType));
            Assertions.assertTrue((boolean)cursor.next());
            tracer.assertEvents(TestKernelReadTracer.OnRelationship(cursor.relationshipReference()));
            Assertions.assertFalse((boolean)cursor.next());
            tracer.assertEvents(new TestKernelReadTracer.TraceEvent[0]);
        }
    }

    private static TokenReadSession getTokenReadSession(KernelTransaction tx, EntityType entityType) throws IndexNotFoundKernelException {
        Iterator indexes = tx.schemaRead().index((SchemaDescriptor)SchemaDescriptor.forAnyEntityTokens((EntityType)entityType));
        IndexDescriptor index = (IndexDescriptor)indexes.next();
        Assertions.assertFalse((boolean)indexes.hasNext());
        return tx.dataRead().tokenReadSession(index);
    }

    private int[] array(int ... elements) {
        return elements;
    }

    private String createIndex(String label, String propertyKey) {
        String indexName;
        try (Transaction tx = graphDb.beginTx();){
            indexName = tx.schema().indexFor(Label.label((String)label)).on(propertyKey).create().getName();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        return indexName;
    }

    @Override
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }
}

