/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.admin.commands;

import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableObject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.mockito.Mockito;
import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.admin.security.SetDefaultAdminCommand;
import org.neo4j.commandline.admin.security.SetInitialPasswordCommand;
import org.neo4j.commandline.dbms.DiagnosticsReportCommand;
import org.neo4j.commandline.dbms.DumpCommand;
import org.neo4j.commandline.dbms.LoadCommand;
import org.neo4j.commandline.dbms.MemoryRecommendationsCommand;
import org.neo4j.commandline.dbms.StoreInfoCommand;
import org.neo4j.commandline.dbms.UnbindCommand;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.consistency.CheckConsistencyCommand;
import org.neo4j.dbms.archive.Dumper;
import org.neo4j.dbms.archive.Loader;
import org.neo4j.importer.ImportCommand;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import picocli.CommandLine;

@TestDirectoryExtension
@DisabledOnOs(value={OS.WINDOWS})
class AdminCommandsIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;
    private Path confDir;
    private PrintStream out;
    private PrintStream err;
    private ExecutionContext context;
    private Path home;

    AdminCommandsIT() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.out = (PrintStream)Mockito.mock(PrintStream.class);
        this.err = (PrintStream)Mockito.mock(PrintStream.class);
        this.confDir = this.testDirectory.directory("test.conf");
        this.home = this.testDirectory.homePath("home");
        this.context = new ExecutionContext(this.home, this.confDir, this.out, this.err, this.testDirectory.getFileSystem());
        Path configFile = this.confDir.resolve("neo4j.conf");
        Files.createFile(configFile, PosixFilePermissions.asFileAttribute(Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE)));
        GraphDatabaseSettings.strict_config_validation.name();
        Files.write(configFile, (BootloaderSettings.initial_heap_size.name() + "=$(expr 500)").getBytes(), new OpenOption[0]);
    }

    @Test
    void shouldExpandCommands() throws Exception {
        AdminCommandsIT.assertSuccess((AbstractCommand)new SetInitialPasswordCommand(this.context), "--expand-commands", "pass");
        AdminCommandsIT.assertSuccess((AbstractCommand)new SetDefaultAdminCommand(this.context), "--expand-commands", "admin");
        AdminCommandsIT.assertSuccess((AbstractCommand)new StoreInfoCommand(this.context), "--expand-commands", "path");
        AdminCommandsIT.assertSuccess((AbstractCommand)new CheckConsistencyCommand(this.context), "--expand-commands", "--database", "neo4j");
        AdminCommandsIT.assertSuccess((AbstractCommand)new DiagnosticsReportCommand(this.context), "--expand-commands");
        AdminCommandsIT.assertSuccess((AbstractCommand)new LoadCommand(this.context, new Loader()), "--expand-commands", "--from", "test");
        AdminCommandsIT.assertSuccess((AbstractCommand)new MemoryRecommendationsCommand(this.context), "--expand-commands");
        AdminCommandsIT.assertSuccess((AbstractCommand)new DumpCommand(this.context, new Dumper(this.context.err())), "--expand-commands", "--to", "test");
        AdminCommandsIT.assertSuccess((AbstractCommand)new UnbindCommand(this.context), "--expand-commands");
    }

    @Test
    void shouldNotExpandCommands() {
        AdminCommandsIT.assertExpansionError((AbstractCommand)new SetInitialPasswordCommand(this.context), "pass");
        AdminCommandsIT.assertExpansionError((AbstractCommand)new SetDefaultAdminCommand(this.context), "user");
        AdminCommandsIT.assertExpansionError((AbstractCommand)new StoreInfoCommand(this.context), "path");
        AdminCommandsIT.assertExpansionError((AbstractCommand)new CheckConsistencyCommand(this.context), "--database", "neo4j");
        AdminCommandsIT.assertExpansionError((AbstractCommand)new DiagnosticsReportCommand(this.context), new String[0]);
        AdminCommandsIT.assertExpansionError((AbstractCommand)new LoadCommand(this.context, new Loader()), "--from", "test");
        AdminCommandsIT.assertExpansionError((AbstractCommand)new MemoryRecommendationsCommand(this.context), new String[0]);
        AdminCommandsIT.assertExpansionError((AbstractCommand)new ImportCommand(this.context), "--nodes=" + this.testDirectory.createFile("foo.csv").toAbsolutePath());
        AdminCommandsIT.assertExpansionError((AbstractCommand)new DumpCommand(this.context, new Dumper(this.context.err())), "--to", "test");
        AdminCommandsIT.assertExpansionError((AbstractCommand)new UnbindCommand(this.context), new String[0]);
    }

    private static void assertSuccess(AbstractCommand command, String ... args) throws Exception {
        ((AbstractCommand)CommandLine.populateCommand((Object)command, (String[])args)).call();
    }

    private static void assertExpansionError(AbstractCommand command, String ... args) {
        MutableObject exception = new MutableObject();
        new CommandLine((Object)command).setExecutionExceptionHandler((ex, commandLine, parseResult) -> {
            exception.setValue((Object)ex);
            return 1;
        }).execute(args);
        Assertions.assertThat((Throwable)((Throwable)exception.getValue())).hasMessageContaining("is a command, but config is not explicitly told to expand it.");
    }
}

