/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.newapi.TestUtils;
import org.neo4j.util.concurrent.Futures;

public abstract class ParallelNodeLabelScanTransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private static final ToLongFunction<NodeLabelIndexCursor> NODE_GET = NodeIndexCursor::nodeReference;

    @Test
    void shouldHandleEmptyDatabase() throws KernelException {
        try (KernelTransaction tx = ParallelNodeLabelScanTransactionStateTestBase.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("L");
            CursorContext cursorContext = tx.cursorContext();
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(cursorContext);){
                Scan scan = tx.dataRead().nodeLabelScan(label);
                while (scan.reserveBatch((Cursor)cursor, 23, cursorContext, tx.securityContext().mode())) {
                    Assertions.assertFalse((boolean)cursor.next());
                }
            }
        }
    }

    @Test
    void scanShouldNotSeeDeletedNode() throws Exception {
        Object write;
        int size = 1000;
        HashSet<Long> created = new HashSet<Long>(size);
        HashSet<Long> deleted = new HashSet<Long>(size);
        int label = ParallelNodeLabelScanTransactionStateTestBase.label("L");
        try (KernelTransaction tx = ParallelNodeLabelScanTransactionStateTestBase.beginTransaction();){
            write = tx.dataWrite();
            for (int i = 0; i < size; ++i) {
                long createId = write.nodeCreate();
                long deleteId = write.nodeCreate();
                write.nodeAddLabel(createId, label);
                write.nodeAddLabel(deleteId, label);
                created.add(createId);
                deleted.add(deleteId);
            }
            tx.commit();
        }
        tx = ParallelNodeLabelScanTransactionStateTestBase.beginTransaction();
        try {
            write = deleted.iterator();
            while (write.hasNext()) {
                long delete = (Long)write.next();
                tx.dataWrite().nodeDelete(delete);
            }
            CursorContext cursorContext = tx.cursorContext();
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(cursorContext);){
                Scan scan = tx.dataRead().nodeLabelScan(label);
                HashSet<Long> seen = new HashSet<Long>();
                while (scan.reserveBatch((Cursor)cursor, 128, cursorContext, tx.securityContext().mode())) {
                    while (cursor.next()) {
                        long nodeId = cursor.nodeReference();
                        Assertions.assertTrue((boolean)seen.add(nodeId));
                        Assertions.assertTrue((boolean)created.remove(nodeId));
                    }
                }
                Assertions.assertTrue((boolean)created.isEmpty());
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void scanShouldSeeAddedNodes() throws Exception {
        int size = 64;
        int label = ParallelNodeLabelScanTransactionStateTestBase.label("L");
        MutableLongSet existing = LongSets.mutable.withAll((LongIterable)ParallelNodeLabelScanTransactionStateTestBase.createNodesWithLabel(label, size));
        try (KernelTransaction tx = ParallelNodeLabelScanTransactionStateTestBase.beginTransaction();){
            MutableLongSet added = LongSets.mutable.withAll((LongIterable)ParallelNodeLabelScanTransactionStateTestBase.createNodesWithLabel(tx.dataWrite(), label, size));
            CursorContext cursorContext = tx.cursorContext();
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(cursorContext);){
                Scan scan = tx.dataRead().nodeLabelScan(label);
                HashSet<Long> seen = new HashSet<Long>();
                while (scan.reserveBatch((Cursor)cursor, 64, cursorContext, tx.securityContext().mode())) {
                    while (cursor.next()) {
                        long nodeId = cursor.nodeReference();
                        Assertions.assertTrue((boolean)seen.add(nodeId), (String)String.format("%d was seen multiple times", nodeId));
                        Assertions.assertTrue((existing.remove(nodeId) || added.remove(nodeId) ? 1 : 0) != 0);
                    }
                }
                Assertions.assertTrue((boolean)existing.isEmpty());
                Assertions.assertTrue((boolean)added.isEmpty());
            }
        }
    }

    @Test
    void shouldReserveBatchFromTxState() throws KernelException {
        try (KernelTransaction tx = ParallelNodeLabelScanTransactionStateTestBase.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("L");
            ParallelNodeLabelScanTransactionStateTestBase.createNodesWithLabel(tx.dataWrite(), label, 11);
            CursorContext cursorContext = tx.cursorContext();
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(cursorContext);){
                Scan scan = tx.dataRead().nodeLabelScan(label);
                AccessMode accessMode = tx.securityContext().mode();
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 5, cursorContext, accessMode));
                Assertions.assertEquals((int)5, (int)TestUtils.count((Cursor)cursor));
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 4, cursorContext, accessMode));
                Assertions.assertEquals((int)4, (int)TestUtils.count((Cursor)cursor));
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 6, cursorContext, accessMode));
                Assertions.assertEquals((int)2, (int)TestUtils.count((Cursor)cursor));
                while (scan.reserveBatch((Cursor)cursor, 3, cursorContext, accessMode)) {
                    Assertions.assertFalse((boolean)cursor.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromMultipleThreads() throws InterruptedException, ExecutionException, KernelException {
        int numberOfWorkers = 4;
        ExecutorService service = Executors.newFixedThreadPool(numberOfWorkers);
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        int size = 1024;
        try (KernelTransaction tx = ParallelNodeLabelScanTransactionStateTestBase.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("L");
            LongList ids = ParallelNodeLabelScanTransactionStateTestBase.createNodesWithLabel(tx.dataWrite(), label, size);
            Read read = tx.dataRead();
            Scan scan = read.nodeLabelScan(label);
            List workers = TestUtils.createContexts(tx, arg_0 -> ((CursorFactory)cursors).allocateNodeLabelIndexCursor(arg_0), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(size / numberOfWorkers, scan, numberOfWorkers, workers, NODE_GET));
            List lists = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workers);
            TestUtils.assertDistinct(lists);
            LongList concat = TestUtils.concat(lists);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)concat.toSortedList());
            tx.rollback();
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllNodesFromRandomlySizedWorkers() throws InterruptedException, KernelException, ExecutionException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        int size = 2000;
        try (KernelTransaction tx = ParallelNodeLabelScanTransactionStateTestBase.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("L");
            LongList ids = ParallelNodeLabelScanTransactionStateTestBase.createNodesWithLabel(tx.dataWrite(), label, size);
            Read read = tx.dataRead();
            Scan scan = read.nodeLabelScan(label);
            CursorFactory cursors = testSupport.kernelToTest().cursors();
            int numberOfWorkers = 10;
            List workers = TestUtils.createContexts(tx, arg_0 -> ((CursorFactory)cursors).allocateNodeLabelIndexCursor(arg_0), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createRandomWorkers(scan, numberOfWorkers, workers, NODE_GET));
            List lists = Futures.getAllResults(futures);
            TestUtils.assertDistinct(lists);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)TestUtils.concat(lists).toSortedList());
            tx.rollback();
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void parallelTxStateScanStressTest() throws KernelException, InterruptedException, ExecutionException {
        int label = ParallelNodeLabelScanTransactionStateTestBase.label("L");
        MutableLongSet existingNodes = LongSets.mutable.withAll((LongIterable)ParallelNodeLabelScanTransactionStateTestBase.createNodesWithLabel(label, 1000));
        int numberOfWorkers = Runtime.getRuntime().availableProcessors();
        ExecutorService threadPool = Executors.newFixedThreadPool(numberOfWorkers);
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        try {
            for (int i = 0; i < 1000; ++i) {
                MutableLongSet allNodes = LongSets.mutable.withAll((LongIterable)existingNodes);
                try (KernelTransaction tx = ParallelNodeLabelScanTransactionStateTestBase.beginTransaction();){
                    int nodeInTx = random.nextInt(1000);
                    allNodes.addAll((LongIterable)ParallelNodeLabelScanTransactionStateTestBase.createNodesWithLabel(tx.dataWrite(), label, nodeInTx));
                    Scan scan = tx.dataRead().nodeLabelScan(label);
                    List workers = TestUtils.createContexts(tx, arg_0 -> ((CursorFactory)cursors).allocateNodeLabelIndexCursor(arg_0), numberOfWorkers);
                    List<Future<LongList>> futures = threadPool.invokeAll(TestUtils.createRandomWorkers(scan, numberOfWorkers, workers, NODE_GET));
                    List lists = Futures.getAllResults(futures);
                    TestUtils.assertDistinct(lists);
                    LongList concat = TestUtils.concat(lists);
                    Assertions.assertEquals((Object)allNodes, (Object)LongSets.immutable.withAll((LongIterable)concat), (String)String.format("nodes=%d, seen=%d, all=%d", nodeInTx, concat.size(), allNodes.size()));
                    Assertions.assertEquals((int)allNodes.size(), (int)concat.size(), (String)String.format("nodes=%d", nodeInTx));
                    continue;
                }
            }
        }
        finally {
            threadPool.shutdown();
            threadPool.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    private static LongList createNodesWithLabel(int label, int size) throws KernelException {
        LongList ids;
        try (KernelTransaction tx = ParallelNodeLabelScanTransactionStateTestBase.beginTransaction();){
            Write write = tx.dataWrite();
            ids = ParallelNodeLabelScanTransactionStateTestBase.createNodesWithLabel(write, label, size);
            tx.commit();
        }
        return ids;
    }

    private static LongList createNodesWithLabel(Write write, int label, int size) throws KernelException {
        MutableLongList ids = LongLists.mutable.empty();
        for (int i = 0; i < size; ++i) {
            long node = write.nodeCreate();
            write.nodeAddLabel(node, label);
            ids.add(node);
        }
        return ids;
    }

    private static int label(String name) throws KernelException {
        int label;
        try (KernelTransaction tx = ParallelNodeLabelScanTransactionStateTestBase.beginTransaction();){
            label = tx.tokenWrite().labelGetOrCreateForName(name);
            tx.commit();
        }
        return label;
    }
}

