/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.exceptions.FrozenLocksException;
import org.neo4j.internal.kernel.api.exceptions.LocksNotFrozenException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;

abstract class TransactionTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    TransactionTestBase() {
    }

    @Test
    void shouldRollbackWhenTxIsNotSuccess() throws Exception {
        long nodeId;
        try (KernelTransaction tx = TransactionTestBase.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.tokenWrite().labelGetOrCreateForName("labello");
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
        }
        TransactionTestBase.assertNoNode(nodeId);
    }

    @Test
    void shouldRollbackWhenTxIsFailed() throws Exception {
        long nodeId;
        try (KernelTransaction tx = TransactionTestBase.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.tokenWrite().labelGetOrCreateForName("labello");
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
            tx.rollback();
        }
        TransactionTestBase.assertNoNode(nodeId);
    }

    @Test
    void shouldFreezeLockInteractions() throws Exception {
        LabelSchemaDescriptor schema;
        try (KernelTransaction tx = TransactionTestBase.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("Label");
            int propertyKey = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            schema = SchemaDescriptors.forLabel((int)label, (int[])new int[]{propertyKey});
            tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema).withName("my index"));
            tx.commit();
        }
        tx = TransactionTestBase.beginTransaction();
        try {
            TransactionTestBase.assertAllowedLocks(tx, (SchemaDescriptor)schema);
            tx.freezeLocks();
            TransactionTestBase.assertFrozenLocks(tx, (SchemaDescriptor)schema);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThawLockInteractions() throws Exception {
        LabelSchemaDescriptor schema;
        try (KernelTransaction tx = TransactionTestBase.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("Label");
            int propertyKey = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            schema = SchemaDescriptors.forLabel((int)label, (int[])new int[]{propertyKey});
            tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema).withName("my index"));
            tx.commit();
        }
        tx = TransactionTestBase.beginTransaction();
        try {
            tx.freezeLocks();
            tx.thawLocks();
            TransactionTestBase.assertAllowedLocks(tx, (SchemaDescriptor)schema);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowOnThawOfNotFrozenLocks() throws Exception {
        LabelSchemaDescriptor schema;
        try (KernelTransaction tx = TransactionTestBase.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("Label");
            int propertyKey = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            schema = SchemaDescriptors.forLabel((int)label, (int[])new int[]{propertyKey});
            tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema).withName("my index"));
            tx.commit();
        }
        tx = TransactionTestBase.beginTransaction();
        try {
            Assertions.assertThrows(LocksNotFrozenException.class, () -> ((KernelTransaction)tx).thawLocks());
            TransactionTestBase.assertAllowedLocks(tx, (SchemaDescriptor)schema);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNestFreezeLocks() throws Exception {
        LabelSchemaDescriptor schema;
        try (KernelTransaction tx = TransactionTestBase.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("Label");
            int propertyKey = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            schema = SchemaDescriptors.forLabel((int)label, (int[])new int[]{propertyKey});
            tx.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)schema).withName("my index"));
            tx.commit();
        }
        tx = TransactionTestBase.beginTransaction();
        try {
            tx.freezeLocks();
            tx.freezeLocks();
            tx.freezeLocks();
            tx.freezeLocks();
            TransactionTestBase.assertFrozenLocks(tx, (SchemaDescriptor)schema);
            tx.thawLocks();
            TransactionTestBase.assertFrozenLocks(tx, (SchemaDescriptor)schema);
            tx.thawLocks();
            TransactionTestBase.assertFrozenLocks(tx, (SchemaDescriptor)schema);
            tx.thawLocks();
            TransactionTestBase.assertFrozenLocks(tx, (SchemaDescriptor)schema);
            tx.thawLocks();
            TransactionTestBase.assertAllowedLocks(tx, (SchemaDescriptor)schema);
            tx.freezeLocks();
            TransactionTestBase.assertFrozenLocks(tx, (SchemaDescriptor)schema);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCommitOnFrozenLocks() throws Exception {
        long node;
        try (KernelTransaction tx = TransactionTestBase.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.freezeLocks();
            tx.commit();
        }
        TransactionTestBase.assertNodeExists(node);
    }

    private static void assertAllowedLocks(KernelTransaction tx, SchemaDescriptor schema) {
        tx.schemaRead().index(schema).forEachRemaining(index -> {});
    }

    private static void assertFrozenLocks(KernelTransaction tx, SchemaDescriptor schema) {
        Assertions.assertThrows(FrozenLocksException.class, () -> tx.schemaRead().index(schema).forEachRemaining(index -> {}));
    }

    private static void assertNoNode(long nodeId) throws TransactionFailureException {
        try (KernelTransaction tx = TransactionTestBase.beginTransaction();
             NodeCursor cursor = tx.cursors().allocateNodeCursor(CursorContext.NULL);){
            tx.dataRead().singleNode(nodeId, cursor);
            Assertions.assertFalse((boolean)cursor.next());
        }
    }

    private static void assertNodeExists(long nodeId) throws TransactionFailureException {
        try (KernelTransaction tx = TransactionTestBase.beginTransaction();
             NodeCursor cursor = tx.cursors().allocateNodeCursor(CursorContext.NULL);){
            tx.dataRead().singleNode(nodeId, cursor);
            Assertions.assertTrue((boolean)cursor.next());
        }
    }
}

