/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.IndexTransactionStateTestBase;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class NodeIndexTransactionStateTest
extends IndexTransactionStateTestBase {
    private static final String DEFAULT_LABEL = "Node";

    @Override
    Pair<Long, Value> entityWithProp(KernelTransaction tx, Object value) throws Exception {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        write.nodeAddLabel(node, tx.tokenWrite().labelGetOrCreateForName(DEFAULT_LABEL));
        Value val = Values.of((Object)value);
        write.nodeSetProperty(node, tx.tokenWrite().propertyKeyGetOrCreateForName("prop"), val);
        return Pair.of((Object)node, (Object)val);
    }

    @Override
    void createIndex(IndexType indexType) {
        try (Transaction tx = graphDb.beginTx();){
            tx.schema().indexFor(Label.label((String)DEFAULT_LABEL)).on("prop").withIndexType(indexType).withName("myIndex").create();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    void deleteEntity(KernelTransaction tx, long entity) throws Exception {
        tx.dataWrite().nodeDelete(entity);
    }

    @Override
    boolean entityExists(KernelTransaction tx, long entity) {
        return tx.dataRead().nodeExists(entity);
    }

    @Override
    void removeProperty(KernelTransaction tx, long entity) throws Exception {
        int propertyKey = tx.tokenRead().propertyKey("prop");
        tx.dataWrite().nodeRemoveProperty(entity, propertyKey);
    }

    @Override
    void setProperty(KernelTransaction tx, long entity, Value value) throws Exception {
        int propertyKey = tx.tokenRead().propertyKey("prop");
        tx.dataWrite().nodeSetProperty(entity, propertyKey, value);
    }

    @Override
    void assertEntityAndValueForSeek(Set<Pair<Long, Value>> expected, KernelTransaction tx, IndexDescriptor index, boolean needsValues, Object anotherValueFoundByQuery, PropertyIndexQuery ... queries) throws Exception {
        try (NodeValueIndexCursor nodes = tx.cursors().allocateNodeValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
            IndexReadSession indexSession = tx.dataRead().indexReadSession(index);
            tx.dataRead().nodeIndexSeek(tx.queryContext(), indexSession, nodes, IndexQueryConstraints.unordered((boolean)needsValues), queries);
            this.assertEntityAndValue(expected, tx, needsValues, anotherValueFoundByQuery, new NodeCursorAdapter(nodes));
        }
    }

    @Override
    void assertEntityAndValueForScan(Set<Pair<Long, Value>> expected, KernelTransaction tx, IndexDescriptor index, boolean needsValues, Object anotherValueFoundByQuery) throws Exception {
        IndexReadSession indexSession = tx.dataRead().indexReadSession(index);
        try (NodeValueIndexCursor nodes = tx.cursors().allocateNodeValueIndexCursor(tx.cursorContext(), tx.memoryTracker());){
            tx.dataRead().nodeIndexScan(indexSession, nodes, IndexQueryConstraints.unordered((boolean)needsValues));
            this.assertEntityAndValue(expected, tx, needsValues, anotherValueFoundByQuery, new NodeCursorAdapter(nodes));
        }
    }

    private static class NodeCursorAdapter
    implements IndexTransactionStateTestBase.EntityValueIndexCursor {
        private final NodeValueIndexCursor nodes;

        NodeCursorAdapter(NodeValueIndexCursor nodes) {
            this.nodes = nodes;
        }

        @Override
        public boolean next() {
            return this.nodes.next();
        }

        @Override
        public Value propertyValue(int offset) {
            return this.nodes.propertyValue(offset);
        }

        @Override
        public long entityReference() {
            return this.nodes.nodeReference();
        }
    }
}

