/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.test.Race;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class ConsistentPropertyReadsIT {
    @Inject
    private GraphDatabaseService db;

    ConsistentPropertyReadsIT() {
    }

    @Test
    void shouldReadConsistentPropertyValues() throws Throwable {
        int i;
        Node[] nodes = new Node[10];
        String[] keys = new String[]{"1", "2", "3"};
        String[] values = new String[]{ConsistentPropertyReadsIT.longString('a'), ConsistentPropertyReadsIT.longString('b'), ConsistentPropertyReadsIT.longString('c')};
        try (Transaction tx = this.db.beginTx();){
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                nodes[i2] = tx.createNode();
                for (String key : keys) {
                    nodes[i2].setProperty(key, (Object)values[0]);
                }
            }
            tx.commit();
        }
        int updaters = 10;
        AtomicLong updatersDone = new AtomicLong(updaters);
        Race race = new Race();
        for (i = 0; i < updaters; ++i) {
            race.addContestant(() -> {
                try {
                    ThreadLocalRandom random = ThreadLocalRandom.current();
                    for (int j = 0; j < 100; ++j) {
                        Node node = nodes[random.nextInt(nodes.length)];
                        String key = keys[random.nextInt(keys.length)];
                        try (Transaction tx = this.db.beginTx();){
                            tx.getNodeById(node.getId()).removeProperty(key);
                            tx.commit();
                        }
                        tx = this.db.beginTx();
                        try {
                            tx.getNodeById(node.getId()).setProperty(key, (Object)values[random.nextInt(values.length)]);
                            tx.commit();
                            continue;
                        }
                        finally {
                            if (tx != null) {
                                tx.close();
                            }
                        }
                    }
                }
                finally {
                    updatersDone.decrementAndGet();
                }
            });
        }
        for (i = 0; i < 100; ++i) {
            race.addContestant(() -> {
                ThreadLocalRandom random = ThreadLocalRandom.current();
                while (updatersDone.get() > 0L) {
                    Transaction tx = this.db.beginTx();
                    try {
                        String value = (String)tx.getNodeById(nodes[random.nextInt(nodes.length)].getId()).getProperty(keys[random.nextInt(keys.length)], null);
                        Assertions.assertTrue((value == null || ArrayUtil.contains((Object[])values, (Object)value) ? 1 : 0) != 0, (String)value);
                        tx.commit();
                    }
                    finally {
                        if (tx == null) continue;
                        tx.close();
                    }
                }
            });
        }
        race.go();
    }

    private static String longString(char c) {
        char[] chars = new char[ThreadLocalRandom.current().nextInt(800, 1000)];
        Arrays.fill(chars, c);
        return new String(chars);
    }
}

