/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;

public abstract class NodeCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static List<Long> NODE_IDS;
    private static long foo;
    private static long bar;
    private static long baz;
    private static long barbaz;
    private static long bare;
    private static long gone;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        Node deleted;
        try (Transaction tx = graphDb.beginTx();){
            foo = tx.createNode(new Label[]{Label.label((String)"Foo")}).getId();
            bar = tx.createNode(new Label[]{Label.label((String)"Bar")}).getId();
            baz = tx.createNode(new Label[]{Label.label((String)"Baz")}).getId();
            barbaz = tx.createNode(new Label[]{Label.label((String)"Bar"), Label.label((String)"Baz")}).getId();
            deleted = tx.createNode();
            gone = deleted.getId();
            bare = tx.createNode().getId();
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            tx.getNodeById(deleted.getId()).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            NODE_IDS = new ArrayList<Long>();
            for (Node node : tx.getAllNodes()) {
                NODE_IDS.add(node.getId());
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldScanNodes() {
        ArrayList<Long> ids = new ArrayList<Long>();
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL);){
            this.read.allNodesScan(nodes);
            while (nodes.next()) {
                ids.add(nodes.nodeReference());
            }
        }
        Assertions.assertEquals(NODE_IDS, ids);
    }

    @Test
    void shouldAccessNodesByReference() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL);){
            for (long id : NODE_IDS) {
                this.read.singleNode(id, nodes);
                Assertions.assertTrue((boolean)nodes.next(), (String)"should access defined node");
                Assertions.assertEquals((long)id, (long)nodes.nodeReference(), (String)"should access the correct node");
                Assertions.assertFalse((boolean)nodes.next(), (String)"should only access a single node");
            }
        }
    }

    @Test
    void shouldNotAccessNegativeReferences() {
        try (NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL);){
            this.read.singleNode(-2L, node);
            Assertions.assertFalse((boolean)node.next(), (String)"should not access negative reference node");
        }
    }

    @Test
    void shouldNotFindDeletedNode() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL);){
            this.read.singleNode(gone, nodes);
            Assertions.assertFalse((boolean)nodes.next(), (String)"should not access deleted node");
        }
    }

    @Test
    void shouldReadLabels() {
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL);){
            this.read.singleNode(foo, nodes);
            Assertions.assertTrue((boolean)nodes.next(), (String)"should access defined node");
            TokenSet labels = nodes.labels();
            Assertions.assertEquals((int)1, (int)labels.numberOfTokens(), (String)"number of labels");
            int fooLabel = labels.token(0);
            Assertions.assertTrue((boolean)nodes.hasLabel(fooLabel));
            Assertions.assertFalse((boolean)nodes.next(), (String)"should only access a single node");
            this.read.singleNode(bar, nodes);
            Assertions.assertTrue((boolean)nodes.next(), (String)"should access defined node");
            labels = nodes.labels();
            Assertions.assertEquals((int)1, (int)labels.numberOfTokens(), (String)"number of labels");
            int barLabel = labels.token(0);
            Assertions.assertFalse((boolean)nodes.hasLabel(fooLabel));
            Assertions.assertTrue((boolean)nodes.hasLabel(barLabel));
            Assertions.assertFalse((boolean)nodes.next(), (String)"should only access a single node");
            this.read.singleNode(baz, nodes);
            Assertions.assertTrue((boolean)nodes.next(), (String)"should access defined node");
            labels = nodes.labels();
            Assertions.assertEquals((int)1, (int)labels.numberOfTokens(), (String)"number of labels");
            int bazLabel = labels.token(0);
            Assertions.assertFalse((boolean)nodes.hasLabel(fooLabel));
            Assertions.assertFalse((boolean)nodes.hasLabel(barLabel));
            Assertions.assertTrue((boolean)nodes.hasLabel(bazLabel));
            Assertions.assertFalse((boolean)nodes.next(), (String)"should only access a single node");
            Assertions.assertNotEquals((int)fooLabel, (int)barLabel, (String)"distinct labels");
            Assertions.assertNotEquals((int)fooLabel, (int)bazLabel, (String)"distinct labels");
            Assertions.assertNotEquals((int)barLabel, (int)bazLabel, (String)"distinct labels");
            this.read.singleNode(barbaz, nodes);
            Assertions.assertTrue((boolean)nodes.next(), (String)"should access defined node");
            labels = nodes.labels();
            Assertions.assertEquals((int)2, (int)labels.numberOfTokens(), (String)"number of labels");
            if (labels.token(0) == barLabel) {
                Assertions.assertEquals((int)bazLabel, (int)labels.token(1));
            } else {
                Assertions.assertEquals((int)bazLabel, (int)labels.token(0));
                Assertions.assertEquals((int)barLabel, (int)labels.token(1));
            }
            Assertions.assertFalse((boolean)nodes.hasLabel(fooLabel));
            Assertions.assertTrue((boolean)nodes.hasLabel(barLabel));
            Assertions.assertTrue((boolean)nodes.hasLabel(bazLabel));
            Assertions.assertFalse((boolean)nodes.next(), (String)"should only access a single node");
            this.read.singleNode(bare, nodes);
            Assertions.assertTrue((boolean)nodes.next(), (String)"should access defined node");
            labels = nodes.labels();
            Assertions.assertEquals((int)0, (int)labels.numberOfTokens(), (String)"number of labels");
            Assertions.assertFalse((boolean)nodes.hasLabel(fooLabel));
            Assertions.assertFalse((boolean)nodes.hasLabel(barLabel));
            Assertions.assertFalse((boolean)nodes.hasLabel(bazLabel));
            Assertions.assertFalse((boolean)nodes.next(), (String)"should only access a single node");
        }
    }

    @Test
    void notFindNoIdNode() throws InvalidTransactionTypeKernelException {
        long nodeId = this.tx.dataWrite().nodeCreate();
        try (NodeCursor nodes = this.cursors.allocateNodeCursor(CursorContext.NULL);){
            this.read.singleNode(-1L, nodes);
            Assertions.assertFalse((boolean)nodes.next(), (String)"should not access any node");
        }
        this.tx.dataWrite().nodeDelete(nodeId);
    }
}

