/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.kernel.impl.newapi.TestUtils;
import org.neo4j.util.concurrent.Futures;

public abstract class ParallelRelationshipCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static LongList RELATIONSHIPS;
    private static final int NUMBER_OF_RELATIONSHIPS = 128;
    private static final ToLongFunction<RelationshipScanCursor> REL_GET;

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            LongArrayList list = new LongArrayList(128);
            for (int i = 0; i < 128; ++i) {
                list.add(tx.createNode().createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"R")).getId());
            }
            RELATIONSHIPS = list;
            tx.commit();
        }
    }

    @Test
    void shouldScanASubsetOfRelationships() {
        CursorContext cursorContext = this.tx.cursorContext();
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(cursorContext);){
            Scan scan = this.read.allRelationshipsScan();
            Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)relationships, 3, cursorContext, this.tx.securityContext().mode()));
            Assertions.assertTrue((boolean)relationships.next());
            Assertions.assertEquals((long)RELATIONSHIPS.get(0), (long)relationships.relationshipReference());
            Assertions.assertTrue((boolean)relationships.next());
            Assertions.assertEquals((long)RELATIONSHIPS.get(1), (long)relationships.relationshipReference());
            Assertions.assertTrue((boolean)relationships.next());
            Assertions.assertEquals((long)RELATIONSHIPS.get(2), (long)relationships.relationshipReference());
            Assertions.assertFalse((boolean)relationships.next());
        }
    }

    @Test
    void shouldHandleSizeHintOverflow() {
        CursorContext cursorContext = this.tx.cursorContext();
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(cursorContext);){
            Scan scan = this.read.allRelationshipsScan();
            Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)relationships, 256, cursorContext, this.tx.securityContext().mode()));
            LongArrayList ids = new LongArrayList();
            while (relationships.next()) {
                ids.add(relationships.relationshipReference());
            }
            Assertions.assertEquals((Object)RELATIONSHIPS, (Object)ids);
        }
    }

    @Test
    void shouldFailForSizeHintZero() {
        CursorContext cursorContext = this.tx.cursorContext();
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(cursorContext);){
            Scan scan = this.read.allRelationshipsScan();
            Assertions.assertThrows(IllegalArgumentException.class, () -> scan.reserveBatch((Cursor)relationships, 0, cursorContext, this.tx.securityContext().mode()));
        }
    }

    @Test
    void shouldScanAllRelationshipsInBatches() {
        LongArrayList ids = new LongArrayList();
        CursorContext cursorContext = this.tx.cursorContext();
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor(cursorContext);){
            Scan scan = this.read.allRelationshipsScan();
            while (scan.reserveBatch((Cursor)relationships, 3, cursorContext, this.tx.securityContext().mode())) {
                while (relationships.next()) {
                    ids.add(relationships.relationshipReference());
                }
            }
        }
        Assertions.assertEquals((Object)RELATIONSHIPS, (Object)ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipsFromMultipleThreads() throws InterruptedException, ExecutionException {
        int numberOfWorkers = 4;
        ExecutorService service = Executors.newFixedThreadPool(numberOfWorkers);
        Scan scan = this.read.allRelationshipsScan();
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        try {
            List workerContexts = TestUtils.createContexts(this.tx, arg_0 -> ((CursorFactory)cursors).allocateRelationshipScanCursor(arg_0), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(32, scan, numberOfWorkers, workerContexts, REL_GET));
            List lists = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(lists);
            MutableLongList concat = TestUtils.concat(lists).toSortedList();
            Assertions.assertEquals((Object)RELATIONSHIPS, (Object)concat);
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipsFromMultipleThreadWithBigSizeHints() throws InterruptedException, ExecutionException {
        int numberOfWorkers = 4;
        ExecutorService service = Executors.newFixedThreadPool(numberOfWorkers);
        Scan scan = this.read.allRelationshipsScan();
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        try {
            List workerContexts = TestUtils.createContexts(this.tx, arg_0 -> ((CursorFactory)cursors).allocateRelationshipScanCursor(arg_0), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(100, scan, numberOfWorkers, workerContexts, REL_GET));
            List lists = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(lists);
            MutableLongList concat = TestUtils.concat(lists).toSortedList();
            Assertions.assertEquals((Object)RELATIONSHIPS, (Object)concat);
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipsFromRandomlySizedWorkers() throws InterruptedException, ExecutionException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        Scan scan = this.read.allRelationshipsScan();
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        try {
            int numberOfWorkers = 11;
            List workerContexts = TestUtils.createContexts(this.tx, arg_0 -> ((CursorFactory)cursors).allocateRelationshipScanCursor(arg_0), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createRandomWorkers(scan, numberOfWorkers, workerContexts, REL_GET));
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
            List lists = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(lists);
            MutableLongList concat = TestUtils.concat(lists).toSortedList();
            Assertions.assertEquals((Object)RELATIONSHIPS, (Object)concat);
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    static {
        REL_GET = RelationshipDataAccessor::relationshipReference;
    }
}

