/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class DataAndSchemaTransactionSeparationIT {
    @Inject
    private GraphDatabaseAPI db;

    DataAndSchemaTransactionSeparationIT() {
    }

    private static Function<Transaction, Void> expectFailureAfterSchemaOperation(Function<Transaction, ?> function) {
        return transaction -> {
            transaction.schema().indexFor(Label.label((String)"Label1")).on("key1").create();
            Exception exception = (Exception)Assertions.assertThrows(Exception.class, () -> function.apply((Transaction)transaction));
            Assertions.assertEquals((Object)"Cannot perform data updates in a transaction that has performed schema updates.", (Object)exception.getMessage());
            return null;
        };
    }

    private static Function<Transaction, Void> succeedAfterSchemaOperation(Function<Transaction, ?> function) {
        return transaction -> {
            transaction.schema().indexFor(Label.label((String)"Label1")).on("key1").create();
            function.apply((Transaction)transaction);
            return null;
        };
    }

    @Test
    void shouldNotAllowNodeCreationInSchemaTransaction() {
        try (Transaction transaction = this.db.beginTx();){
            DataAndSchemaTransactionSeparationIT.expectFailureAfterSchemaOperation(DataAndSchemaTransactionSeparationIT.createNode()).apply(transaction);
            transaction.commit();
        }
    }

    @Test
    void shouldNotAllowRelationshipCreationInSchemaTransaction() {
        Pair<Node, Node> nodes;
        try (Transaction transaction = this.db.beginTx();){
            nodes = DataAndSchemaTransactionSeparationIT.aPairOfNodes().apply(transaction);
            transaction.commit();
        }
        transaction = this.db.beginTx();
        try {
            DataAndSchemaTransactionSeparationIT.expectFailureAfterSchemaOperation(DataAndSchemaTransactionSeparationIT.relate(nodes)).apply(transaction);
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void shouldNotAllowPropertyWritesInSchemaTransaction() {
        Relationship relationship;
        Pair<Node, Node> nodes;
        try (Transaction transaction = this.db.beginTx();){
            nodes = DataAndSchemaTransactionSeparationIT.aPairOfNodes().apply(transaction);
            transaction.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            relationship = DataAndSchemaTransactionSeparationIT.relate(nodes).apply(tx);
            tx.commit();
        }
        for (Function operation : new Function[]{DataAndSchemaTransactionSeparationIT.propertyWrite(Node.class, (Node)nodes.first(), "key1", "value1"), DataAndSchemaTransactionSeparationIT.propertyWrite(Relationship.class, relationship, "key1", "value1")}) {
            try (Transaction transaction = this.db.beginTx();){
                DataAndSchemaTransactionSeparationIT.expectFailureAfterSchemaOperation(operation).apply(transaction);
            }
        }
    }

    @Test
    void shouldAllowPropertyReadsInSchemaTransaction() {
        Relationship relationship;
        Pair<Node, Node> nodes;
        try (Transaction transaction = this.db.beginTx();){
            nodes = DataAndSchemaTransactionSeparationIT.aPairOfNodes().apply(transaction);
            transaction.commit();
        }
        try (Transaction tx = this.db.beginTx();){
            relationship = DataAndSchemaTransactionSeparationIT.relate(nodes).apply(tx);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Node node = tx.getNodeById(((Node)nodes.first()).getId());
            DataAndSchemaTransactionSeparationIT.propertyWrite(Node.class, node, "key1", "value1").apply(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            DataAndSchemaTransactionSeparationIT.propertyWrite(Relationship.class, tx.getRelationshipById(relationship.getId()), "key1", "value1").apply(tx);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        for (Function operation : new Function[]{DataAndSchemaTransactionSeparationIT.propertyRead(Node.class, (Node)nodes.first(), "key1"), DataAndSchemaTransactionSeparationIT.propertyRead(Relationship.class, relationship, "key1")}) {
            try (Transaction transaction = this.db.beginTx();){
                DataAndSchemaTransactionSeparationIT.succeedAfterSchemaOperation(operation).apply(transaction);
            }
        }
    }

    private static Function<Transaction, Node> createNode() {
        return Transaction::createNode;
    }

    private static <T extends Entity> Function<Transaction, Object> propertyRead(Class<T> type, final T entity, final String key) {
        return new FailureRewrite<Object>(type.getSimpleName() + ".getProperty()"){

            @Override
            Object perform(Transaction transaction) {
                if (entity instanceof Node) {
                    return transaction.getNodeById(entity.getId()).getProperty(key);
                }
                return transaction.getRelationshipById(entity.getId()).getProperty(key);
            }
        };
    }

    private static <T extends Entity> Function<Transaction, Void> propertyWrite(Class<T> type, final T entity, final String key, final Object value) {
        return new FailureRewrite<Void>(type.getSimpleName() + ".setProperty()"){

            @Override
            Void perform(Transaction transaction) {
                if (entity instanceof Node) {
                    transaction.getNodeById(entity.getId()).setProperty(key, value);
                } else {
                    transaction.getRelationshipById(entity.getId()).setProperty(key, value);
                }
                return null;
            }
        };
    }

    private static Function<Transaction, Pair<Node, Node>> aPairOfNodes() {
        return tx -> Pair.of((Object)tx.createNode(), (Object)tx.createNode());
    }

    private static Function<Transaction, Relationship> relate(Pair<Node, Node> nodes) {
        return tx -> tx.getNodeById(((Node)nodes.first()).getId()).createRelationshipTo((Node)nodes.other(), RelationshipType.withName((String)"RELATED"));
    }

    private static abstract class FailureRewrite<T>
    implements Function<Transaction, T> {
        private final String message;

        FailureRewrite(String message) {
            this.message = message;
        }

        @Override
        public T apply(Transaction transaction) {
            try {
                return this.perform(transaction);
            }
            catch (AssertionError e) {
                throw new AssertionError(this.message + ": " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
            }
        }

        abstract T perform(Transaction var1);
    }
}

