/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class IndexDefinitionToStringTest {
    @Inject
    private GraphDatabaseService db;

    IndexDefinitionToStringTest() {
    }

    @BeforeEach
    void setup() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().getIndexes().forEach(IndexDefinition::drop);
            tx.commit();
        }
    }

    @Test
    void testToString() {
        try (Transaction tx = this.db.beginTx();){
            IndexDefinition labelTokenIndex = tx.schema().indexFor(AnyTokens.ANY_LABELS).withName("labelTokenIndex").create();
            IndexDefinition labelProperty = tx.schema().indexFor(Label.label((String)"someLabel")).on("someProperty").withName("labelIndexName").create();
            IndexDefinition labelProperties = tx.schema().indexFor(Label.label((String)"someLabel")).on("someProperty").on("someOtherProperty").withName("labelIndexNames").create();
            IndexDefinition rangeLabelProperties = tx.schema().indexFor(Label.label((String)"someLabel")).on("someProperty").on("someOtherProperty").withIndexType(IndexType.RANGE).withName("rangeLabelIndexNames").create();
            IndexDefinition fulltextLabelProperty = tx.schema().indexFor(Label.label((String)"Label")).on("prop").withIndexType(IndexType.FULLTEXT).withName("fulltextLabelPropertyIndex").create();
            IndexDefinition fulltextLabelsProperties = tx.schema().indexFor(new Label[]{Label.label((String)"Label"), Label.label((String)"otherLabel")}).on("prop").on("otherProp").withIndexType(IndexType.FULLTEXT).withName("fulltextLabelPropertiesIndex").create();
            IndexDefinition textLabelProperty = tx.schema().indexFor(Label.label((String)"Label")).on("prop").withIndexType(IndexType.TEXT).withName("textLabelPropertyIndex").create();
            IndexDefinition pointLabelProperty = tx.schema().indexFor(Label.label((String)"Label")).on("prop").withIndexType(IndexType.POINT).withName("pointLabelPropertyIndex").create();
            IndexDefinition relTypeTokenIndex = tx.schema().indexFor(AnyTokens.ANY_RELATIONSHIP_TYPES).withName("relTypeTokenIndex").create();
            IndexDefinition relTypeProperty = tx.schema().indexFor(RelationshipType.withName((String)"someRelationship")).on("someProperty").withName("relTypeIndexName").create();
            IndexDefinition relTypeProperties = tx.schema().indexFor(RelationshipType.withName((String)"someRelationship")).on("someProperty").on("someOtherProperty").withName("relTypeIndexNames").create();
            IndexDefinition rangeRelTypeProperties = tx.schema().indexFor(RelationshipType.withName((String)"someRelationship")).on("someProperty").on("someOtherProperty").withIndexType(IndexType.RANGE).withName("rangeRelTypeIndexNames").create();
            IndexDefinition fulltextRelTypeProperty = tx.schema().indexFor(RelationshipType.withName((String)"TYPE")).on("prop").withIndexType(IndexType.FULLTEXT).withName("fulltextRelTypePropertyIndex").create();
            IndexDefinition fulltextRelTypesProperties = tx.schema().indexFor(new RelationshipType[]{RelationshipType.withName((String)"TYPE"), RelationshipType.withName((String)"OTHER_TYPE")}).on("prop").on("otherProp").withIndexType(IndexType.FULLTEXT).withName("fulltextRelTypesPropertiesIndex").create();
            IndexDefinition textRelTypeProperty = tx.schema().indexFor(RelationshipType.withName((String)"TYPE")).on("prop").withIndexType(IndexType.TEXT).withName("textRelTypePropertyIndex").create();
            IndexDefinition pointRelTypeProperty = tx.schema().indexFor(RelationshipType.withName((String)"TYPE")).on("prop").withIndexType(IndexType.POINT).withName("pointRelTypePropertyIndex").create();
            IndexDefinitionToStringTest.assertIndexString(labelTokenIndex, "IndexDefinition[label:<any-labels>] (Index( id=%d, name='labelTokenIndex', type='TOKEN LOOKUP', schema=(:<any-labels>), indexProvider='token-lookup-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(labelProperty, "IndexDefinition[label:someLabel on:someProperty] (Index( id=%d, name='labelIndexName', type='GENERAL BTREE', schema=(:someLabel {someProperty}), indexProvider='native-btree-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(labelProperties, "IndexDefinition[label:someLabel on:someProperty,someOtherProperty] (Index( id=%d, name='labelIndexNames', type='GENERAL BTREE', schema=(:someLabel {someProperty, someOtherProperty}), indexProvider='native-btree-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(rangeLabelProperties, "IndexDefinition[label:someLabel on:someProperty,someOtherProperty] (Index( id=%d, name='rangeLabelIndexNames', type='GENERAL RANGE', schema=(:someLabel {someProperty, someOtherProperty}), indexProvider='range-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(fulltextLabelProperty, "IndexDefinition[label:Label on:prop] (Index( id=%d, name='fulltextLabelPropertyIndex', type='GENERAL FULLTEXT', schema=(:Label {prop}), indexProvider='fulltext-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(fulltextLabelsProperties, "IndexDefinition[labels:Label,otherLabel on:prop,otherProp] (Index( id=%d, name='fulltextLabelPropertiesIndex', type='GENERAL FULLTEXT', schema=(:Label:otherLabel {prop, otherProp}), indexProvider='fulltext-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(textLabelProperty, "IndexDefinition[label:Label on:prop] (Index( id=%d, name='textLabelPropertyIndex', type='GENERAL TEXT', schema=(:Label {prop}), indexProvider='text-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(pointLabelProperty, "IndexDefinition[label:Label on:prop] (Index( id=%d, name='pointLabelPropertyIndex', type='GENERAL POINT', schema=(:Label {prop}), indexProvider='point-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(relTypeTokenIndex, "IndexDefinition[relationship type:<any-types>] (Index( id=%d, name='relTypeTokenIndex', type='TOKEN LOOKUP', schema=-[:<any-types>]-, indexProvider='token-lookup-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(relTypeProperty, "IndexDefinition[relationship type:someRelationship on:someProperty] (Index( id=%d, name='relTypeIndexName', type='GENERAL BTREE', schema=-[:someRelationship {someProperty}]-, indexProvider='native-btree-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(relTypeProperties, "IndexDefinition[relationship type:someRelationship on:someProperty,someOtherProperty] (Index( id=%d, name='relTypeIndexNames', type='GENERAL BTREE', schema=-[:someRelationship {someProperty, someOtherProperty}]-, indexProvider='native-btree-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(rangeRelTypeProperties, "IndexDefinition[relationship type:someRelationship on:someProperty,someOtherProperty] (Index( id=%d, name='rangeRelTypeIndexNames', type='GENERAL RANGE', schema=-[:someRelationship {someProperty, someOtherProperty}]-, indexProvider='range-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(fulltextRelTypeProperty, "IndexDefinition[relationship type:TYPE on:prop] (Index( id=%d, name='fulltextRelTypePropertyIndex', type='GENERAL FULLTEXT', schema=-[:TYPE {prop}]-, indexProvider='fulltext-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(fulltextRelTypesProperties, "IndexDefinition[relationship types:TYPE,OTHER_TYPE on:prop,otherProp] (Index( id=%d, name='fulltextRelTypesPropertiesIndex', type='GENERAL FULLTEXT', schema=-[:TYPE:OTHER_TYPE {prop, otherProp}]-, indexProvider='fulltext-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(textRelTypeProperty, "IndexDefinition[relationship type:TYPE on:prop] (Index( id=%d, name='textRelTypePropertyIndex', type='GENERAL TEXT', schema=-[:TYPE {prop}]-, indexProvider='text-1.0' ))");
            IndexDefinitionToStringTest.assertIndexString(pointRelTypeProperty, "IndexDefinition[relationship type:TYPE on:prop] (Index( id=%d, name='pointRelTypePropertyIndex', type='GENERAL POINT', schema=-[:TYPE {prop}]-, indexProvider='point-1.0' ))");
        }
    }

    private static void assertIndexString(IndexDefinition index, String expectedStringFormat) {
        Assertions.assertThat((String)index.toString()).isEqualTo(expectedStringFormat, new Object[]{((IndexDefinitionImpl)index).getIndexReference().getId()});
    }
}

