/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.PartitionedScanFactories;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;
import org.neo4j.kernel.impl.newapi.TokenIndexScanPartitionedScanTestSuite;

class NodeLabelIndexScanPartitionedScanTestSuite
extends TokenIndexScanPartitionedScanTestSuite<NodeLabelIndexCursor> {
    NodeLabelIndexScanPartitionedScanTestSuite() {
    }

    public final PartitionedScanFactories.NodeLabelIndexScan getFactory() {
        return PartitionedScanFactories.NodeLabelIndexScan.FACTORY;
    }

    @Nested
    class WithData
    extends TokenIndexScanPartitionedScanTestSuite.WithData<NodeLabelIndexCursor> {
        WithData() {
            super(NodeLabelIndexScanPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> setupDatabase() {
            int numberOfLabels = 3;
            int numberOfNodes = 100000;
            List<Integer> labelIds = this.createTags(3, PartitionedScanFactories.Label.FACTORY);
            return this.createData(100000, labelIds);
        }

        @Override
        PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> createData(int numberOfNodes, List<Integer> labelIds) {
            PartitionedScanTestSuite.EntityIdsMatchingQuery<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> nodesWithLabelId = new PartitionedScanTestSuite.EntityIdsMatchingQuery<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery>();
            String indexName = this.getTokenIndexName(EntityType.NODE);
            try (KernelTransaction tx = this.beginTx();){
                Write write = tx.dataWrite();
                for (int i = 0; i < numberOfNodes; ++i) {
                    Integer labelId;
                    long nodeId = write.nodeCreate();
                    if (!write.nodeAddLabel(nodeId, (labelId = (Integer)this.random.among(labelIds)).intValue())) continue;
                    nodesWithLabelId.getOrCreate(new TokenIndexScanPartitionedScanTestSuite.TokenScanQuery(indexName, new TokenPredicate(labelId.intValue()))).add(nodeId);
                }
                tx.commit();
            }
            catch (Exception e) {
                throw new AssertionError("failed to create database", e);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)nodesWithLabelId.queries().size()).as("valid queries should exist", new Object[0])).isGreaterThan(0);
            int numberOfCreatedNodes = 0;
            for (Map.Entry entry : nodesWithLabelId) {
                numberOfCreatedNodes += entry.getValue().size();
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)numberOfCreatedNodes).as("nodes created", new Object[0])).isEqualTo(numberOfNodes);
            return new PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery>(nodesWithLabelId);
        }
    }

    @Nested
    class WithoutData
    extends TokenIndexScanPartitionedScanTestSuite.WithoutData<NodeLabelIndexCursor> {
        WithoutData() {
            super(NodeLabelIndexScanPartitionedScanTestSuite.this);
        }

        @Override
        PartitionedScanTestSuite.Queries<TokenIndexScanPartitionedScanTestSuite.TokenScanQuery> setupDatabase() {
            int numberOfLabels = 3;
            List<Integer> labelIds = this.createTags(3, PartitionedScanFactories.Label.FACTORY);
            return this.emptyQueries(EntityType.NODE, labelIds);
        }
    }
}

