/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.configuration.Config;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyIndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.api.index.TestNodePropertyAccessor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

abstract class SimpleIndexPopulatorCompatibility
extends PropertyIndexProviderCompatibilityTestSuite.Compatibility {
    final IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());

    SimpleIndexPopulatorCompatibility(PropertyIndexProviderCompatibilityTestSuite testSuite, IndexPrototype prototype) {
        super(testSuite, prototype);
    }

    @Test
    void shouldStorePopulationFailedForRetrievalFromProviderLater() throws Exception {
        String failure = "The contrived failure";
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(this.config);
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.markAsFailed(failure)), false);
        Assertions.assertThat((String)this.indexProvider.getPopulationFailure(this.descriptor, CursorContext.NULL)).contains(new CharSequence[]{failure});
    }

    @Test
    void shouldReportInitialStateAsFailedIfPopulationFailed() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(this.config);
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            String failure = "The contrived failure";
            p.markAsFailed(failure);
            p.close(false, CursorContext.NULL);
            org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.FAILED, (Object)this.indexProvider.getInitialState(this.descriptor, CursorContext.NULL));
        }), false);
    }

    @Test
    void shouldBeAbleToDropAClosedIndexPopulator() {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(this.config);
        IndexPopulator p = this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup);
        p.close(false, CursorContext.NULL);
        p.drop();
    }

    @Test
    void shouldApplyUpdatesIdempotently() throws Exception {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(this.config);
        Value propertyValue = Values.of((Object)"value1");
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            long nodeId = 1L;
            ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{propertyValue});
            p.add(Collections.singletonList(update), CursorContext.NULL);
            try (IndexUpdater updater = p.newPopulatingUpdater((node, propertyId, cursorContext) -> propertyValue, CursorContext.NULL);){
                updater.process((IndexEntryUpdate)update);
            }
        }));
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, indexSamplingConfig, this.tokenNameLookup);
             ValueIndexReader reader = accessor.newValueReader();
             NodeValueIterator nodes = new NodeValueIterator();){
            int propertyKeyId = this.descriptor.schema().getPropertyId();
            reader.query((IndexProgressor.EntityValueClient)nodes, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)propertyKeyId, (Object)propertyValue)});
            org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L}), (Object)PrimitiveLongCollections.toSet((LongIterator)nodes));
        }
    }

    @Test
    void shouldPopulateWithAllValues() throws Exception {
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.add(this.updates(this.valueSet1), CursorContext.NULL)));
        this.assertHasAllValues(this.valueSet1);
    }

    @Test
    void shouldUpdateWithAllValuesDuringPopulation() throws Exception {
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            try (IndexUpdater updater = p.newPopulatingUpdater(this::valueSet1Lookup, CursorContext.NULL);){
                for (PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : this.valueSet1) {
                    updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)entry.nodeId, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{entry.value}));
                }
            }
        }));
        this.assertHasAllValues(this.valueSet1);
    }

    @Test
    void shouldPopulateAndUpdate() throws Exception {
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> p.add(this.updates(this.valueSet1), CursorContext.NULL)));
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.indexSamplingConfig, this.tokenNameLookup);){
            try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
                List<ValueIndexEntryUpdate<?>> updates = this.updates(this.valueSet2);
                for (ValueIndexEntryUpdate<?> update : updates) {
                    updater.process(update);
                }
            }
            try (ValueIndexReader reader = accessor.newValueReader();){
                int propertyKeyId = this.descriptor.schema().getPropertyId();
                for (PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : Iterables.concat((Iterable[])new Iterable[]{this.valueSet1, this.valueSet2})) {
                    try (NodeValueIterator nodes = new NodeValueIterator();){
                        reader.query((IndexProgressor.EntityValueClient)nodes, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)propertyKeyId, (Object)entry.value)});
                        org.junit.jupiter.api.Assertions.assertEquals((long)entry.nodeId, (long)nodes.next());
                        org.junit.jupiter.api.Assertions.assertFalse((boolean)nodes.hasNext());
                    }
                }
            }
        }
    }

    @Test
    void shouldPopulateAndRemoveEntriesWithSimilarMinimalSplitter() throws Exception {
        String prefix = "Work out your own salvation. Do not depend on others. ";
        int nbrOfNodes = 200;
        long nodeId = 0L;
        ArrayList<PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue> secondBatch = new ArrayList<PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue>();
        for (int i = 0; i < nbrOfNodes; ++i) {
            secondBatch.add(new PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue(nodeId++, (Value)Values.stringValue((String)(prefix + i))));
        }
        ArrayList<PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue> firstBatch = new ArrayList<PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue>();
        for (int i = 0; i < nbrOfNodes; ++i) {
            firstBatch.add(new PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue(nodeId++, (Value)Values.stringValue((String)(prefix + i + " " + i))));
        }
        this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
            p.add(this.updates(firstBatch), CursorContext.NULL);
            p.add(this.updates(secondBatch), CursorContext.NULL);
        }));
        ArrayList<PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue> toRemove = new ArrayList<PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue>();
        toRemove.addAll(firstBatch);
        toRemove.addAll(secondBatch);
        Collections.shuffle(toRemove);
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.indexSamplingConfig, this.tokenNameLookup);){
            try (IndexUpdater updater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
                for (PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue nodeAndValue : toRemove) {
                    updater.process((IndexEntryUpdate)IndexEntryUpdate.remove((long)nodeAndValue.nodeId, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{nodeAndValue.value}));
                }
            }
            try (ValueIndexReader reader = accessor.newValueReader();){
                int propertyKeyId = this.descriptor.schema().getPropertyId();
                for (PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue nodeAndValue : toRemove) {
                    NodeValueIterator nodes = new NodeValueIterator();
                    reader.query((IndexProgressor.EntityValueClient)nodes, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)propertyKeyId, (Object)nodeAndValue.value)});
                    boolean anyHits = false;
                    StringJoiner nodesStillLeft = new StringJoiner(", ", "[", "]");
                    while (nodes.hasNext()) {
                        anyHits = true;
                        nodesStillLeft.add(Long.toString(nodes.next()));
                    }
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)anyHits, (String)("Expected this query to have zero hits but found " + nodesStillLeft));
                }
            }
        }
    }

    private Value valueSet1Lookup(long nodeId, int propertyId, CursorContext cursorContext) {
        for (PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue x : this.valueSet1) {
            if (x.nodeId != nodeId) continue;
            return x.value;
        }
        return Values.NO_VALUE;
    }

    private void assertHasAllValues(List<PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue> values) throws IOException, IndexNotApplicableKernelException {
        try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.indexSamplingConfig, this.tokenNameLookup);
             ValueIndexReader reader = accessor.newValueReader();){
            int propertyKeyId = this.descriptor.schema().getPropertyId();
            for (PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : values) {
                try (NodeValueIterator nodes = new NodeValueIterator();){
                    reader.query((IndexProgressor.EntityValueClient)nodes, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)propertyKeyId, (Object)entry.value)});
                    org.junit.jupiter.api.Assertions.assertEquals((long)entry.nodeId, (long)nodes.next());
                    org.junit.jupiter.api.Assertions.assertFalse((boolean)nodes.hasNext());
                }
            }
        }
    }

    static abstract class Unique
    extends SimpleIndexPopulatorCompatibility {
        Unique(PropertyIndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, testSuite.uniqueIndexPrototype());
        }

        @Test
        void shouldProvidePopulatorThatEnforcesUniqueConstraints() throws Exception {
            Value value = Values.of((Object)"value1");
            int nodeId1 = 1;
            int nodeId2 = 2;
            this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                try {
                    p.add(Arrays.asList(IndexEntryUpdate.add((long)nodeId1, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{value}), IndexEntryUpdate.add((long)nodeId2, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{value})), CursorContext.NULL);
                    TestNodePropertyAccessor propertyAccessor = new TestNodePropertyAccessor((long)nodeId1, this.descriptor.schema(), new Value[]{value});
                    propertyAccessor.addNode((long)nodeId2, this.descriptor.schema(), new Value[]{value});
                    p.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
                    p.verifyDeferredConstraints((NodePropertyAccessor)propertyAccessor);
                    org.junit.jupiter.api.Assertions.fail((String)"expected exception");
                }
                catch (Exception e) {
                    Throwable root = ExceptionUtils.getRootCause((Throwable)e);
                    if (root instanceof IndexEntryConflictException) {
                        IndexEntryConflictException conflict = (IndexEntryConflictException)root;
                        org.junit.jupiter.api.Assertions.assertEquals((long)nodeId1, (long)conflict.getExistingNodeId());
                        org.junit.jupiter.api.Assertions.assertEquals((Object)ValueTuple.of((Value[])new Value[]{value}), (Object)conflict.getPropertyValues());
                        org.junit.jupiter.api.Assertions.assertEquals((long)nodeId2, (long)conflict.getAddedNodeId());
                    }
                    throw e;
                }
            }), false);
        }
    }

    static abstract class General
    extends SimpleIndexPopulatorCompatibility {
        General(PropertyIndexProviderCompatibilityTestSuite testSuite) {
            super(testSuite, testSuite.indexPrototype());
        }

        @Test
        void shouldProvidePopulatorThatAcceptsDuplicateEntries() throws Exception {
            long offset = this.valueSet1.size();
            this.withPopulator(this.indexProvider.getPopulator(this.descriptor, this.indexSamplingConfig, ByteBufferFactory.heapBufferFactory((int)1024), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.tokenNameLookup), (ThrowingConsumer<IndexPopulator, Exception>)((ThrowingConsumer)p -> {
                p.add(this.updates(this.valueSet1, 0L), CursorContext.NULL);
                p.add(this.updates(this.valueSet1, offset), CursorContext.NULL);
            }));
            try (IndexAccessor accessor = this.indexProvider.getOnlineAccessor(this.descriptor, this.indexSamplingConfig, this.tokenNameLookup);
                 ValueIndexReader reader = accessor.newValueReader();){
                int propertyKeyId = this.descriptor.schema().getPropertyId();
                for (PropertyIndexProviderCompatibilityTestSuite.Compatibility.NodeAndValue entry : this.valueSet1) {
                    try (NodeValueIterator nodes = new NodeValueIterator();){
                        reader.query((IndexProgressor.EntityValueClient)nodes, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)propertyKeyId, (Object)entry.value)});
                        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{entry.nodeId, entry.nodeId + offset}), (Object)PrimitiveLongCollections.toSet((LongIterator)nodes), (String)entry.value.toString());
                    }
                }
            }
        }
    }
}

