/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.database.Database;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class StoreVersionCheckIT {
    @Inject
    Database db;
    @Inject
    PageCache pc;
    @Inject
    FileSystemAbstraction fs;

    StoreVersionCheckIT() {
    }

    @Test
    void shouldBeAbleToFetchStorageVersionForOnlineDatabase() {
        StoreVersion storeVersion = this.db.getStorageEngineFactory().versionInformation(this.db.getStoreId());
        Assertions.assertThat((Object)storeVersion).isNotNull();
    }

    @Test
    void shouldBeAbleToFetchStorageVersionForOfflineDatabase() throws Exception {
        DatabaseLayout databaseLayout = this.db.getDatabaseLayout();
        Config config = this.db.getConfig();
        this.db.shutdown();
        StorageEngineFactory sef = (StorageEngineFactory)StorageEngineFactory.selectStorageEngine((FileSystemAbstraction)this.fs, (DatabaseLayout)databaseLayout, (PageCache)this.pc).get();
        StoreVersionCheck storeVersionCheck = sef.versionCheck(this.fs, databaseLayout, config, this.pc, (LogService)NullLogService.getInstance(), PageCacheTracer.NULL);
        String storeVersionStr = (String)storeVersionCheck.storeVersion(CursorContext.NULL).get();
        StoreVersion storeVersion = sef.versionInformation(storeVersionStr);
        Assertions.assertThat((Object)storeVersion).isNotNull();
    }
}

