/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.RepeatedTest;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.Race;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
abstract class UpdateDeletedRelationshipIndexBase {
    @Inject
    protected GraphDatabaseAPI db;
    protected static final String KEY = "key";
    protected static final RelationshipType TYPE_ONE = RelationshipType.withName((String)"TypeOne");
    private static final int RELATIONSHIPS = 100;

    UpdateDeletedRelationshipIndexBase() {
    }

    @RepeatedTest(value=5)
    void shouldHandleCreateRelationshipConcurrentlyWithIndexDrop() throws Throwable {
        this.shouldHandleIndexDropConcurrentlyWithOperation((tx, id) -> tx.createNode().createRelationshipTo(tx.createNode(), TYPE_ONE).setProperty(KEY, (Object)id));
    }

    @RepeatedTest(value=5)
    void shouldHandleDeleteRelationshipConcurrentlyWithIndexDrop() throws Throwable {
        this.shouldHandleIndexDropConcurrentlyWithOperation((tx, id) -> tx.getRelationshipById(id).delete());
    }

    @RepeatedTest(value=5)
    void shouldHandleRemovePropertyConcurrentlyWithIndexDrop() throws Throwable {
        this.shouldHandleIndexDropConcurrentlyWithOperation((tx, id) -> tx.getRelationshipById(id).removeProperty(KEY));
    }

    private void shouldHandleIndexDropConcurrentlyWithOperation(RelationshipOperation operation) throws Throwable {
        long[] relationships = this.createRelationships();
        IndexDefinition indexDefinition = this.createIndex();
        Race race = new Race();
        race.addContestant(() -> {
            try (Transaction tx = this.db.beginTx();){
                tx.schema().getIndexByName(indexDefinition.getName()).drop();
                tx.commit();
            }
        }, 1);
        for (int i = 0; i < 100; ++i) {
            long id = relationships[i];
            race.addContestant(Race.throwing(() -> {
                try (Transaction tx = this.db.beginTx();){
                    operation.run(tx, id);
                    tx.commit();
                }
            }));
        }
        race.go();
    }

    private long[] createRelationships() {
        long[] result = new long[100];
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                Relationship rel = tx.createNode().createRelationshipTo(tx.createNode(), TYPE_ONE);
                rel.setProperty(KEY, (Object)i);
                result[i] = rel.getId();
            }
            tx.commit();
        }
        return result;
    }

    private IndexDefinition createIndex() {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                tx.createNode().createRelationshipTo(tx.createNode(), TYPE_ONE).setProperty(KEY, (Object)i);
            }
            tx.commit();
        }
        IndexDefinition indexDefinition = this.indexCreate();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        return indexDefinition;
    }

    protected abstract IndexDefinition indexCreate();

    private static interface RelationshipOperation {
        public void run(Transaction var1, long var2) throws Exception;
    }
}

