/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.database.readonly.ConfigBasedLookupFactory;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.PropertyIndexProviderCompatibilityTestSuite;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.index.schema.fusion.NativeLuceneFusionIndexProviderFactory30;
import org.neo4j.monitoring.Monitors;

class FusionIndexProvider30CompatibilitySuiteTest
extends PropertyIndexProviderCompatibilityTestSuite {
    FusionIndexProvider30CompatibilitySuiteTest() {
    }

    @Override
    IndexProvider createIndexProvider(PageCache pageCache, FileSystemAbstraction fs, Path graphDbDir, Config config) {
        Monitors monitors = new Monitors();
        String monitorTag = "";
        RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = RecoveryCleanupWorkCollector.immediate();
        NamedDatabaseId defaultDatabaseId = DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID());
        DatabaseIdRepository databaseIdRepository = (DatabaseIdRepository)Mockito.mock(DatabaseIdRepository.class);
        Mockito.when((Object)databaseIdRepository.getByName("neo4j")).thenReturn(Optional.of(defaultDatabaseId));
        ReadOnlyDatabases readOnlyDatabases = new ReadOnlyDatabases(new ReadOnlyDatabases.LookupFactory[]{new ConfigBasedLookupFactory(config, databaseIdRepository)});
        DatabaseReadOnlyChecker readOnlyChecker = readOnlyDatabases.forDatabase(defaultDatabaseId);
        return NativeLuceneFusionIndexProviderFactory30.create((PageCache)pageCache, (Path)graphDbDir, (FileSystemAbstraction)fs, (Monitors)monitors, (String)monitorTag, (Config)config, (DatabaseReadOnlyChecker)readOnlyChecker, (RecoveryCleanupWorkCollector)recoveryCleanupWorkCollector, (PageCacheTracer)PageCacheTracer.NULL, (String)"neo4j");
    }

    @Override
    IndexType indexType() {
        return IndexType.BTREE;
    }

    @Override
    boolean supportsSpatial() {
        return true;
    }

    @Override
    void additionalConfig(Config.Builder configBuilder) {
        configBuilder.set(GraphDatabaseSettings.default_schema_provider, (Object)GraphDatabaseSettings.SchemaIndex.NATIVE30.providerName());
    }
}

