/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
public class PointIndexCreationTest {
    @Inject
    private GraphDatabaseAPI db;
    private int labelId;
    private int relTypeId;
    private int[] compositeKey;

    @BeforeEach
    void setup() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ((InternalTransaction)tx).kernelTransaction();
            TokenWrite tokenWrite = ktx.tokenWrite();
            this.labelId = tokenWrite.labelGetOrCreateForName(Label.label((String)"PERSON").name());
            this.relTypeId = tokenWrite.relationshipTypeGetOrCreateForName(RelationshipType.withName((String)"FRIEND").name());
            this.compositeKey = new int[]{tokenWrite.propertyKeyGetOrCreateForName("address"), tokenWrite.propertyKeyGetOrCreateForName("age")};
            tx.commit();
        }
    }

    @Test
    void shouldRejectCompositeKeys() {
        this.assertUnsupported(() -> this.createPointIndex("ni", (SchemaDescriptor)SchemaDescriptors.forLabel((int)this.labelId, (int[])this.compositeKey)));
        this.assertUnsupported(() -> this.createPointIndex("ri", (SchemaDescriptor)SchemaDescriptors.forRelType((int)this.relTypeId, (int[])this.compositeKey)));
        this.assertUnsupported(this::createCompositeNodePointIndexCoreAPI);
        this.assertUnsupported(this::createCompositeRelPointIndexCoreAPI);
    }

    private void assertUnsupported(Executable executable) {
        String message = ((UnsupportedOperationException)org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, (Executable)executable)).getMessage();
        Assertions.assertThat((String)message).isEqualTo("Composite indexes are not supported for POINT index type.");
    }

    private void createPointIndex(String name, SchemaDescriptor schema) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)schema).withIndexType(IndexType.POINT).withName(name);
            KernelTransaction kernelTransaction = ((InternalTransaction)tx).kernelTransaction();
            kernelTransaction.schemaWrite().indexCreate(prototype);
            tx.commit();
        }
    }

    private void createCompositeNodePointIndexCoreAPI() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(Label.label((String)"label")).on("prop").on("prop2").withIndexType(org.neo4j.graphdb.schema.IndexType.POINT).create();
            tx.commit();
        }
    }

    private void createCompositeRelPointIndexCoreAPI() {
        try (Transaction tx = this.db.beginTx();){
            tx.schema().indexFor(RelationshipType.withName((String)"type")).on("prop").on("prop2").withIndexType(org.neo4j.graphdb.schema.IndexType.POINT).create();
            tx.commit();
        }
    }
}

