/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.DelegatingPageCache;
import org.neo4j.io.pagecache.DelegatingPagedFile;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.DatabaseLogService;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheSupportExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@DbmsExtension(configurationCallback="configure")
class DatabaseIT {
    @RegisterExtension
    static PageCacheSupportExtension pageCacheExtension = new PageCacheSupportExtension();
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private Database database;
    @Inject
    private MemoryPools memoryPools;
    @Inject
    private DatabaseManagementService dbms;
    private PageCacheWrapper pageCacheWrapper;
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    DatabaseIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        Dependencies dependencies = new Dependencies();
        this.pageCacheWrapper = new PageCacheWrapper(pageCacheExtension.getPageCache(this.fs));
        dependencies.satisfyDependency((Object)this.pageCacheWrapper);
        builder.setInternalLogProvider((LogProvider)this.logProvider).setExternalDependencies((DependencyResolver)dependencies);
    }

    @AfterEach
    void tearDown() {
        this.dbms.shutdown();
        this.pageCacheWrapper.close();
    }

    @Test
    void shutdownOfDatabaseShouldFlushWithoutAnyIOLimitations() {
        this.pageCacheWrapper.disabledIOController.set(true);
        AssertionsForInterfaceTypes.assertThat((int)this.pageCacheWrapper.ioControllerChecks.get()).isZero();
        Assertions.assertDoesNotThrow(() -> this.database.stop());
        AssertionsForInterfaceTypes.assertThat((int)this.pageCacheWrapper.ioControllerChecks.get()).isPositive();
    }

    @Test
    void databaseHealthShouldBeHealedOnStart() throws Throwable {
        this.database.stop();
        this.database.init();
        DatabaseHealth databaseHealth = this.database.getDatabaseHealth();
        databaseHealth.panic(new Throwable());
        this.database.start();
        databaseHealth.assertHealthy(Throwable.class);
    }

    @Test
    void dropDataOfNotStartedDatabase() {
        this.database.stop();
        Assertions.assertNotEquals((Object)this.databaseLayout.databaseDirectory(), (Object)this.databaseLayout.getTransactionLogsDirectory());
        Assertions.assertTrue((boolean)this.fs.fileExists(this.databaseLayout.databaseDirectory()));
        Assertions.assertTrue((boolean)this.fs.fileExists(this.databaseLayout.getTransactionLogsDirectory()));
        this.database.drop();
        Assertions.assertFalse((boolean)this.fs.fileExists(this.databaseLayout.databaseDirectory()));
        Assertions.assertFalse((boolean)this.fs.fileExists(this.databaseLayout.getTransactionLogsDirectory()));
    }

    @Test
    void noPageCacheFlushOnDatabaseDrop() {
        this.database.start();
        int flushesBefore = this.pageCacheWrapper.getFlushes();
        this.database.drop();
        Assertions.assertEquals((int)flushesBefore, (int)this.pageCacheWrapper.getFlushes());
    }

    @Test
    void removeDatabaseDataAndLogsOnDrop() {
        Assertions.assertNotEquals((Object)this.databaseLayout.databaseDirectory(), (Object)this.databaseLayout.getTransactionLogsDirectory());
        Assertions.assertTrue((boolean)this.fs.fileExists(this.databaseLayout.databaseDirectory()));
        Assertions.assertTrue((boolean)this.fs.fileExists(this.databaseLayout.getTransactionLogsDirectory()));
        this.database.drop();
        Assertions.assertFalse((boolean)this.fs.fileExists(this.databaseLayout.databaseDirectory()));
        Assertions.assertFalse((boolean)this.fs.fileExists(this.databaseLayout.getTransactionLogsDirectory()));
    }

    @Test
    void flushDatabaseDataOnStop() {
        String logPrefix = this.database.getNamedDatabaseId().logPrefix();
        int flushesBeforeClose = this.pageCacheWrapper.getFileFlushes();
        this.database.stop();
        Assertions.assertNotEquals((int)flushesBeforeClose, (int)this.pageCacheWrapper.getFileFlushes());
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(Database.class).forLevel(AssertableLogProvider.Level.INFO).containsMessages(new String[]{String.format("[%s] Waiting for closing transactions.", logPrefix), String.format("[%s] All transactions are closed.", logPrefix)});
    }

    @Test
    void flushOfThePageCacheHappensOnlyOnceDuringShutdown() throws Throwable {
        int databaseFiles = (int)this.database.getStoreFileListing().builder().build().stream().count();
        int flushesBefore = this.pageCacheWrapper.getFlushes();
        int filesFlushesBefore = this.pageCacheWrapper.getFileFlushes();
        this.database.stop();
        Assertions.assertEquals((int)flushesBefore, (int)this.pageCacheWrapper.getFlushes());
        AssertionsForInterfaceTypes.assertThat((int)this.pageCacheWrapper.getFileFlushes()).isGreaterThanOrEqualTo(filesFlushesBefore + databaseFiles);
    }

    @Test
    void flushOfThePageCacheOnShutdownDoesNotHappenIfTheDbIsUnhealthy() throws Throwable {
        DatabaseHealth databaseHealth = this.database.getDatabaseHealth();
        databaseHealth.panic(new Throwable("Critical failure"));
        int fileFlushesBefore = this.pageCacheWrapper.getFileFlushes();
        int databaseFiles = (int)this.database.getStoreFileListing().builder().excludeLogFiles().build().stream().count();
        this.database.stop();
        AssertionsForInterfaceTypes.assertThat((int)this.pageCacheWrapper.getFileFlushes()).isLessThan(fileFlushesBefore + databaseFiles);
    }

    @Test
    void logModuleSetUpError() {
        RuntimeException exception = new RuntimeException("StartupError");
        this.database.stop();
        this.database.init();
        this.database.getLife().add(LifecycleAdapter.onStart(() -> {
            throw exception;
        }));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.database.start());
        AssertionsForInterfaceTypes.assertThat((Throwable)e).hasRootCause((Throwable)exception);
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).forClass(Database.class).forLevel(AssertableLogProvider.Level.WARN).containsMessageWithException("Exception occurred while starting the database. Trying to stop already started components.", e.getCause());
    }

    @Test
    void shouldAlwaysShutdownLifeEvenWhenSomeComponentFailing() {
        RuntimeException expectedException = new RuntimeException("Failure");
        LifeSupport life = this.database.getLife();
        DatabaseAvailabilityGuard availabilityGuard = this.database.getDatabaseAvailabilityGuard();
        life.add(LifecycleAdapter.onShutdown(() -> {
            throw expectedException;
        }));
        Throwable e = Assertions.assertThrows(Throwable.class, () -> this.database.stop());
        AssertionsForInterfaceTypes.assertThat((Throwable)e).hasCause((Throwable)expectedException);
        Assertions.assertFalse((boolean)availabilityGuard.isAvailable());
    }

    @Test
    void shouldHaveDatabaseLogServiceInDependencyResolver() {
        LogService logService = (LogService)this.database.getDependencyResolver().resolveDependency(LogService.class);
        Assertions.assertEquals((Object)this.database.getLogService(), (Object)logService);
        AssertionsForInterfaceTypes.assertThat((Object)logService).isInstanceOf(DatabaseLogService.class);
    }

    @Test
    void stopShutdownMustOnlyReleaseMemoryOnce() throws Exception {
        MemoryTracker otherMemoryTracker = this.getOtherMemoryTracker();
        long beforeStop = otherMemoryTracker.usedNativeMemory();
        this.database.stop();
        long afterStop = otherMemoryTracker.usedNativeMemory();
        AssertionsForInterfaceTypes.assertThat((long)afterStop).isLessThan(beforeStop);
        this.database.shutdown();
        long afterShutdown = otherMemoryTracker.usedNativeMemory();
        Assertions.assertEquals((long)afterShutdown, (long)afterStop);
    }

    @Test
    void shutdownShutdownMustOnlyReleaseMemoryOnce() throws Exception {
        MemoryTracker otherMemoryTracker = this.getOtherMemoryTracker();
        long beforeShutdown = otherMemoryTracker.usedNativeMemory();
        this.database.shutdown();
        long afterFirstShutdown = otherMemoryTracker.usedNativeMemory();
        AssertionsForInterfaceTypes.assertThat((long)afterFirstShutdown).isLessThan(beforeShutdown);
        this.database.shutdown();
        long afterSecondShutdown = otherMemoryTracker.usedNativeMemory();
        Assertions.assertEquals((long)afterSecondShutdown, (long)afterFirstShutdown);
    }

    @Test
    void shutdownStopMustOnlyReleaseMemoryOnce() throws Exception {
        MemoryTracker otherMemoryTracker = this.getOtherMemoryTracker();
        long beforeShutdown = otherMemoryTracker.usedNativeMemory();
        this.database.shutdown();
        long afterShutdown = otherMemoryTracker.usedNativeMemory();
        AssertionsForInterfaceTypes.assertThat((long)afterShutdown).isLessThan(beforeShutdown);
        this.database.stop();
        long afterStop = otherMemoryTracker.usedNativeMemory();
        Assertions.assertEquals((long)afterStop, (long)afterShutdown);
    }

    private MemoryTracker getOtherMemoryTracker() {
        for (GlobalMemoryGroupTracker pool : this.memoryPools.getPools()) {
            if (!pool.group().equals((Object)MemoryGroup.OTHER)) continue;
            return pool.getPoolMemoryTracker();
        }
        throw new RuntimeException("Could not find memory tracker for group " + MemoryGroup.OTHER);
    }

    private static class PageFileWrapper
    extends DelegatingPagedFile {
        private final AtomicInteger flushCounter;
        private final IOController ioController;
        private final AtomicBoolean disabledIOController;
        private final AtomicInteger ioControllerChecks;

        PageFileWrapper(PagedFile delegate, AtomicInteger flushCounter, IOController ioController, AtomicBoolean disabledIOController, AtomicInteger ioControllerChecks) {
            super(delegate);
            this.flushCounter = flushCounter;
            this.ioController = ioController;
            this.disabledIOController = disabledIOController;
            this.ioControllerChecks = ioControllerChecks;
        }

        public void flushAndForce() throws IOException {
            if (this.disabledIOController.get()) {
                Assertions.assertFalse((boolean)this.ioController.isEnabled());
                this.ioControllerChecks.incrementAndGet();
            }
            this.flushCounter.incrementAndGet();
            super.flushAndForce();
        }
    }

    private static class PageCacheWrapper
    extends DelegatingPageCache {
        private final AtomicInteger flushes = new AtomicInteger();
        private final AtomicInteger fileFlushes = new AtomicInteger();
        private final AtomicInteger ioControllerChecks = new AtomicInteger();
        private final AtomicBoolean disabledIOController = new AtomicBoolean();

        PageCacheWrapper(PageCache delegate) {
            super(delegate);
        }

        public PagedFile map(Path path, int pageSize, String databaseName) throws IOException {
            return new PageFileWrapper(super.map(path, pageSize, databaseName), this.fileFlushes, IOController.DISABLED, this.disabledIOController, this.ioControllerChecks);
        }

        public PagedFile map(Path path, int pageSize, String databaseName, ImmutableSet<OpenOption> openOptions) throws IOException {
            return new PageFileWrapper(super.map(path, pageSize, databaseName, openOptions), this.fileFlushes, IOController.DISABLED, this.disabledIOController, this.ioControllerChecks);
        }

        public PagedFile map(Path path, int pageSize, String databaseName, ImmutableSet<OpenOption> openOptions, IOController ioController) throws IOException {
            return new PageFileWrapper(super.map(path, pageSize, databaseName, openOptions, ioController), this.fileFlushes, ioController, this.disabledIOController, this.ioControllerChecks);
        }

        public void flushAndForce() throws IOException {
            this.flushes.incrementAndGet();
            super.flushAndForce();
        }

        public int getFlushes() {
            return this.flushes.get();
        }

        public int getFileFlushes() {
            return this.fileFlushes.get();
        }
    }
}

