/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class NoChangeWriteTransactionTest {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private TransactionIdStore transactionIdStore;

    NoChangeWriteTransactionTest() {
    }

    @Test
    void shouldIdentifyTransactionWithNetZeroChangesAsReadOnly() {
        long startTxId = this.transactionIdStore.getLastCommittedTransactionId();
        Node node = NoChangeWriteTransactionTest.createEmptyNode((GraphDatabaseService)this.db);
        try (Transaction tx = this.db.beginTx();){
            node = tx.getNodeById(node.getId());
            node.addLabel(TestLabels.LABEL_ONE);
            node.removeLabel(TestLabels.LABEL_ONE);
            tx.commit();
        }
        Assertions.assertEquals((long)(startTxId + 2L), (long)this.transactionIdStore.getLastCommittedTransactionId(), (String)"Expected last txId to be what it started at + 2 (1 for the empty node, and one for the label)");
    }

    private static Node createEmptyNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode();
            tx.commit();
            Node node2 = node;
            return node2;
        }
    }
}

