/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.NamedThreadFactory;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.core.EntityTest;
import org.neo4j.kernel.impl.core.NodeEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.test.DoubleLatch;

public class NodeEntityTest
extends EntityTest {
    private final String PROPERTY_KEY = "PROPERTY_KEY";

    @Override
    protected long createEntity(Transaction tx) {
        return tx.createNode().getId();
    }

    @Override
    protected Entity lookupEntity(Transaction transaction, long id) {
        return transaction.getNodeById(id);
    }

    @Test
    void traceNodePageCacheAccessOnDegreeCount() {
        long sourceId;
        try (Transaction tx = this.db.beginTx();){
            Node source = tx.createNode();
            RelationshipType relationshipType = RelationshipType.withName((String)"connection");
            NodeEntityTest.createDenseNodeWithShortIncomingChain(tx, source, relationshipType);
            sourceId = source.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            CursorContext cursorContext = ((InternalTransaction)tx).kernelTransaction().cursorContext();
            PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
            Node source = tx.getNodeById(sourceId);
            ((DefaultPageCursorTracer)cursorTracer).setIgnoreCounterCheck(true);
            cursorTracer.reportEvents();
            NodeEntityTest.assertZeroTracer(cursorContext);
            source.getDegree(Direction.INCOMING);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(3L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(0L);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(3L);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void traceNodePageCacheAccessOnRelationshipTypeAndDegreeCount() {
        long sourceId;
        RelationshipType relationshipType = RelationshipType.withName((String)"connection");
        try (Transaction tx = this.db.beginTx();){
            Node source = tx.createNode();
            NodeEntityTest.createDenseNodeWithShortIncomingChain(tx, source, relationshipType);
            sourceId = source.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            CursorContext cursorContext = ((InternalTransaction)tx).kernelTransaction().cursorContext();
            PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
            Node source = tx.getNodeById(sourceId);
            ((DefaultPageCursorTracer)cursorTracer).setIgnoreCounterCheck(true);
            cursorTracer.reportEvents();
            NodeEntityTest.assertZeroTracer(cursorContext);
            source.getDegree(relationshipType, Direction.INCOMING);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(3L);
            Assertions.assertThat((long)cursorTracer.unpins()).isEqualTo(0L);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(3L);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void traceNodePageCacheAccessOnRelationshipsAccess() {
        long targetId;
        RelationshipType relationshipType = RelationshipType.withName((String)"connection");
        try (Transaction tx = this.db.beginTx();){
            Node target = tx.createNode();
            for (int i = 0; i < 100; ++i) {
                tx.createNode().createRelationshipTo(target, relationshipType);
            }
            targetId = target.getId();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            CursorContext cursorContext = ((InternalTransaction)tx).kernelTransaction().cursorContext();
            PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
            Node source = tx.getNodeById(targetId);
            ((DefaultPageCursorTracer)cursorTracer).setIgnoreCounterCheck(true);
            cursorTracer.reportEvents();
            NodeEntityTest.assertZeroTracer(cursorContext);
            Assertions.assertThat((long)Iterables.count((Iterable)source.getRelationships(Direction.INCOMING, new RelationshipType[]{relationshipType}))).isGreaterThan(0L);
            Assertions.assertThat((long)cursorTracer.hits()).isEqualTo(3L);
            Assertions.assertThat((long)cursorTracer.pins()).isEqualTo(3L);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowHumaneExceptionsWhenPropertyDoesNotExistOnNode() {
        this.createNodeWith("PROPERTY_KEY");
        NotFoundException exception = (NotFoundException)org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.createNode();
                node.getProperty("PROPERTY_KEY");
            }
        });
        Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"PROPERTY_KEY"});
    }

    @Test
    void createDropNodeLongStringProperty() {
        Node node;
        Label markerLabel = Label.label((String)"marker");
        String testPropertyKey = "testProperty";
        String propertyValue = RandomStringUtils.randomAscii((int)255);
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{markerLabel});
            node.setProperty(testPropertyKey, (Object)propertyValue);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            org.junit.jupiter.api.Assertions.assertEquals((Object)propertyValue, (Object)node.getProperty(testPropertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            node.removeProperty(testPropertyKey);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node.hasProperty(testPropertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void createDropNodeLongArrayProperty() {
        Node node;
        Label markerLabel = Label.label((String)"marker");
        String testPropertyKey = "testProperty";
        byte[] propertyValue = RandomUtils.nextBytes((int)1024);
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode(new Label[]{markerLabel});
            node.setProperty(testPropertyKey, (Object)propertyValue);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])propertyValue, (byte[])((byte[])node.getProperty(testPropertyKey)));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            node.removeProperty(testPropertyKey);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            node = (Node)Iterators.single((Iterator)tx.findNodes(markerLabel));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node.hasProperty(testPropertyKey));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowHumaneExceptionsWhenPropertyDoesNotExist() {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            node.getProperty("PROPERTY_KEY");
        }
        catch (NotFoundException exception) {
            Assertions.assertThat((String)exception.getMessage()).contains(new CharSequence[]{"PROPERTY_KEY"});
        }
    }

    @Test
    void deletionOfSameNodeTwiceInOneTransactionShouldNotRollbackIt() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        Exception exceptionThrownBySecondDelete = null;
        try (Transaction tx = this.db.beginTx();){
            tx.getNodeById(node.getId()).delete();
            try {
                tx.getNodeById(node.getId()).delete();
            }
            catch (Exception e) {
                exceptionThrownBySecondDelete = e;
            }
            tx.commit();
        }
        Assertions.assertThat((Throwable)exceptionThrownBySecondDelete).isInstanceOf(NotFoundException.class);
        org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.getNodeById(node.getId());
                tx.commit();
            }
        });
    }

    @Test
    void deletionOfAlreadyDeletedNodeShouldThrow() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(node.getId()).delete();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertThrows(NotFoundException.class, () -> {
            try (Transaction tx = this.db.beginTx();){
                tx.getNodeById(node.getId()).delete();
                tx.commit();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void getAllPropertiesShouldWorkFineWithConcurrentPropertyModifications() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(2, (ThreadFactory)NamedThreadFactory.named((String)"Test-executor-thread"));
        try {
            long nodeId;
            int propertiesCount = 100;
            try (Transaction tx = this.db.beginTx();){
                Node node = tx.createNode();
                nodeId = node.getId();
                for (int i = 0; i < 100; ++i) {
                    node.setProperty("property-" + i, (Object)i);
                }
                tx.commit();
            }
            CountDownLatch start = new CountDownLatch(1);
            AtomicBoolean writerDone = new AtomicBoolean();
            Runnable writer = () -> {
                try {
                    DoubleLatch.awaitLatch((CountDownLatch)start);
                    int propertyKey = 0;
                    while (propertyKey < 100) {
                        Transaction tx = this.db.beginTx();
                        try {
                            Node node = tx.getNodeById(nodeId);
                            for (int i = 0; i < 10 && propertyKey < 100; ++i, ++propertyKey) {
                                node.setProperty("property-" + propertyKey, (Object)UUID.randomUUID().toString());
                            }
                            tx.commit();
                        }
                        finally {
                            if (tx == null) continue;
                            tx.close();
                        }
                    }
                }
                finally {
                    writerDone.set(true);
                }
            };
            Runnable reader = () -> {
                try (Transaction tx = this.db.beginTx();){
                    Node node = tx.getNodeById(nodeId);
                    DoubleLatch.awaitLatch((CountDownLatch)start);
                    while (!writerDone.get()) {
                        int size = node.getAllProperties().size();
                        Assertions.assertThat((int)size).isGreaterThan(0);
                    }
                    tx.commit();
                }
            };
            Future<?> readerFuture = executor.submit(reader);
            Future<?> writerFuture = executor.submit(writer);
            start.countDown();
            writerFuture.get();
            readerFuture.get();
            try (Transaction tx = this.db.beginTx();){
                org.junit.jupiter.api.Assertions.assertEquals((int)100, (int)tx.getNodeById(nodeId).getAllProperties().size());
                tx.commit();
            }
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    void shouldBeAbleToForceTypeChangeOfProperty() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            node.setProperty("prop", (Object)1337);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(node.getId()).setProperty("prop", (Object)1337.0);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((Object)tx.getNodeById(node.getId()).getProperty("prop")).isInstanceOf(Double.class);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldOnlyReturnTypeOnce() {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"R"));
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"R"));
            node.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)"R"));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            Assertions.assertThat((List)Iterables.asList((Iterable)tx.getNodeById(node.getId()).getRelationshipTypes())).isEqualTo(Collections.singletonList(RelationshipType.withName((String)"R")));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowCorrectExceptionOnLabelTokensExceeded() throws KernelException {
        InternalTransaction transaction = NodeEntityTest.mockedTransactionWithDepletedTokens();
        NodeEntity nodeEntity = new NodeEntity(transaction, 5L);
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> nodeEntity.addLabel(Label.label((String)"Label")));
    }

    @Test
    void shouldThrowCorrectExceptionOnPropertyKeyTokensExceeded() throws KernelException {
        NodeEntity nodeEntity = new NodeEntity(NodeEntityTest.mockedTransactionWithDepletedTokens(), 5L);
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> nodeEntity.setProperty("key", (Object)"value"));
    }

    @Test
    void shouldThrowCorrectExceptionOnRelationshipTypeTokensExceeded() throws KernelException {
        NodeEntity nodeEntity = new NodeEntity(NodeEntityTest.mockedTransactionWithDepletedTokens(), 5L);
        org.junit.jupiter.api.Assertions.assertThrows(ConstraintViolationException.class, () -> nodeEntity.setProperty("key", (Object)"value"));
    }

    private void createNodeWith(String key) {
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            node.setProperty(key, (Object)1);
            tx.commit();
        }
    }

    private static void assertZeroTracer(CursorContext cursorContext) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.hits()).isZero();
        Assertions.assertThat((long)cursorTracer.unpins()).isZero();
        Assertions.assertThat((long)cursorTracer.pins()).isZero();
    }

    private static void createDenseNodeWithShortIncomingChain(Transaction tx, Node source, RelationshipType relationshipType) {
        for (int i = 0; i < (Integer)GraphDatabaseSettings.dense_node_threshold.defaultValue() * 2; ++i) {
            source.createRelationshipTo(tx.createNode(), relationshipType);
        }
        tx.createNode().createRelationshipTo(source, relationshipType);
    }
}

