/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

class TestRelationship
extends AbstractNeo4jTestCase {
    private static final String key1 = "key1";
    private static final String key2 = "key2";
    private static final String key3 = "key3";

    TestRelationship() {
    }

    @Test
    void testSimple() {
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            rel1.delete();
            transaction.commit();
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            TestRelationship.assertHasNext((ResourceIterable<Relationship>)((ResourceIterable)node1.getRelationships()));
            TestRelationship.assertHasNext((ResourceIterable<Relationship>)((ResourceIterable)node2.getRelationships()));
            TestRelationship.assertHasNext((ResourceIterable<Relationship>)((ResourceIterable)node1.getRelationships(new RelationshipType[]{MyRelTypes.TEST})));
            TestRelationship.assertHasNext((ResourceIterable<Relationship>)((ResourceIterable)node2.getRelationships(new RelationshipType[]{MyRelTypes.TEST})));
            TestRelationship.assertHasNext((ResourceIterable<Relationship>)((ResourceIterable)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST})));
            TestRelationship.assertHasNext((ResourceIterable<Relationship>)((ResourceIterable)node2.getRelationships(Direction.INCOMING, new RelationshipType[]{MyRelTypes.TEST})));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testSimple2() {
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            for (int i = 0; i < 3; ++i) {
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            }
            TestRelationship.allGetRelationshipMethods(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods(node2, Direction.INCOMING);
            transaction.commit();
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            TestRelationship.allGetRelationshipMethods(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods(node2, Direction.INCOMING);
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)((ResourceIterable)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST})));
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)((ResourceIterable)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL})));
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)((ResourceIterable)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST2})));
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            TestRelationship.allGetRelationshipMethods(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods(node2, Direction.INCOMING);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            TestRelationship.allGetRelationshipMethods(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods(node2, Direction.INCOMING);
            for (Relationship rel : node1.getRelationships()) {
                rel.delete();
            }
            node1.delete();
            node2.delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testSimple3() {
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            for (int i = 0; i < 1; ++i) {
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            }
            TestRelationship.allGetRelationshipMethods2(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods2(node2, Direction.INCOMING);
            transaction.commit();
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            TestRelationship.allGetRelationshipMethods2(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods2(node2, Direction.INCOMING);
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)((ResourceIterable)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST})));
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)((ResourceIterable)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL})));
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)((ResourceIterable)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST2})));
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            TestRelationship.allGetRelationshipMethods2(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods2(node2, Direction.INCOMING);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            TestRelationship.allGetRelationshipMethods2(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods2(node2, Direction.INCOMING);
            for (Relationship rel : node1.getRelationships()) {
                rel.delete();
            }
            node1.delete();
            node2.delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testSimple4() {
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            for (int i = 0; i < 2; ++i) {
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            }
            TestRelationship.allGetRelationshipMethods3(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods3(node2, Direction.INCOMING);
            transaction.commit();
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            TestRelationship.allGetRelationshipMethods3(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods3(node2, Direction.INCOMING);
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)((ResourceIterable)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST})));
            int count = 0;
            for (Relationship rel : node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL})) {
                if (count == 1) {
                    rel.delete();
                }
                ++count;
            }
            TestRelationship.deleteFirst((ResourceIterable<Relationship>)((ResourceIterable)node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST2})));
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST2);
            TestRelationship.allGetRelationshipMethods3(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods3(node2, Direction.INCOMING);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            TestRelationship.allGetRelationshipMethods3(node1, Direction.OUTGOING);
            TestRelationship.allGetRelationshipMethods3(node2, Direction.INCOMING);
            for (Relationship rel : node1.getRelationships()) {
                rel.delete();
            }
            node1.delete();
            node2.delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private static void allGetRelationshipMethods(Node node, Direction dir) {
        TestRelationship.countRelationships(9, node.getRelationships());
        TestRelationship.countRelationships(9, node.getRelationships(dir));
        TestRelationship.countRelationships(9, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(6, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2}));
        TestRelationship.countRelationships(6, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(6, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(3, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
        TestRelationship.countRelationships(3, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2}));
        TestRelationship.countRelationships(3, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(3, node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST}));
        TestRelationship.countRelationships(3, node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST2}));
        TestRelationship.countRelationships(3, node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
    }

    private static void allGetRelationshipMethods2(Node node, Direction dir) {
        TestRelationship.countRelationships(3, node.getRelationships());
        TestRelationship.countRelationships(3, node.getRelationships(dir));
        TestRelationship.countRelationships(3, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(2, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2}));
        TestRelationship.countRelationships(2, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(2, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(1, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
        TestRelationship.countRelationships(1, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2}));
        TestRelationship.countRelationships(1, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(1, node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST}));
        TestRelationship.countRelationships(1, node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST2}));
        TestRelationship.countRelationships(1, node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
    }

    private static void allGetRelationshipMethods3(Node node, Direction dir) {
        TestRelationship.countRelationships(6, node.getRelationships());
        TestRelationship.countRelationships(6, node.getRelationships(dir));
        TestRelationship.countRelationships(6, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(4, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST2}));
        TestRelationship.countRelationships(4, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(4, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2, MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(2, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
        TestRelationship.countRelationships(2, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2}));
        TestRelationship.countRelationships(2, node.getRelationships(new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
        TestRelationship.countRelationships(2, node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST}));
        TestRelationship.countRelationships(2, node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST2}));
        TestRelationship.countRelationships(2, node.getRelationships(dir, new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL}));
    }

    private static void countRelationships(int expectedCount, Iterable<Relationship> rels) {
        int count = 0;
        for (Relationship ignored : rels) {
            ++count;
        }
        Assertions.assertEquals((int)expectedCount, (int)count);
    }

    private static void deleteFirst(ResourceIterable<Relationship> iterable) {
        try (ResourceIterator iterator = iterable.iterator();){
            ((Relationship)iterator.next()).delete();
        }
    }

    @Test
    void testRelationshipCreateAndDelete() {
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            Relationship relationship = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Relationship[] relArray1 = TestRelationship.getRelationshipArray(node1.getRelationships());
            Relationship[] relArray2 = TestRelationship.getRelationshipArray(node2.getRelationships());
            Assertions.assertEquals((int)1, (int)relArray1.length);
            Assertions.assertEquals((Object)relationship, (Object)relArray1[0]);
            Assertions.assertEquals((int)1, (int)relArray2.length);
            Assertions.assertEquals((Object)relationship, (Object)relArray2[0]);
            relArray1 = TestRelationship.getRelationshipArray(node1.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray1.length);
            Assertions.assertEquals((Object)relationship, (Object)relArray1[0]);
            relArray2 = TestRelationship.getRelationshipArray(node2.getRelationships(new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray2.length);
            Assertions.assertEquals((Object)relationship, (Object)relArray2[0]);
            relArray1 = TestRelationship.getRelationshipArray(node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray1.length);
            relArray2 = TestRelationship.getRelationshipArray(node2.getRelationships(Direction.INCOMING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray2.length);
            relArray1 = TestRelationship.getRelationshipArray(node1.getRelationships(Direction.INCOMING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)0, (int)relArray1.length);
            relArray2 = TestRelationship.getRelationshipArray(node2.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)0, (int)relArray2.length);
            relationship.delete();
            node2.delete();
            node1.delete();
            transaction.commit();
        }
    }

    private static Relationship[] getRelationshipArray(Iterable<Relationship> relsIterable) {
        ArrayList<Relationship> relList = new ArrayList<Relationship>();
        for (Relationship rel : relsIterable) {
            relList.add(rel);
        }
        return relList.toArray(new Relationship[0]);
    }

    @Test
    void testDeleteWithRelationship() {
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            node1.delete();
            node2.delete();
            Assertions.assertThrows(Exception.class, () -> ((Transaction)transaction).commit());
        }
    }

    @Test
    void testDeletedRelationship() {
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            Relationship relationship = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            relationship.delete();
            Assertions.assertThrows(Exception.class, () -> relationship.setProperty(key1, (Object)1));
            node1.delete();
            node2.delete();
            transaction.commit();
        }
    }

    @Test
    void testRelationshipAddPropertyWithNullKey() {
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Assertions.assertThrows(Exception.class, () -> rel1.setProperty(null, (Object)"bar"));
            transaction.commit();
        }
    }

    @Test
    void testRelationshipAddPropertyWithNullValue() {
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Assertions.assertThrows(Exception.class, () -> rel1.setProperty("foo", null));
        }
    }

    @Test
    void testRelationshipAddProperty() {
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Relationship rel2 = node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
            Integer int1 = 1;
            Integer int2 = 2;
            String string1 = "1";
            String string2 = "2";
            rel1.setProperty(key1, (Object)int1);
            rel2.setProperty(key1, (Object)string1);
            rel1.setProperty(key2, (Object)string2);
            rel2.setProperty(key2, (Object)int2);
            Assertions.assertTrue((boolean)rel1.hasProperty(key1));
            Assertions.assertTrue((boolean)rel2.hasProperty(key1));
            Assertions.assertTrue((boolean)rel1.hasProperty(key2));
            Assertions.assertTrue((boolean)rel2.hasProperty(key2));
            Assertions.assertFalse((boolean)rel1.hasProperty(key3));
            Assertions.assertFalse((boolean)rel2.hasProperty(key3));
            Assertions.assertEquals((Object)int1, (Object)rel1.getProperty(key1));
            Assertions.assertEquals((Object)string1, (Object)rel2.getProperty(key1));
            Assertions.assertEquals((Object)string2, (Object)rel1.getProperty(key2));
            Assertions.assertEquals((Object)int2, (Object)rel2.getProperty(key2));
        }
    }

    @Test
    void testRelationshipRemoveProperty() {
        Integer int1 = 1;
        Integer int2 = 2;
        String string1 = "1";
        String string2 = "2";
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Relationship rel2 = node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
            if (rel1.removeProperty(key1) != null) {
                Assertions.fail((String)"Remove of non existing property should return null");
            }
            Assertions.assertThrows(IllegalArgumentException.class, () -> rel1.removeProperty(null));
            rel1.setProperty(key1, (Object)int1);
            rel2.setProperty(key1, (Object)string1);
            rel1.setProperty(key2, (Object)string2);
            rel2.setProperty(key2, (Object)int2);
            Assertions.assertThrows(IllegalArgumentException.class, () -> rel1.removeProperty(null));
            Assertions.assertEquals((Object)int1, (Object)rel1.removeProperty(key1));
            Assertions.assertEquals((Object)string1, (Object)rel2.removeProperty(key1));
            if (rel2.removeProperty(key1) != null) {
                Assertions.fail((String)"Remove of non existing property should return null");
            }
            rel1.delete();
            rel2.delete();
            node1.delete();
            node2.delete();
            transaction.commit();
        }
    }

    @Test
    void testRelationshipChangeProperty() {
        Integer int1 = 1;
        Integer int2 = 2;
        String string1 = "1";
        String string2 = "2";
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Relationship rel2 = node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
            rel1.setProperty(key1, (Object)int1);
            rel2.setProperty(key1, (Object)string1);
            rel1.setProperty(key2, (Object)string2);
            rel2.setProperty(key2, (Object)int2);
            Assertions.assertThrows(IllegalArgumentException.class, () -> rel1.setProperty(null, null));
            rel2.setProperty(key1, (Object)int1);
            rel1.delete();
            rel2.delete();
            node2.delete();
            node1.delete();
            transaction.commit();
        }
    }

    @Test
    void testRelationshipChangeProperty2() {
        Integer int1 = 1;
        Integer int2 = 2;
        String string1 = "1";
        String string2 = "2";
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            rel1.setProperty(key1, (Object)int1);
            rel1.setProperty(key1, (Object)int2);
            Assertions.assertEquals((Object)int2, (Object)rel1.getProperty(key1));
            rel1.removeProperty(key1);
            rel1.setProperty(key1, (Object)string1);
            rel1.setProperty(key1, (Object)string2);
            Assertions.assertEquals((Object)string2, (Object)rel1.getProperty(key1));
            rel1.removeProperty(key1);
            rel1.setProperty(key1, (Object)true);
            rel1.setProperty(key1, (Object)false);
            Assertions.assertEquals((Object)false, (Object)rel1.getProperty(key1));
            rel1.removeProperty(key1);
            rel1.delete();
            node2.delete();
            node1.delete();
            transaction.commit();
        }
    }

    @Test
    void testRelGetProperties() {
        Integer int1 = 1;
        Integer int2 = 2;
        String string = "3";
        Node node = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            Node node1 = transaction.getNodeById(node.getId());
            node2 = transaction.getNodeById(node2.getId());
            Relationship rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Assertions.assertThrows(NotFoundException.class, () -> rel1.getProperty(key1));
            Assertions.assertThrows(IllegalArgumentException.class, () -> rel1.getProperty(null));
            Assertions.assertFalse((boolean)rel1.hasProperty(key1));
            Assertions.assertFalse((boolean)rel1.hasProperty(null));
            rel1.setProperty(key1, (Object)int1);
            rel1.setProperty(key2, (Object)int2);
            rel1.setProperty(key3, (Object)string);
            Assertions.assertTrue((boolean)rel1.hasProperty(key1));
            Assertions.assertTrue((boolean)rel1.hasProperty(key2));
            Assertions.assertTrue((boolean)rel1.hasProperty(key3));
            Map properties = rel1.getAllProperties();
            Assertions.assertEquals(properties.get(key1), (Object)int1);
            Assertions.assertEquals(properties.get(key2), (Object)int2);
            Assertions.assertEquals(properties.get(key3), (Object)string);
            properties = rel1.getProperties(new String[]{key1, key2});
            Assertions.assertEquals(properties.get(key1), (Object)int1);
            Assertions.assertEquals(properties.get(key2), (Object)int2);
            Assertions.assertFalse((boolean)properties.containsKey(key3));
            properties = node1.getProperties(new String[0]);
            Assertions.assertTrue((boolean)properties.isEmpty());
            Assertions.assertThrows(NullPointerException.class, () -> node1.getProperties((String[])null));
            Assertions.assertThrows(NullPointerException.class, () -> {
                String[] names = new String[]{null};
                node1.getProperties(names);
                Assertions.fail();
            });
            Assertions.assertDoesNotThrow(() -> rel1.removeProperty(key3), (String)"Remove of property failed.");
            Assertions.assertFalse((boolean)rel1.hasProperty(key3));
            Assertions.assertFalse((boolean)rel1.hasProperty(null));
            rel1.delete();
            node2.delete();
            node1.delete();
            transaction.commit();
        }
    }

    @Test
    void testDirectedRelationship() {
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            Relationship rel2 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Relationship rel3 = node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
            Node[] nodes = rel2.getNodes();
            Assertions.assertEquals((int)2, (int)nodes.length);
            Assertions.assertTrue((nodes[0].equals(node1) && nodes[1].equals(node2) ? 1 : 0) != 0);
            nodes = rel3.getNodes();
            Assertions.assertEquals((int)2, (int)nodes.length);
            Assertions.assertTrue((nodes[0].equals(node2) && nodes[1].equals(node1) ? 1 : 0) != 0);
            Assertions.assertEquals((Object)node1, (Object)rel2.getStartNode());
            Assertions.assertEquals((Object)node2, (Object)rel2.getEndNode());
            Assertions.assertEquals((Object)node2, (Object)rel3.getStartNode());
            Assertions.assertEquals((Object)node1, (Object)rel3.getEndNode());
            Relationship[] relArray = TestRelationship.getRelationshipArray(node1.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray.length);
            Assertions.assertEquals((Object)rel2, (Object)relArray[0]);
            relArray = TestRelationship.getRelationshipArray(node1.getRelationships(Direction.INCOMING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray.length);
            Assertions.assertEquals((Object)rel3, (Object)relArray[0]);
            relArray = TestRelationship.getRelationshipArray(node2.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray.length);
            Assertions.assertEquals((Object)rel3, (Object)relArray[0]);
            relArray = TestRelationship.getRelationshipArray(node2.getRelationships(Direction.INCOMING, new RelationshipType[]{MyRelTypes.TEST}));
            Assertions.assertEquals((int)1, (int)relArray.length);
            Assertions.assertEquals((Object)rel2, (Object)relArray[0]);
            rel2.delete();
            rel3.delete();
            node1.delete();
            node2.delete();
            transaction.commit();
        }
    }

    @Test
    void testRollbackDeleteRelationship() {
        Relationship rel1;
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            rel1 = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            transaction.commit();
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node1.getId()).delete();
            transaction.getRelationshipById(rel1.getId()).delete();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            transaction.getNodeById(node1.getId()).delete();
            transaction.getNodeById(node2.getId()).delete();
            transaction.getRelationshipById(rel1.getId()).delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testCreateRelationshipWithCommits() {
        Node n1 = TestRelationship.createNode();
        Node n2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            n1 = transaction.getNodeById(n1.getId());
            n2 = transaction.getNodeById(n2.getId());
            n1.createRelationshipTo(n2, (RelationshipType)MyRelTypes.TEST);
            transaction.commit();
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            n1 = transaction.getNodeById(n1.getId());
            n2 = transaction.getNodeById(n2.getId());
            Relationship[] relArray = TestRelationship.getRelationshipArray(n1.getRelationships());
            Assertions.assertEquals((int)1, (int)relArray.length);
            relArray = TestRelationship.getRelationshipArray(n1.getRelationships());
            relArray[0].delete();
            n1.delete();
            n2.delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testAddPropertyThenDelete() {
        Relationship rel;
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            rel.setProperty("test", (Object)"test");
            transaction.commit();
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            rel = transaction.getRelationshipById(rel.getId());
            rel.setProperty("test2", (Object)"test2");
            rel.delete();
            transaction.getNodeById(node1.getId()).delete();
            transaction.getNodeById(node2.getId()).delete();
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testRelationshipIsType() {
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            Assertions.assertTrue((boolean)rel.isType((RelationshipType)MyRelTypes.TEST));
            Assertions.assertTrue((boolean)rel.isType(() -> MyRelTypes.TEST.name()));
            Assertions.assertFalse((boolean)rel.isType((RelationshipType)MyRelTypes.TEST_TRAVERSAL));
            rel.delete();
            node1.delete();
            node2.delete();
            transaction.commit();
        }
    }

    @Test
    void testChangeProperty() {
        Relationship rel;
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            rel.setProperty("test", (Object)"test1");
            transaction.commit();
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            rel = transaction.getRelationshipById(rel.getId());
            rel.setProperty("test", (Object)"test2");
            rel.removeProperty("test");
            rel.setProperty("test", (Object)"test3");
            Assertions.assertEquals((Object)"test3", (Object)rel.getProperty("test"));
            rel.removeProperty("test");
            rel.setProperty("test", (Object)"test4");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            rel = transaction.getRelationshipById(rel.getId());
            Assertions.assertEquals((Object)"test4", (Object)rel.getProperty("test"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void testChangeProperty2() {
        Relationship rel;
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            rel = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            rel.setProperty("test", (Object)"test1");
            transaction.commit();
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            rel = transaction.getRelationshipById(rel.getId());
            rel.removeProperty("test");
            rel.setProperty("test", (Object)"test3");
            Assertions.assertEquals((Object)"test3", (Object)rel.getProperty("test"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            rel = transaction.getRelationshipById(rel.getId());
            Assertions.assertEquals((Object)"test3", (Object)rel.getProperty("test"));
            rel.removeProperty("test");
            rel.setProperty("test", (Object)"test4");
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            rel = transaction.getRelationshipById(rel.getId());
            Assertions.assertEquals((Object)"test4", (Object)rel.getProperty("test"));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void makeSureLazyLoadingRelationshipsWorksEvenIfOtherIteratorAlsoLoadsInTheSameIteration() {
        Node neighbor;
        int k;
        RelationshipType innie;
        int numEdges = 100;
        GraphDatabaseService graphDB = TestRelationship.getGraphDb();
        Node[] nodes = new Node[256];
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            for (int numNodes = 0; numNodes < nodes.length; ++numNodes) {
                nodes[numNodes] = transaction.createNode();
            }
            transaction.commit();
        }
        int nextID = 7;
        Node hub = nodes[4];
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            hub = transaction.getNodeById(hub.getId());
            RelationshipType outtie = RelationshipType.withName((String)"outtie");
            innie = RelationshipType.withName((String)"innie");
            for (k = 0; k < numEdges; ++k) {
                neighbor = transaction.getNodeById(nodes[nextID].getId());
                nextID += 7;
                if ((nextID &= 0xFF) == 0) {
                    nextID = 1;
                }
                hub.createRelationshipTo(neighbor, outtie);
            }
            transaction.commit();
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            hub = transaction.getNodeById(hub.getId());
            for (k = 0; k < numEdges; ++k) {
                neighbor = transaction.getNodeById(nodes[nextID].getId());
                nextID += 7;
                if ((nextID &= 0xFF) == 0) {
                    nextID = 1;
                }
                neighbor.createRelationshipTo(hub, innie);
            }
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            hub = transaction.getNodeById(hub.getId());
            int count = 0;
            for (Relationship ignore : hub.getRelationships()) {
                count = (int)((long)count + Iterables.count((Iterable)hub.getRelationships()));
            }
            Assertions.assertEquals((int)40000, (int)count);
            count = 0;
            for (Relationship r1 : hub.getRelationships()) {
                count = (int)((long)count + Iterables.count((Iterable)hub.getRelationships()));
            }
            Assertions.assertEquals((int)40000, (int)count);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void createRelationshipAfterClearedCache() {
        int i;
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        int expectedCount = 0;
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            for (i = 0; i < 150; ++i) {
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
                ++expectedCount;
            }
            transaction.commit();
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeById(node1.getId());
            for (i = 0; i < 50; ++i) {
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
                ++expectedCount;
            }
            Assertions.assertEquals((long)expectedCount, (long)Iterables.count((Iterable)node1.getRelationships()));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            node1 = transaction.getNodeById(node1.getId());
            Assertions.assertEquals((long)expectedCount, (long)Iterables.count((Iterable)node1.getRelationships()));
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void getAllRelationships() {
        HashSet existingRelationships = new HashSet();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            Iterables.addAll(existingRelationships, (Iterable)transaction.getAllRelationships());
            transaction.commit();
        }
        HashSet<Relationship> createdRelationships = new HashSet<Relationship>();
        Node node = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node = transaction.getNodeById(node.getId());
            for (int i = 0; i < 100; ++i) {
                createdRelationships.add(node.createRelationshipTo(transaction.createNode(), (RelationshipType)MyRelTypes.TEST));
            }
            transaction.commit();
        }
        transaction = TestRelationship.getGraphDb().beginTx();
        try {
            HashSet allRelationships = new HashSet();
            allRelationships.addAll(existingRelationships);
            allRelationships.addAll(createdRelationships);
            int count = 0;
            for (Relationship rel : transaction.getAllRelationships()) {
                Assertions.assertTrue((boolean)allRelationships.contains(rel), (String)("Unexpected rel " + rel + ", expected one of " + allRelationships));
                ++count;
            }
            Assertions.assertEquals((int)allRelationships.size(), (int)count);
            transaction.commit();
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void createAndClearCacheBeforeCommit() {
        Node node = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node = transaction.getNodeById(node.getId());
            node.createRelationshipTo(transaction.createNode(), (RelationshipType)MyRelTypes.TEST);
            Assertions.assertEquals((long)1L, (long)Iterables.count((Iterable)node.getRelationships()));
            transaction.commit();
        }
    }

    @Test
    void setPropertyAndClearCacheBeforeCommit() {
        Node node = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node = transaction.getNodeById(node.getId());
            node.setProperty("name", (Object)"Test");
            Assertions.assertEquals((Object)"Test", (Object)node.getProperty("name"));
            transaction.commit();
        }
    }

    @Test
    void shouldNotGetTheSameRelationshipMoreThanOnceWhenAskingForTheSameTypeMultipleTimes() {
        Node node = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node = transaction.getNodeById(node.getId());
            node.createRelationshipTo(transaction.createNode(), RelationshipType.withName((String)"FOO"));
            long relationships = Iterables.count((Iterable)node.getRelationships(new RelationshipType[]{RelationshipType.withName((String)"FOO"), RelationshipType.withName((String)"FOO")}));
            Assertions.assertEquals((long)1L, (long)relationships);
            transaction.commit();
        }
    }

    @Test
    void shouldLoadAllRelationships() {
        long two;
        long one;
        Node node;
        GraphDatabaseAPI db = TestRelationship.getGraphDbAPI();
        try (Transaction tx = db.beginTx();){
            node = tx.createNode();
            for (int i = 0; i < 112; ++i) {
                node.createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
                tx.createNode().createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            }
            tx.commit();
        }
        try (Transaction tx = db.beginTx();){
            node = tx.getNodeById(node.getId());
            one = Iterables.count((Iterable)node.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            two = Iterables.count((Iterable)node.getRelationships(Direction.OUTGOING, new RelationshipType[]{MyRelTypes.TEST}));
            tx.commit();
        }
        Assertions.assertEquals((long)two, (long)one);
    }

    @Test
    void deletionOfSameRelationshipTwiceInOneTransactionShouldNotRollbackIt() {
        Relationship relationship;
        GraphDatabaseService db = TestRelationship.getGraphDb();
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            node2 = transaction.getNodeById(node2.getId());
            relationship = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            transaction.commit();
        }
        try (Transaction tx = db.beginTx();){
            relationship = tx.getRelationshipById(relationship.getId());
            relationship.delete();
            Assertions.assertThrows(NotFoundException.class, () -> ((Relationship)relationship).delete());
            tx.commit();
        }
        tx = db.beginTx();
        try {
            long relId = relationship.getId();
            Assertions.assertThrows(NotFoundException.class, () -> tx.getRelationshipById(relId));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void deletionOfAlreadyDeletedRelationshipShouldThrow() {
        Relationship relationship;
        GraphDatabaseService db = TestRelationship.getGraphDb();
        Node node1 = TestRelationship.createNode();
        Node node2 = TestRelationship.createNode();
        try (Transaction transaction = TestRelationship.getGraphDb().beginTx();){
            node1 = transaction.getNodeById(node1.getId());
            relationship = node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            transaction.commit();
        }
        try (Transaction tx = db.beginTx();){
            tx.getRelationshipById(relationship.getId()).delete();
            tx.commit();
        }
        tx = db.beginTx();
        try {
            Assertions.assertThrows(NotFoundException.class, () -> tx.getRelationshipById(relationship.getId()).delete());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static void assertHasNext(ResourceIterable<Relationship> relationships) {
        try (ResourceIterator iterator = relationships.iterator();){
            Assertions.assertTrue((boolean)iterator.hasNext());
        }
    }
}

