/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.IterableWrapper;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public class TestRelationshipCount {
    private static DatabaseManagementService managementService;
    private static GraphDatabaseAPI db;
    private Transaction tx;

    private static Stream<Arguments> argumentsProvider() {
        int max = (Integer)GraphDatabaseSettings.dense_node_threshold.defaultValue();
        return IntStream.range(1, max).mapToObj(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @AfterAll
    public static void shutdownDb() {
        managementService.shutdown();
    }

    public void init(int denseNodeThreshold) {
        if (db == null || (Integer)((Config)db.getDependencyResolver().resolveDependency(Config.class)).get(GraphDatabaseSettings.dense_node_threshold) != denseNodeThreshold) {
            if (db != null) {
                managementService.shutdown();
            }
            managementService = new TestDatabaseManagementServiceBuilder().impermanent().setConfig(GraphDatabaseSettings.dense_node_threshold, (Object)denseNodeThreshold).build();
            db = (GraphDatabaseAPI)managementService.database("neo4j");
        }
        this.newTransaction();
    }

    public void newTransaction() {
        if (this.tx != null) {
            this.closeTransaction();
        }
        this.tx = TestRelationshipCount.getGraphDb().beginTx();
    }

    @AfterEach
    public void closeTransaction() {
        assert (this.tx != null);
        this.tx.commit();
    }

    private static GraphDatabaseService getGraphDb() {
        return db;
    }

    @ParameterizedTest(name="denseNodeThreshold={0}")
    @MethodSource(value={"argumentsProvider"})
    public void convertNodeToDense(int denseNodeThreshold) {
        this.init(denseNodeThreshold);
        Node node = this.tx.createNode();
        EnumMap rels = new EnumMap(MyRelTypes.class);
        for (MyRelTypes type : MyRelTypes.values()) {
            rels.put(type, new HashSet());
        }
        int expectedRelCount = 0;
        int i = 0;
        while (i < 6) {
            MyRelTypes type = MyRelTypes.values()[i % MyRelTypes.values().length];
            Relationship rel = node.createRelationshipTo(this.tx.createNode(), (RelationshipType)type);
            ((Set)rels.get(type)).add(rel);
            ++i;
            ++expectedRelCount;
        }
        this.newTransaction();
        node = this.tx.getNodeById(node.getId());
        i = 0;
        while (i < 1000) {
            node.createRelationshipTo(this.tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            ++i;
            ++expectedRelCount;
        }
        Assertions.assertEquals((int)expectedRelCount, (int)node.getDegree());
        Assertions.assertEquals((int)expectedRelCount, (int)node.getDegree(Direction.BOTH));
        Assertions.assertEquals((int)expectedRelCount, (int)node.getDegree(Direction.OUTGOING));
        Assertions.assertEquals((int)0, (int)node.getDegree(Direction.INCOMING));
        Assertions.assertEquals(rels.get(MyRelTypes.TEST2), (Object)Iterables.asSet((Iterable)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST2})));
        Assertions.assertEquals(TestRelationshipCount.join((Set)rels.get(MyRelTypes.TEST_TRAVERSAL), (Set)rels.get(MyRelTypes.TEST2)), (Object)Iterables.asSet((Iterable)node.getRelationships(new RelationshipType[]{MyRelTypes.TEST_TRAVERSAL, MyRelTypes.TEST2})));
    }

    private static <T> Set<T> join(Set<T> set, Set<T> set2) {
        HashSet<T> result = new HashSet<T>(set);
        result.addAll(set2);
        return result;
    }

    @ParameterizedTest(name="denseNodeThreshold={0}")
    @MethodSource(value={"argumentsProvider"})
    public void testGetRelationshipTypesOnDiscreteNode(int denseNodeThreshold) {
        this.init(denseNodeThreshold);
        this.testGetRelationshipTypes(this.tx.createNode(), new HashSet<String>());
    }

    @ParameterizedTest(name="denseNodeThreshold={0}")
    @MethodSource(value={"argumentsProvider"})
    public void testGetRelationshipTypesOnDenseNode(int denseNodeThreshold) {
        this.init(denseNodeThreshold);
        Node node = this.tx.createNode();
        Node otherNode = this.tx.createNode();
        for (int i = 0; i < 300; ++i) {
            node.createRelationshipTo(otherNode, (RelationshipType)RelType.INITIAL);
        }
        this.testGetRelationshipTypes(node, new HashSet<String>(List.of(RelType.INITIAL.name())));
    }

    private void testGetRelationshipTypes(Node node, Set<String> expectedTypes) {
        this.assertExpectedRelationshipTypes(expectedTypes, node, false);
        node.createRelationshipTo(this.tx.createNode(), (RelationshipType)RelType.TYPE1);
        expectedTypes.add(RelType.TYPE1.name());
        this.assertExpectedRelationshipTypes(expectedTypes, node, false);
        node.createRelationshipTo(this.tx.createNode(), (RelationshipType)RelType.TYPE1);
        this.assertExpectedRelationshipTypes(expectedTypes, node, true);
        node = this.tx.getNodeById(node.getId());
        Relationship rel = node.createRelationshipTo(this.tx.createNode(), (RelationshipType)RelType.TYPE2);
        expectedTypes.add(RelType.TYPE2.name());
        this.assertExpectedRelationshipTypes(expectedTypes, node, false);
        rel.delete();
        expectedTypes.remove(RelType.TYPE2.name());
        this.assertExpectedRelationshipTypes(expectedTypes, node, true);
        node = this.tx.getNodeById(node.getId());
        node.createRelationshipTo(this.tx.createNode(), (RelationshipType)RelType.TYPE2);
        node.createRelationshipTo(this.tx.createNode(), (RelationshipType)RelType.TYPE2);
        expectedTypes.add(RelType.TYPE2.name());
        node.createRelationshipTo(this.tx.createNode(), (RelationshipType)MyRelTypes.TEST);
        expectedTypes.add(MyRelTypes.TEST.name());
        this.assertExpectedRelationshipTypes(expectedTypes, node, true);
        node = this.tx.getNodeById(node.getId());
        for (Relationship r : node.getRelationships(new RelationshipType[]{RelType.TYPE1})) {
            this.assertExpectedRelationshipTypes(expectedTypes, node, false);
            r.delete();
        }
        expectedTypes.remove(RelType.TYPE1.name());
        this.assertExpectedRelationshipTypes(expectedTypes, node, true);
    }

    private void assertExpectedRelationshipTypes(Set<String> expectedTypes, Node node, boolean commit) {
        Set actual = Iterables.asSet(TestRelationshipCount.asStrings(node.getRelationshipTypes()));
        Assertions.assertEquals(expectedTypes, (Object)actual);
        if (commit) {
            this.newTransaction();
        }
        Assertions.assertEquals(expectedTypes, (Object)Iterables.asSet(TestRelationshipCount.asStrings(this.tx.getNodeById(node.getId()).getRelationshipTypes())));
    }

    private static Iterable<String> asStrings(Iterable<RelationshipType> relationshipTypes) {
        return new IterableWrapper<String, RelationshipType>(relationshipTypes){

            protected String underlyingObjectToObject(RelationshipType object) {
                return object.name();
            }
        };
    }

    @ParameterizedTest(name="denseNodeThreshold={0}")
    @MethodSource(value={"argumentsProvider"})
    public void withoutLoops(int denseNodeThreshold) {
        int i;
        this.init(denseNodeThreshold);
        Node node1 = this.tx.createNode();
        Node node2 = this.tx.createNode();
        Assertions.assertEquals((int)0, (int)node1.getDegree());
        Assertions.assertEquals((int)0, (int)node2.getDegree());
        node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
        Assertions.assertEquals((int)1, (int)node1.getDegree());
        Assertions.assertEquals((int)1, (int)node2.getDegree());
        node1.createRelationshipTo(this.tx.createNode(), (RelationshipType)MyRelTypes.TEST2);
        Assertions.assertEquals((int)2, (int)node1.getDegree());
        Assertions.assertEquals((int)1, (int)node2.getDegree());
        this.newTransaction();
        node1 = this.tx.getNodeById(node1.getId());
        node2 = this.tx.getNodeById(node2.getId());
        Assertions.assertEquals((int)2, (int)node1.getDegree());
        Assertions.assertEquals((int)1, (int)node2.getDegree());
        for (i = 0; i < 1000; ++i) {
            if (i % 2 == 0) {
                node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            } else {
                node2.createRelationshipTo(node1, (RelationshipType)MyRelTypes.TEST);
            }
            Assertions.assertEquals((int)(i + 2 + 1), (int)node1.getDegree());
            Assertions.assertEquals((int)(i + 1 + 1), (int)node2.getDegree());
            if (i % 10 != 0) continue;
            this.newTransaction();
            node1 = this.tx.getNodeById(node1.getId());
            node2 = this.tx.getNodeById(node2.getId());
        }
        node1 = this.tx.getNodeById(node1.getId());
        node2 = this.tx.getNodeById(node2.getId());
        for (i = 0; i < 2; ++i) {
            Assertions.assertEquals((int)1002, (int)node1.getDegree());
            Assertions.assertEquals((int)1002, (int)node1.getDegree(Direction.BOTH));
            Assertions.assertEquals((int)502, (int)node1.getDegree(Direction.OUTGOING));
            Assertions.assertEquals((int)500, (int)node1.getDegree(Direction.INCOMING));
            Assertions.assertEquals((int)1, (int)node1.getDegree((RelationshipType)MyRelTypes.TEST2));
            Assertions.assertEquals((int)1001, (int)node1.getDegree((RelationshipType)MyRelTypes.TEST));
            Assertions.assertEquals((int)1001, (int)node1.getDegree((RelationshipType)MyRelTypes.TEST, Direction.BOTH));
            Assertions.assertEquals((int)501, (int)node1.getDegree((RelationshipType)MyRelTypes.TEST, Direction.OUTGOING));
            Assertions.assertEquals((int)500, (int)node1.getDegree((RelationshipType)MyRelTypes.TEST, Direction.INCOMING));
            Assertions.assertEquals((int)1, (int)node1.getDegree((RelationshipType)MyRelTypes.TEST2, Direction.OUTGOING));
            Assertions.assertEquals((int)0, (int)node1.getDegree((RelationshipType)MyRelTypes.TEST2, Direction.INCOMING));
            this.newTransaction();
            node1 = this.tx.getNodeById(node1.getId());
            node2 = this.tx.getNodeById(node2.getId());
        }
        for (Relationship rel : node1.getRelationships()) {
            rel.delete();
        }
        node1.delete();
        for (Relationship rel : node2.getRelationships()) {
            rel.delete();
        }
        node2.delete();
        this.newTransaction();
    }

    @ParameterizedTest(name="denseNodeThreshold={0}")
    @MethodSource(value={"argumentsProvider"})
    public void withLoops(int denseNodeThreshold) {
        this.init(denseNodeThreshold);
        for (int i = 0; i < 10; ++i) {
            this.tx.createNode().createRelationshipTo(this.tx.createNode(), (RelationshipType)MyRelTypes.TEST);
        }
        Node node = this.tx.createNode();
        Assertions.assertEquals((int)0, (int)node.getDegree());
        node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
        Assertions.assertEquals((int)1, (int)node.getDegree());
        Node otherNode = this.tx.createNode();
        Relationship rel2 = node.createRelationshipTo(otherNode, (RelationshipType)MyRelTypes.TEST2);
        Assertions.assertEquals((int)2, (int)node.getDegree());
        Assertions.assertEquals((int)1, (int)otherNode.getDegree());
        this.newTransaction();
        node = this.tx.getNodeById(node.getId());
        otherNode = this.tx.getNodeById(otherNode.getId());
        rel2 = this.tx.getRelationshipById(rel2.getId());
        Assertions.assertEquals((int)2, (int)node.getDegree());
        Relationship rel3 = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST_TRAVERSAL);
        Assertions.assertEquals((int)3, (int)node.getDegree());
        Assertions.assertEquals((int)1, (int)otherNode.getDegree());
        rel2.delete();
        Assertions.assertEquals((int)2, (int)node.getDegree());
        Assertions.assertEquals((int)0, (int)otherNode.getDegree());
        rel3.delete();
        Assertions.assertEquals((int)1, (int)node.getDegree());
    }

    @ParameterizedTest(name="denseNodeThreshold={0}")
    @MethodSource(value={"argumentsProvider"})
    public void ensureRightDegree(int denseNodeThreshold) {
        this.init(denseNodeThreshold);
        for (int initialSize : new int[]{0, 95, 200}) {
            this.ensureRightDegree(initialSize, Arrays.asList(TestRelationshipCount.create(RelType.TYPE1, Direction.OUTGOING, 5), TestRelationshipCount.create(RelType.TYPE1, Direction.INCOMING, 2), TestRelationshipCount.create(RelType.TYPE2, Direction.OUTGOING, 6), TestRelationshipCount.create(RelType.TYPE2, Direction.INCOMING, 7), TestRelationshipCount.create(RelType.TYPE2, Direction.BOTH, 3)), Arrays.asList(TestRelationshipCount.delete(RelType.TYPE1, Direction.OUTGOING, 0), TestRelationshipCount.delete(RelType.TYPE1, Direction.INCOMING, 1), TestRelationshipCount.delete(RelType.TYPE2, Direction.OUTGOING, Integer.MAX_VALUE), TestRelationshipCount.delete(RelType.TYPE2, Direction.INCOMING, 1), TestRelationshipCount.delete(RelType.TYPE2, Direction.BOTH, Integer.MAX_VALUE)));
            this.ensureRightDegree(initialSize, Arrays.asList(TestRelationshipCount.create(RelType.TYPE1, Direction.BOTH, 1), TestRelationshipCount.create(RelType.TYPE1, Direction.OUTGOING, 5), TestRelationshipCount.create(RelType.TYPE2, Direction.OUTGOING, 6), TestRelationshipCount.create(RelType.TYPE1, Direction.INCOMING, 2), TestRelationshipCount.create(RelType.TYPE2, Direction.BOTH, 3), TestRelationshipCount.create(RelType.TYPE2, Direction.INCOMING, 7), TestRelationshipCount.create(RelType.TYPE2, Direction.BOTH, 3)), null);
            this.ensureRightDegree(initialSize, Arrays.asList(TestRelationshipCount.create(RelType.TYPE1, Direction.BOTH, 2), TestRelationshipCount.create(RelType.TYPE2, Direction.BOTH, 1), TestRelationshipCount.create(RelType.TYPE1, Direction.OUTGOING, 1), TestRelationshipCount.create(RelType.TYPE2, Direction.OUTGOING, 10), TestRelationshipCount.create(RelType.TYPE1, Direction.INCOMING, 2), TestRelationshipCount.create(RelType.TYPE2, Direction.BOTH, 2), TestRelationshipCount.create(RelType.TYPE2, Direction.INCOMING, 7)), null);
        }
    }

    private void ensureRightDegree(int initialSize, Collection<RelationshipCreationSpec> cspecs, Collection<RelationshipDeletionSpec> dspecs) {
        EnumMap<RelType, int[]> expectedCounts = new EnumMap<RelType, int[]>(RelType.class);
        for (RelType relType : RelType.values()) {
            expectedCounts.put(relType, new int[3]);
        }
        Node me = this.tx.createNode();
        for (int i = 0; i < initialSize; ++i) {
            me.createRelationshipTo(this.tx.createNode(), (RelationshipType)RelType.INITIAL);
        }
        this.newTransaction();
        me = this.tx.getNodeById(me.getId());
        ((int[])expectedCounts.get((Object)((Object)RelType.INITIAL)))[0] = initialSize;
        TestRelationshipCount.assertCounts(me, expectedCounts);
        int counter = 0;
        for (RelationshipCreationSpec relationshipCreationSpec : cspecs) {
            for (int i = 0; i < relationshipCreationSpec.count; ++i) {
                Node otherNode = null;
                if (relationshipCreationSpec.dir == Direction.OUTGOING) {
                    otherNode = this.tx.createNode();
                    me.createRelationshipTo(otherNode, (RelationshipType)relationshipCreationSpec.type);
                } else if (relationshipCreationSpec.dir == Direction.INCOMING) {
                    otherNode = this.tx.createNode();
                    otherNode.createRelationshipTo(me, (RelationshipType)relationshipCreationSpec.type);
                } else {
                    me.createRelationshipTo(me, (RelationshipType)relationshipCreationSpec.type);
                }
                int[] nArray = (int[])expectedCounts.get((Object)relationshipCreationSpec.type);
                int n = relationshipCreationSpec.dir.ordinal();
                nArray[n] = nArray[n] + 1;
                if (otherNode != null) {
                    Assertions.assertEquals((int)1, (int)otherNode.getDegree());
                }
                TestRelationshipCount.assertCounts(me, expectedCounts);
                if (counter % 3 != 0 || counter <= 0) continue;
                this.newTransaction();
                TestRelationshipCount.assertCounts(me, expectedCounts);
            }
        }
        TestRelationshipCount.assertCounts(me, expectedCounts);
        this.newTransaction();
        me = this.tx.getNodeById(me.getId());
        TestRelationshipCount.assertCounts(me, expectedCounts);
        counter = 0;
        if (dspecs == null) {
            for (RelType type : RelType.values()) {
                if (!type.measure) continue;
                for (Direction direction : Direction.values()) {
                    int[] counts = (int[])expectedCounts.get((Object)type);
                    if (counts[direction.ordinal()] <= 0) continue;
                    TestRelationshipCount.deleteOneRelationship(me, type, direction, 0);
                    int n = direction.ordinal();
                    counts[n] = counts[n] - 1;
                    TestRelationshipCount.assertCounts(me, expectedCounts);
                    if (counter % 3 != 0 || counter <= 0) continue;
                    this.newTransaction();
                    TestRelationshipCount.assertCounts(me, expectedCounts);
                }
            }
        } else {
            for (RelationshipDeletionSpec relationshipDeletionSpec : dspecs) {
                TestRelationshipCount.deleteOneRelationship(me, relationshipDeletionSpec.type, relationshipDeletionSpec.dir, relationshipDeletionSpec.which);
                int[] nArray = (int[])expectedCounts.get((Object)relationshipDeletionSpec.type);
                int n = relationshipDeletionSpec.dir.ordinal();
                nArray[n] = nArray[n] - 1;
                TestRelationshipCount.assertCounts(me, expectedCounts);
                if (counter % 3 != 0 || counter <= 0) continue;
                this.newTransaction();
                TestRelationshipCount.assertCounts(me, expectedCounts);
            }
        }
        TestRelationshipCount.assertCounts(me, expectedCounts);
        this.newTransaction();
        me = this.tx.getNodeById(me.getId());
        TestRelationshipCount.assertCounts(me, expectedCounts);
        for (Relationship relationship : me.getRelationships()) {
            Node otherNode = relationship.getOtherNode(me);
            if (!otherNode.equals(me)) {
                otherNode.delete();
            }
            relationship.delete();
        }
        me.delete();
    }

    private static void assertCounts(Node me, Map<RelType, int[]> expectedCounts) {
        Assertions.assertEquals((int)TestRelationshipCount.totalCount(expectedCounts, Direction.BOTH), (int)me.getDegree());
        Assertions.assertEquals((int)TestRelationshipCount.totalCount(expectedCounts, Direction.BOTH), (int)me.getDegree(Direction.BOTH));
        Assertions.assertEquals((int)TestRelationshipCount.totalCount(expectedCounts, Direction.OUTGOING), (int)me.getDegree(Direction.OUTGOING));
        Assertions.assertEquals((int)TestRelationshipCount.totalCount(expectedCounts, Direction.INCOMING), (int)me.getDegree(Direction.INCOMING));
        for (Map.Entry<RelType, int[]> entry : expectedCounts.entrySet()) {
            RelType type = entry.getKey();
            Assertions.assertEquals((int)TestRelationshipCount.totalCount(entry.getValue(), Direction.BOTH), (int)me.getDegree((RelationshipType)type));
            Assertions.assertEquals((int)TestRelationshipCount.totalCount(entry.getValue(), Direction.OUTGOING), (int)me.getDegree((RelationshipType)type, Direction.OUTGOING));
            Assertions.assertEquals((int)TestRelationshipCount.totalCount(entry.getValue(), Direction.INCOMING), (int)me.getDegree((RelationshipType)type, Direction.INCOMING));
            Assertions.assertEquals((int)TestRelationshipCount.totalCount(entry.getValue(), Direction.BOTH), (int)me.getDegree((RelationshipType)type, Direction.BOTH));
        }
    }

    private static int totalCount(Map<RelType, int[]> expectedCounts, Direction direction) {
        int result = 0;
        for (Map.Entry<RelType, int[]> entry : expectedCounts.entrySet()) {
            result += TestRelationshipCount.totalCount(entry.getValue(), direction);
        }
        return result;
    }

    private static int totalCount(int[] expectedCounts, Direction direction) {
        int result = 0;
        if (direction == Direction.OUTGOING || direction == Direction.BOTH) {
            result += expectedCounts[0];
        }
        if (direction == Direction.INCOMING || direction == Direction.BOTH) {
            result += expectedCounts[1];
        }
        return result += expectedCounts[2];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void deleteOneRelationship(Node node, RelType type, Direction direction, int which) {
        Relationship last = null;
        int counter = 0;
        Iterable relationships = node.getRelationships(direction, new RelationshipType[]{type});
        try (ResourceIterator relationshipIterator = (ResourceIterator)relationships.iterator();){
            while (relationshipIterator.hasNext()) {
                Relationship rel = (Relationship)relationshipIterator.next();
                if (TestRelationshipCount.isLoop(rel) != (direction == Direction.BOTH)) continue;
                last = rel;
                if (counter++ != which) continue;
                rel.delete();
                return;
            }
        }
        if (which == Integer.MAX_VALUE && last != null) {
            last.delete();
            return;
        }
        Assertions.fail((String)("Couldn't find " + (direction == Direction.BOTH ? "loop" : "non-loop") + " relationship " + type.name() + " " + direction + " to delete"));
    }

    private static boolean isLoop(Relationship r) {
        return r.getStartNode().equals(r.getEndNode());
    }

    static RelationshipCreationSpec create(RelType type, Direction dir, int count) {
        return new RelationshipCreationSpec(type, dir, count);
    }

    static RelationshipDeletionSpec delete(RelType type, Direction dir, int which) {
        return new RelationshipDeletionSpec(type, dir, which);
    }

    private static enum RelType implements RelationshipType
    {
        INITIAL(false),
        TYPE1(true),
        TYPE2(true);

        boolean measure;

        private RelType(boolean measure) {
            this.measure = measure;
        }
    }

    private static class RelationshipDeletionSpec {
        private final RelType type;
        private final Direction dir;
        private final int which;

        RelationshipDeletionSpec(RelType type, Direction dir, int which) {
            this.type = type;
            this.dir = dir;
            this.which = which;
        }
    }

    private static class RelationshipCreationSpec {
        private final RelType type;
        private final Direction dir;
        private final int count;

        RelationshipCreationSpec(RelType type, Direction dir, int count) {
            this.type = type;
            this.dir = dir;
            this.count = count;
        }
    }
}

