/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.IndexReadAsserts;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;

public class NodeLabelTokenIndexCursorTest
extends KernelAPIWriteTestBase<WriteTestSupport> {
    private final String labelOneName = "Label1";
    private final String labelTwoName = "Label2";
    private final String labelThreeName = "Label3";
    private final String labelFirstName = "Label4";
    private int labelOne;
    private int labelTwo;
    private int labelThree;
    private int labelFirst;

    @Override
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }

    @BeforeAll
    void setupClass() throws Exception {
        try (KernelTransaction tx = NodeLabelTokenIndexCursorTest.beginTransaction();){
            TokenWrite tokenWrite = tx.tokenWrite();
            this.labelOne = tokenWrite.labelGetOrCreateForName("Label1");
            this.labelTwo = tokenWrite.labelGetOrCreateForName("Label2");
            this.labelThree = tokenWrite.labelGetOrCreateForName("Label3");
            this.labelFirst = tokenWrite.labelGetOrCreateForName("Label4");
        }
    }

    @Test
    void shouldFindNodesByLabel() throws Exception {
        long toDelete;
        try (KernelTransaction tx = NodeLabelTokenIndexCursorTest.beginTransaction();){
            NodeLabelTokenIndexCursorTest.createNode(tx.dataWrite(), this.labelOne, this.labelFirst);
            NodeLabelTokenIndexCursorTest.createNode(tx.dataWrite(), this.labelTwo, this.labelFirst);
            NodeLabelTokenIndexCursorTest.createNode(tx.dataWrite(), this.labelThree, this.labelFirst);
            toDelete = NodeLabelTokenIndexCursorTest.createNode(tx.dataWrite(), this.labelOne);
            NodeLabelTokenIndexCursorTest.createNode(tx.dataWrite(), this.labelTwo);
            NodeLabelTokenIndexCursorTest.createNode(tx.dataWrite(), this.labelThree);
            NodeLabelTokenIndexCursorTest.createNode(tx.dataWrite(), this.labelThree);
            tx.commit();
        }
        tx = NodeLabelTokenIndexCursorTest.beginTransaction();
        try {
            tx.dataWrite().nodeDelete(toDelete);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = NodeLabelTokenIndexCursorTest.beginTransaction();
        try {
            Read read = tx.dataRead();
            TokenReadSession session = NodeLabelTokenIndexCursorTest.getTokenReadSession(tx);
            CursorContext cursorContext = tx.cursorContext();
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(cursorContext);){
                LongHashSet uniqueIds = new LongHashSet();
                read.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(this.labelOne), cursorContext);
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 1, (MutableLongSet)uniqueIds);
                read.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(this.labelTwo), cursorContext);
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 2, (MutableLongSet)uniqueIds);
                read.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(this.labelThree), cursorContext);
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 3, (MutableLongSet)uniqueIds);
                uniqueIds.clear();
                read.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(this.labelFirst), cursorContext);
                IndexReadAsserts.assertNodeCount((NodeIndexCursor)cursor, 3, (MutableLongSet)uniqueIds);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static TokenReadSession getTokenReadSession(KernelTransaction tx) throws IndexNotFoundKernelException {
        AnyTokenSchemaDescriptor descriptor = SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE);
        Iterator indexes = tx.schemaRead().index((SchemaDescriptor)descriptor);
        TokenReadSession session = tx.dataRead().tokenReadSession((IndexDescriptor)indexes.next());
        return session;
    }

    @Test
    void shouldFindNodesByLabelInTx() throws Exception {
        long deletedInTx;
        long inStore;
        try (KernelTransaction tx = NodeLabelTokenIndexCursorTest.beginTransaction();){
            inStore = NodeLabelTokenIndexCursorTest.createNode(tx.dataWrite(), this.labelOne);
            NodeLabelTokenIndexCursorTest.createNode(tx.dataWrite(), this.labelTwo);
            deletedInTx = NodeLabelTokenIndexCursorTest.createNode(tx.dataWrite(), this.labelOne);
            tx.commit();
        }
        tx = NodeLabelTokenIndexCursorTest.beginTransaction();
        try {
            tx.dataWrite().nodeDelete(deletedInTx);
            long createdInTx = NodeLabelTokenIndexCursorTest.createNode(tx.dataWrite(), this.labelOne);
            NodeLabelTokenIndexCursorTest.createNode(tx.dataWrite(), this.labelTwo);
            Read read = tx.dataRead();
            TokenReadSession session = NodeLabelTokenIndexCursorTest.getTokenReadSession(tx);
            CursorContext cursorContext = tx.cursorContext();
            try (NodeLabelIndexCursor cursor = tx.cursors().allocateNodeLabelIndexCursor(cursorContext);){
                LongHashSet uniqueIds = new LongHashSet();
                read.nodeLabelScan(session, cursor, IndexQueryConstraints.unconstrained(), new TokenPredicate(this.labelOne), cursorContext);
                IndexReadAsserts.assertNodes((NodeIndexCursor)cursor, (MutableLongSet)uniqueIds, inStore, createdInTx);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static long createNode(Write write, int ... labels) throws KernelException {
        long nodeId = write.nodeCreate();
        for (int label : labels) {
            write.nodeAddLabel(nodeId, label);
        }
        return nodeId;
    }
}

