/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIReadTestSupport;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

public abstract class PropertyCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static final String LONG_STRING = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget nibh cursus, efficitur risus non, ultrices justo. Nulla laoreet eros mi, non molestie magna luctus in. Fusce nibh neque, tristique ultrices laoreet et, aliquet non dolor. Donec ultrices nisi eget urna luctus volutpat. Vivamus hendrerit eget justo vel scelerisque. Morbi interdum volutpat diam, et cursus arcu efficitur consectetur. Cras vitae facilisis ipsum, vitae ullamcorper orci. Nullam tristique ante sed nibh consequat posuere. Curabitur mauris nisl, condimentum ac varius vel, imperdiet a neque. Sed euismod condimentum nisl, vel efficitur turpis tempus id.\n\nSed in tempor arcu. Suspendisse molestie rutrum risus a dignissim. Donec et orci non diam tincidunt sollicitudin non id nisi. Aliquam vehicula imperdiet viverra. Cras et lacinia eros. Etiam imperdiet ac dolor ut tristique. Phasellus ut lacinia ex. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Integer libero justo, tincidunt ut felis non, interdum consectetur mauris. Cras eu felis ante. Sed dapibus nulla urna, at elementum tortor ultricies pretium. Maecenas sed augue non urna consectetur fringilla vitae eu libero. Vivamus interdum bibendum risus, quis luctus eros.\n\nSed neque augue, fermentum sit amet iaculis ut, porttitor ac odio. Phasellus et sapien non sapien consequat fermentum accumsan non dolor. Integer eget pellentesque lectus, vitae lobortis ante. Nam elementum, dui ut finibus rutrum, purus mauris efficitur purus, efficitur tempus ante metus bibendum velit. Curabitur commodo, risus et eleifend facilisis, eros augue posuere tortor, eu dictum erat tortor consectetur orci. Fusce a velit dignissim, tempus libero nec, faucibus risus. Nullam pharetra mauris sit amet volutpat facilisis. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Praesent lacinia non felis ut lobortis.\n\nOrci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed eu nisi dui. Suspendisse imperdiet lorem vel eleifend faucibus. Mauris non venenatis metus. Aenean neque magna, rhoncus vel velit in, dictum convallis leo. Phasellus pulvinar eu sapien ac vehicula. Praesent placerat augue quam, egestas vehicula velit porttitor in. Vivamus velit metus, pellentesque quis fermentum et, porta quis velit. Curabitur sed lacus quis nibh convallis tincidunt.\n\nEtiam eu elit eget dolor dignissim lacinia. Vivamus tortor ex, dapibus id elementum non, suscipit ac nisl. Aenean vel tempor libero, eu venenatis elit. Nunc nec velit eu odio interdum pellentesque sed et eros. Nam quis mi in metus tristique aliquam. Nullam facilisis dapibus lacus, nec lacinia velit. Proin massa enim, accumsan ac libero at, iaculis sodales tellus. Vivamus fringilla justo sed luctus tincidunt. Sed placerat fringilla ex, vel placerat sem faucibus eget. Vestibulum semper dui sit amet efficitur blandit. Donec eu tellus velit. Etiam a mi nec massa euismod posuere. Cras eget lacus leo.";
    private static final String DATE_PROP = "dateProp";
    private static final String POINT_PROP = "pointProp";
    private static final String BYTE_PROP = "byteProp";
    private static final String SHORT_PROP = "shortProp";
    private static final String INT_PROP = "intProp";
    private static final String INLINE_LONG_PROP = "inlineLongProp";
    private static final String LONG_PROP = "longProp";
    private static final String FLOAT_PROP = "floatProp";
    private static final String DOUBLE_PROP = "doubleProp";
    private static final String TRUE_PROP = "trueProp";
    private static final String FALSE_PROP = "falseProp";
    private static final String CHAR_PROP = "charProp";
    private static final String EMPTY_STRING_PROP = "emptyStringProp";
    private static final String SHORT_STRING_PROP = "shortStringProp";
    private static final String LONG_STRING_PROP = "longStringProp";
    private static final String UTF_8_PROP = "utf8Prop";
    private static final String SMALL_ARRAY_PROP = "smallArrayProp";
    private static final String BIG_ARRAY_PROP = "bigArrayProp";
    private static long bareNodeId;
    private static long bytePropNodeId;
    private static long shortPropNodeId;
    private static long intPropNodeId;
    private static long inlineLongPropNodeId;
    private static long longPropNodeId;
    private static long floatPropNodeId;
    private static long doublePropNodeId;
    private static long truePropNodeId;
    private static long falsePropNodeId;
    private static long charPropNodeId;
    private static long emptyStringPropNodeId;
    private static long shortStringPropNodeId;
    private static long longStringPropNodeId;
    private static long utf8PropNodeId;
    private static long smallArrayNodeId;
    private static long bigArrayNodeId;
    private static long pointPropNodeId;
    private static long datePropNodeId;
    private static long allPropsNodeId;
    private static long bareRelId;
    private static long bytePropRelId;
    private static long shortPropRelId;
    private static long intPropRelId;
    private static long inlineLongPropRelId;
    private static long longPropRelId;
    private static long floatPropRelId;
    private static long doublePropRelId;
    private static long truePropRelId;
    private static long falsePropRelId;
    private static long charPropRelId;
    private static long emptyStringPropRelId;
    private static long shortStringPropRelId;
    private static long longStringPropRelId;
    private static long utf8PropRelId;
    private static long smallArrayRelId;
    private static long bigArrayRelId;
    private static long pointPropRelId;
    private static long datePropRelId;
    private static long allPropsRelId;
    private static final String CHINESE = "\u9020Unicode\u4e4b";
    private static final Value POINT_VALUE;
    private static final Value DATE_VALUE;

    private static boolean supportsBigProperties() {
        return true;
    }

    @Override
    public void createTestGraph(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            bareNodeId = tx.createNode().getId();
            bytePropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, BYTE_PROP, (byte)13);
            shortPropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, SHORT_PROP, (short)13);
            intPropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, INT_PROP, 13);
            inlineLongPropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, INLINE_LONG_PROP, 13L);
            longPropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, LONG_PROP, Long.MAX_VALUE);
            floatPropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, FLOAT_PROP, Float.valueOf(13.0f));
            doublePropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, DOUBLE_PROP, 13.0);
            truePropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, TRUE_PROP, true);
            falsePropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, FALSE_PROP, false);
            charPropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, CHAR_PROP, Character.valueOf('x'));
            emptyStringPropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, EMPTY_STRING_PROP, "");
            shortStringPropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, SHORT_STRING_PROP, "hello");
            longStringPropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, LONG_STRING_PROP, LONG_STRING);
            utf8PropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, UTF_8_PROP, CHINESE);
            smallArrayNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, SMALL_ARRAY_PROP, new int[]{1, 2, 3, 4});
            bigArrayNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, BIG_ARRAY_PROP, new String[]{LONG_STRING});
            pointPropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, POINT_PROP, POINT_VALUE);
            datePropNodeId = PropertyCursorTestBase.createNodeWithProperty(tx, DATE_PROP, DATE_VALUE);
            Node allPropsNode = tx.createNode();
            allPropsNode.setProperty(BYTE_PROP, (Object)13);
            allPropsNode.setProperty(SHORT_PROP, (Object)13);
            allPropsNode.setProperty(INT_PROP, (Object)13);
            allPropsNode.setProperty(INLINE_LONG_PROP, (Object)13L);
            allPropsNode.setProperty(LONG_PROP, (Object)Long.MAX_VALUE);
            allPropsNode.setProperty(FLOAT_PROP, (Object)Float.valueOf(13.0f));
            allPropsNode.setProperty(DOUBLE_PROP, (Object)13.0);
            allPropsNode.setProperty(TRUE_PROP, (Object)true);
            allPropsNode.setProperty(FALSE_PROP, (Object)false);
            allPropsNode.setProperty(CHAR_PROP, (Object)Character.valueOf('x'));
            allPropsNode.setProperty(EMPTY_STRING_PROP, (Object)"");
            allPropsNode.setProperty(SHORT_STRING_PROP, (Object)"hello");
            allPropsNode.setProperty(UTF_8_PROP, (Object)CHINESE);
            allPropsNode.setProperty(POINT_PROP, (Object)POINT_VALUE);
            allPropsNode.setProperty(DATE_PROP, (Object)DATE_VALUE);
            if (PropertyCursorTestBase.supportsBigProperties()) {
                allPropsNode.setProperty(LONG_STRING_PROP, (Object)LONG_STRING);
                allPropsNode.setProperty(SMALL_ARRAY_PROP, (Object)new int[]{1, 2, 3, 4});
                allPropsNode.setProperty(BIG_ARRAY_PROP, (Object)new String[]{LONG_STRING});
            }
            allPropsNodeId = allPropsNode.getId();
            RelationshipType type = RelationshipType.withName((String)"REL");
            bareRelId = tx.createNode().createRelationshipTo(tx.createNode(), type).getId();
            bytePropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, BYTE_PROP, (byte)13);
            shortPropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, SHORT_PROP, (short)13);
            intPropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, INT_PROP, 13);
            inlineLongPropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, INLINE_LONG_PROP, 13L);
            longPropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, LONG_PROP, Long.MAX_VALUE);
            floatPropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, FLOAT_PROP, Float.valueOf(13.0f));
            doublePropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, DOUBLE_PROP, 13.0);
            truePropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, TRUE_PROP, true);
            falsePropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, FALSE_PROP, false);
            charPropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, CHAR_PROP, Character.valueOf('x'));
            emptyStringPropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, EMPTY_STRING_PROP, "");
            shortStringPropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, SHORT_STRING_PROP, "hello");
            longStringPropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, LONG_STRING_PROP, LONG_STRING);
            utf8PropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, UTF_8_PROP, CHINESE);
            smallArrayRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, SMALL_ARRAY_PROP, new int[]{1, 2, 3, 4});
            bigArrayRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, BIG_ARRAY_PROP, new String[]{LONG_STRING});
            pointPropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, POINT_PROP, POINT_VALUE);
            datePropRelId = PropertyCursorTestBase.createRelWithProperty(tx, type, DATE_PROP, DATE_VALUE);
            Relationship allPropsRel = allPropsNode.createRelationshipTo(tx.createNode(), type);
            allPropsRelId = allPropsRel.getId();
            allPropsRel.setProperty(BYTE_PROP, (Object)13);
            allPropsRel.setProperty(SHORT_PROP, (Object)13);
            allPropsRel.setProperty(INT_PROP, (Object)13);
            allPropsRel.setProperty(INLINE_LONG_PROP, (Object)13L);
            allPropsRel.setProperty(LONG_PROP, (Object)Long.MAX_VALUE);
            allPropsRel.setProperty(FLOAT_PROP, (Object)Float.valueOf(13.0f));
            allPropsRel.setProperty(DOUBLE_PROP, (Object)13.0);
            allPropsRel.setProperty(TRUE_PROP, (Object)true);
            allPropsRel.setProperty(FALSE_PROP, (Object)false);
            allPropsRel.setProperty(CHAR_PROP, (Object)Character.valueOf('x'));
            allPropsRel.setProperty(EMPTY_STRING_PROP, (Object)"");
            allPropsRel.setProperty(SHORT_STRING_PROP, (Object)"hello");
            allPropsRel.setProperty(UTF_8_PROP, (Object)CHINESE);
            allPropsRel.setProperty(POINT_PROP, (Object)POINT_VALUE);
            allPropsRel.setProperty(DATE_PROP, (Object)DATE_VALUE);
            if (PropertyCursorTestBase.supportsBigProperties()) {
                allPropsRel.setProperty(LONG_STRING_PROP, (Object)LONG_STRING);
                allPropsRel.setProperty(SMALL_ARRAY_PROP, (Object)new int[]{1, 2, 3, 4});
                allPropsRel.setProperty(BIG_ARRAY_PROP, (Object)new String[]{LONG_STRING});
            }
            tx.commit();
        }
    }

    private static long createNodeWithProperty(Transaction tx, String propertyKey, Object value) {
        Node p = tx.createNode();
        p.setProperty(propertyKey, value);
        return p.getId();
    }

    private static long createRelWithProperty(Transaction tx, RelationshipType type, String propertyKey, Object value) {
        Relationship r = tx.createNode().createRelationshipTo(tx.createNode(), type);
        r.setProperty(propertyKey, value);
        return r.getId();
    }

    @Test
    void shouldNotAccessNonExistentNodeProperties() {
        try (NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL);
             PropertyCursor props = this.cursors.allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.read.singleNode(bareNodeId, node);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"node by reference");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)PropertyCursorTestBase.hasProperties(node, props), (String)"no properties");
            node.properties(props);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)props.next(), (String)"no properties by direct method");
            this.read.nodeProperties(node.nodeReference(), node.propertiesReference(), PropertySelection.ALL_PROPERTIES, props);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)props.next(), (String)"no properties via property ref");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)node.next(), (String)"only one node");
        }
    }

    @Test
    void shouldNotAccessNonExistentRelationshipProperties() {
        try (RelationshipScanCursor relationship = this.cursors.allocateRelationshipScanCursor(CursorContext.NULL);
             PropertyCursor props = this.cursors.allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.read.singleRelationship(bareRelId, relationship);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)relationship.next(), (String)"relationship by reference");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)PropertyCursorTestBase.hasProperties((RelationshipDataAccessor)relationship, props), (String)"no properties");
            relationship.properties(props);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)props.next(), (String)"no properties by direct method");
            this.read.relationshipProperties(relationship.relationshipReference(), relationship.propertiesReference(), PropertySelection.ALL_PROPERTIES, props);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)props.next(), (String)"no properties via property ref");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)relationship.next(), (String)"only one node");
        }
    }

    @Test
    void shouldAccessSingleNodeProperty() {
        this.assertAccessSingleNodeProperty(bytePropNodeId, Values.of((Object)13), ValueGroup.NUMBER);
        this.assertAccessSingleNodeProperty(shortPropNodeId, Values.of((Object)13), ValueGroup.NUMBER);
        this.assertAccessSingleNodeProperty(intPropNodeId, Values.of((Object)13), ValueGroup.NUMBER);
        this.assertAccessSingleNodeProperty(inlineLongPropNodeId, Values.of((Object)13L), ValueGroup.NUMBER);
        this.assertAccessSingleNodeProperty(longPropNodeId, Values.of((Object)Long.MAX_VALUE), ValueGroup.NUMBER);
        this.assertAccessSingleNodeProperty(floatPropNodeId, Values.of((Object)Float.valueOf(13.0f)), ValueGroup.NUMBER);
        this.assertAccessSingleNodeProperty(doublePropNodeId, Values.of((Object)13.0), ValueGroup.NUMBER);
        this.assertAccessSingleNodeProperty(truePropNodeId, Values.of((Object)true), ValueGroup.BOOLEAN);
        this.assertAccessSingleNodeProperty(falsePropNodeId, Values.of((Object)false), ValueGroup.BOOLEAN);
        this.assertAccessSingleNodeProperty(charPropNodeId, Values.of((Object)Character.valueOf('x')), ValueGroup.TEXT);
        this.assertAccessSingleNodeProperty(emptyStringPropNodeId, Values.of((Object)""), ValueGroup.TEXT);
        this.assertAccessSingleNodeProperty(shortStringPropNodeId, Values.of((Object)"hello"), ValueGroup.TEXT);
        if (PropertyCursorTestBase.supportsBigProperties()) {
            this.assertAccessSingleNodeProperty(longStringPropNodeId, Values.of((Object)LONG_STRING), ValueGroup.TEXT);
        }
        this.assertAccessSingleNodeProperty(utf8PropNodeId, Values.of((Object)CHINESE), ValueGroup.TEXT);
        if (PropertyCursorTestBase.supportsBigProperties()) {
            this.assertAccessSingleNodeProperty(smallArrayNodeId, Values.of((Object)new int[]{1, 2, 3, 4}), ValueGroup.NUMBER_ARRAY);
            this.assertAccessSingleNodeProperty(bigArrayNodeId, Values.of((Object)new String[]{LONG_STRING}), ValueGroup.TEXT_ARRAY);
        }
        this.assertAccessSingleNodeProperty(pointPropNodeId, Values.of((Object)POINT_VALUE), ValueGroup.GEOMETRY);
        this.assertAccessSingleNodeProperty(datePropNodeId, Values.of((Object)DATE_VALUE), ValueGroup.DATE);
    }

    @Test
    void shouldAssertSingleRelationshipProperty() {
        this.assertAccessSingleRelationshipProperty(bytePropRelId, Values.of((Object)13), ValueGroup.NUMBER);
        this.assertAccessSingleRelationshipProperty(shortPropRelId, Values.of((Object)13), ValueGroup.NUMBER);
        this.assertAccessSingleRelationshipProperty(intPropRelId, Values.of((Object)13), ValueGroup.NUMBER);
        this.assertAccessSingleRelationshipProperty(inlineLongPropRelId, Values.of((Object)13L), ValueGroup.NUMBER);
        this.assertAccessSingleRelationshipProperty(longPropRelId, Values.of((Object)Long.MAX_VALUE), ValueGroup.NUMBER);
        this.assertAccessSingleRelationshipProperty(floatPropRelId, Values.of((Object)Float.valueOf(13.0f)), ValueGroup.NUMBER);
        this.assertAccessSingleRelationshipProperty(doublePropRelId, Values.of((Object)13.0), ValueGroup.NUMBER);
        this.assertAccessSingleRelationshipProperty(truePropRelId, Values.of((Object)true), ValueGroup.BOOLEAN);
        this.assertAccessSingleRelationshipProperty(falsePropRelId, Values.of((Object)false), ValueGroup.BOOLEAN);
        this.assertAccessSingleRelationshipProperty(charPropRelId, Values.of((Object)Character.valueOf('x')), ValueGroup.TEXT);
        this.assertAccessSingleRelationshipProperty(emptyStringPropRelId, Values.of((Object)""), ValueGroup.TEXT);
        this.assertAccessSingleRelationshipProperty(shortStringPropRelId, Values.of((Object)"hello"), ValueGroup.TEXT);
        if (PropertyCursorTestBase.supportsBigProperties()) {
            this.assertAccessSingleRelationshipProperty(longStringPropRelId, Values.of((Object)LONG_STRING), ValueGroup.TEXT);
        }
        this.assertAccessSingleRelationshipProperty(utf8PropRelId, Values.of((Object)CHINESE), ValueGroup.TEXT);
        if (PropertyCursorTestBase.supportsBigProperties()) {
            this.assertAccessSingleRelationshipProperty(smallArrayRelId, Values.of((Object)new int[]{1, 2, 3, 4}), ValueGroup.NUMBER_ARRAY);
            this.assertAccessSingleRelationshipProperty(bigArrayRelId, Values.of((Object)new String[]{LONG_STRING}), ValueGroup.TEXT_ARRAY);
        }
        this.assertAccessSingleRelationshipProperty(pointPropRelId, Values.of((Object)POINT_VALUE), ValueGroup.GEOMETRY);
        this.assertAccessSingleRelationshipProperty(datePropRelId, Values.of((Object)DATE_VALUE), ValueGroup.DATE);
    }

    @Test
    void shouldAccessAllNodeProperties() {
        try (NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL);
             PropertyCursor props = this.cursors.allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.read.singleNode(allPropsNodeId, node);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"node by reference");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)PropertyCursorTestBase.hasProperties(node, props), (String)"has properties");
            node.properties(props);
            HashSet<Object> values = new HashSet<Object>();
            while (props.next()) {
                values.add(props.propertyValue().asObject());
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains((byte)13), (String)BYTE_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains((short)13), (String)SHORT_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(13), (String)INT_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(13L), (String)INLINE_LONG_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(Long.MAX_VALUE), (String)LONG_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(Float.valueOf(13.0f)), (String)FLOAT_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(13.0), (String)DOUBLE_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(true), (String)TRUE_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(false), (String)FALSE_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(Character.valueOf('x')), (String)CHAR_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(""), (String)EMPTY_STRING_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains("hello"), (String)SHORT_STRING_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(CHINESE), (String)UTF_8_PROP);
            if (PropertyCursorTestBase.supportsBigProperties()) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(LONG_STRING), (String)LONG_STRING_PROP);
                ((IterableAssert)Assertions.assertThat(values).as(SMALL_ARRAY_PROP, new Object[0])).contains(new Object[]{new int[]{1, 2, 3, 4}});
                ((IterableAssert)Assertions.assertThat(values).as(BIG_ARRAY_PROP, new Object[0])).contains(new Object[]{LONG_STRING});
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(POINT_VALUE), (String)POINT_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(DATE_VALUE.asObject()), (String)DATE_PROP);
            int expected = PropertyCursorTestBase.supportsBigProperties() ? 18 : 15;
            org.junit.jupiter.api.Assertions.assertEquals((int)expected, (int)values.size(), (String)"number of values");
        }
    }

    @Test
    void shouldAccessAllRelationshipProperties() {
        try (RelationshipScanCursor relationship = this.cursors.allocateRelationshipScanCursor(CursorContext.NULL);
             PropertyCursor props = this.cursors.allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.read.singleRelationship(allPropsRelId, relationship);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)relationship.next(), (String)"relationship by reference");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)PropertyCursorTestBase.hasProperties((RelationshipDataAccessor)relationship, props), (String)"has properties");
            relationship.properties(props);
            HashSet<Object> values = new HashSet<Object>();
            while (props.next()) {
                values.add(props.propertyValue().asObject());
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains((byte)13), (String)BYTE_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains((short)13), (String)SHORT_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(13), (String)INT_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(13L), (String)INLINE_LONG_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(Long.MAX_VALUE), (String)LONG_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(Float.valueOf(13.0f)), (String)FLOAT_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(13.0), (String)DOUBLE_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(true), (String)TRUE_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(false), (String)FALSE_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(Character.valueOf('x')), (String)CHAR_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(""), (String)EMPTY_STRING_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains("hello"), (String)SHORT_STRING_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(CHINESE), (String)UTF_8_PROP);
            if (PropertyCursorTestBase.supportsBigProperties()) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(LONG_STRING), (String)LONG_STRING_PROP);
                ((IterableAssert)Assertions.assertThat(values).as(SMALL_ARRAY_PROP, new Object[0])).contains(new Object[]{new int[]{1, 2, 3, 4}});
                ((IterableAssert)Assertions.assertThat(values).as(BIG_ARRAY_PROP, new Object[0])).contains(new Object[]{LONG_STRING});
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(POINT_VALUE), (String)POINT_PROP);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)values.contains(DATE_VALUE.asObject()), (String)DATE_PROP);
            int expected = PropertyCursorTestBase.supportsBigProperties() ? 18 : 15;
            org.junit.jupiter.api.Assertions.assertEquals((int)expected, (int)values.size(), (String)"number of values");
        }
    }

    private void assertAccessSingleNodeProperty(long nodeId, Object expectedValue, ValueGroup expectedValueType) {
        try (NodeCursor node = this.cursors.allocateNodeCursor(CursorContext.NULL);
             PropertyCursor props = this.cursors.allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.read.singleNode(nodeId, node);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)node.next(), (String)"node by reference");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)PropertyCursorTestBase.hasProperties(node, props), (String)"has properties");
            node.properties(props);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)props.next(), (String)"has properties by direct method");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedValue, (Object)props.propertyValue(), (String)"correct value");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedValueType, (Object)props.propertyType(), (String)"correct value type ");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)props.next(), (String)"single property");
            this.read.nodeProperties(node.nodeReference(), node.propertiesReference(), PropertySelection.ALL_PROPERTIES, props);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)props.next(), (String)"has properties via property ref");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedValue, (Object)props.propertyValue(), (String)"correct value");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)props.next(), (String)"single property");
        }
    }

    private void assertAccessSingleRelationshipProperty(long relationshipId, Object expectedValue, ValueGroup expectedValueType) {
        try (RelationshipScanCursor relationship = this.cursors.allocateRelationshipScanCursor(CursorContext.NULL);
             PropertyCursor props = this.cursors.allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            this.read.singleRelationship(relationshipId, relationship);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)relationship.next(), (String)"relationship by reference");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)PropertyCursorTestBase.hasProperties((RelationshipDataAccessor)relationship, props), (String)"has properties");
            relationship.properties(props);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)props.next(), (String)"has properties by direct method");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedValue, (Object)props.propertyValue(), (String)"correct value");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedValueType, (Object)props.propertyType(), (String)"correct value type ");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)props.next(), (String)"single property");
            this.read.relationshipProperties(relationship.relationshipReference(), relationship.propertiesReference(), PropertySelection.ALL_PROPERTIES, props);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)props.next(), (String)"has properties via property ref");
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedValue, (Object)props.propertyValue(), (String)"correct value");
            org.junit.jupiter.api.Assertions.assertFalse((boolean)props.next(), (String)"single property");
        }
    }

    private static boolean hasProperties(NodeCursor node, PropertyCursor props) {
        node.properties(props);
        return props.next();
    }

    private static boolean hasProperties(RelationshipDataAccessor relationship, PropertyCursor props) {
        relationship.properties(props);
        return props.next();
    }

    static {
        POINT_VALUE = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{10.0, 20.0});
        DATE_VALUE = Values.temporalValue((Temporal)LocalDate.of(2018, 7, 26));
    }
}

