/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.io.Serializable;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.EntityCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
public abstract class RelationshipWriteTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    protected static final RelationshipType TYPE = RelationshipType.withName((String)"R");
    @Inject
    private RandomSupport random;

    @Test
    void shouldCreateRelationship() throws Exception {
        long r;
        long n2;
        long n1;
        try (Transaction tx = graphDb.beginTx();){
            n1 = tx.createNode().getId();
            n2 = tx.createNode().getId();
            tx.commit();
        }
        try (KernelTransaction tx = RelationshipWriteTestBase.beginTransaction();){
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            r = tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            List relationships = Iterables.asList((Iterable)tx.getNodeById(n1).getRelationships());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)relationships.size());
            org.junit.jupiter.api.Assertions.assertEquals((long)((Relationship)relationships.get(0)).getId(), (long)r);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldCreateRelationshipBetweenInTransactionNodes() throws Exception {
        long r;
        long n1;
        try (KernelTransaction tx = RelationshipWriteTestBase.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            r = tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.commit();
        }
        tx = graphDb.beginTx();
        try {
            List relationships = Iterables.asList((Iterable)tx.getNodeById(n1).getRelationships());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)relationships.size());
            org.junit.jupiter.api.Assertions.assertEquals((long)((Relationship)relationships.get(0)).getId(), (long)r);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldRollbackRelationshipOnFailure() throws Exception {
        long n2;
        long n1;
        try (Transaction tx = graphDb.beginTx();){
            n1 = tx.createNode().getId();
            n2 = tx.createNode().getId();
            tx.commit();
        }
        tx = RelationshipWriteTestBase.beginTransaction();
        try {
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.rollback();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tx.getNodeById(n1).getDegree());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDeleteRelationship() throws Exception {
        long r;
        long n1;
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            n1 = node1.getId();
            r = node1.createRelationshipTo(node2, TYPE).getId();
            tx.commit();
        }
        tx = RelationshipWriteTestBase.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().relationshipDelete(r), (String)"should delete relationship");
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tx.getNodeById(n1).getDegree());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldNotDeleteRelationshipThatDoesNotExist() throws Exception {
        long relationship = 0L;
        try (KernelTransaction tx = RelationshipWriteTestBase.beginTransaction();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataWrite().relationshipDelete(relationship));
            tx.rollback();
        }
        tx = RelationshipWriteTestBase.beginTransaction();
        try {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)tx.dataWrite().relationshipDelete(relationship));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldDeleteRelationshipAddedInTransaction() throws Exception {
        long n2;
        long n1;
        try (Transaction tx = graphDb.beginTx();){
            n1 = tx.createNode().getId();
            n2 = tx.createNode().getId();
            tx.commit();
        }
        tx = RelationshipWriteTestBase.beginTransaction();
        try {
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            long r = tx.dataWrite().relationshipCreate(n1, label, n2);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)tx.dataWrite().relationshipDelete(r));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = graphDb.beginTx();
        try {
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tx.getNodeById(n1).getDegree());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldAddPropertyToRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            relationshipId = node1.createRelationshipTo(node2, TYPE).getId();
            tx.commit();
        }
        tx = RelationshipWriteTestBase.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"hello"))).isEqualTo((Object)Values.NO_VALUE);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = graphDb.beginTx();){
            Assertions.assertThat((Object)transaction.getRelationshipById(relationshipId).getProperty("prop")).isEqualTo((Object)"hello");
        }
    }

    @Test
    void shouldUpdatePropertyToRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            Relationship r = node1.createRelationshipTo(node2, TYPE);
            r.setProperty(propertyKey, (Object)42);
            relationshipId = r.getId();
            tx.commit();
        }
        tx = RelationshipWriteTestBase.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"hello"))).isEqualTo((Object)Values.intValue((int)42));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = graphDb.beginTx();){
            Assertions.assertThat((Object)transaction.getRelationshipById(relationshipId).getProperty("prop")).isEqualTo((Object)"hello");
        }
    }

    @Test
    void shouldRemovePropertyFromRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            Relationship proxy = node1.createRelationshipTo(node2, TYPE);
            relationshipId = proxy.getId();
            proxy.setProperty(propertyKey, (Object)42);
            tx.commit();
        }
        tx = RelationshipWriteTestBase.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token)).isEqualTo((Object)Values.intValue((int)42));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = graphDb.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)transaction.getRelationshipById(relationshipId).hasProperty("prop"));
        }
    }

    @Test
    void shouldRemoveNonExistingPropertyFromRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            Relationship proxy = node1.createRelationshipTo(node2, TYPE);
            relationshipId = proxy.getId();
            tx.commit();
        }
        tx = RelationshipWriteTestBase.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token)).isEqualTo((Object)Values.NO_VALUE);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = graphDb.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)transaction.getRelationshipById(relationshipId).hasProperty("prop"));
        }
    }

    @Test
    void shouldRemovePropertyFromRelationshipTwice() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            Relationship proxy = node1.createRelationshipTo(node2, TYPE);
            relationshipId = proxy.getId();
            proxy.setProperty(propertyKey, (Object)42);
            tx.commit();
        }
        tx = RelationshipWriteTestBase.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token)).isEqualTo((Object)Values.intValue((int)42));
            Assertions.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token)).isEqualTo((Object)Values.NO_VALUE);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = graphDb.beginTx();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)transaction.getRelationshipById(relationshipId).hasProperty("prop"));
        }
    }

    @Test
    void shouldUpdatePropertyToRelationshipInTransaction() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (Transaction tx = graphDb.beginTx();){
            Node node1 = tx.createNode();
            Node node2 = tx.createNode();
            relationshipId = node1.createRelationshipTo(node2, TYPE).getId();
            tx.commit();
        }
        tx = RelationshipWriteTestBase.beginTransaction();
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            Assertions.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"hello"))).isEqualTo((Object)Values.NO_VALUE);
            Assertions.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"world"))).isEqualTo((Object)Values.stringValue((String)"hello"));
            Assertions.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.intValue((int)1337))).isEqualTo((Object)Values.stringValue((String)"world"));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction transaction = graphDb.beginTx();){
            Assertions.assertThat((Object)transaction.getRelationshipById(relationshipId).getProperty("prop")).isEqualTo((Object)1337);
        }
    }

    @Test
    void shouldNotWriteWhenSettingPropertyToSameValue() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        TextValue theValue = Values.stringValue((String)"The Value");
        try (Transaction ctx = graphDb.beginTx();){
            Node node1 = ctx.createNode();
            Node node2 = ctx.createNode();
            Relationship r = node1.createRelationshipTo(node2, TYPE);
            r.setProperty(propertyKey, theValue.asObject());
            relationshipId = r.getId();
            ctx.commit();
        }
        KernelTransaction tx = RelationshipWriteTestBase.beginTransaction();
        int property = tx.token().propertyKeyGetOrCreateForName(propertyKey);
        Assertions.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, property, (Value)theValue)).isEqualTo((Object)theValue);
        Assertions.assertThat((long)tx.commit()).isEqualTo(0L);
    }

    @Test
    void relationshipApplyChangesShouldAddProperty() throws Exception {
        int key;
        long relationship = RelationshipWriteTestBase.createRelationship(TYPE);
        String keyName = "key";
        IntValue value = Values.intValue((int)123);
        try (KernelTransaction tx = RelationshipWriteTestBase.beginTransaction();){
            key = tx.tokenWrite().propertyKeyCreateForName(keyName, false);
            tx.dataWrite().relationshipApplyChanges(relationship, (IntObjectMap)IntObjectMaps.immutable.of(key, (Object)value));
            tx.commit();
        }
        RelationshipWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)arg_0 -> this.lambda$relationshipApplyChangesShouldAddProperty$0(relationship, key, (Value)value, arg_0)));
    }

    @Test
    void relationshipApplyChangesShouldChangeProperty() throws Exception {
        int key;
        String keyName = "key";
        TextValue changedValue = Values.stringValue((String)"value");
        long relationship = RelationshipWriteTestBase.createRelationshipWithProperty(TYPE, keyName, 123);
        try (KernelTransaction tx = RelationshipWriteTestBase.beginTransaction();){
            key = tx.tokenRead().propertyKey(keyName);
            tx.dataWrite().relationshipApplyChanges(relationship, (IntObjectMap)IntObjectMaps.immutable.of(key, (Object)changedValue));
            tx.commit();
        }
        RelationshipWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)arg_0 -> this.lambda$relationshipApplyChangesShouldChangeProperty$1(relationship, key, (Value)changedValue, arg_0)));
    }

    @Test
    void relationshipApplyChangesShouldRemoveProperty() throws Exception {
        String keyName = "key";
        long relationship = RelationshipWriteTestBase.createRelationshipWithProperty(TYPE, keyName, 123);
        try (KernelTransaction tx = RelationshipWriteTestBase.beginTransaction();){
            int key = tx.tokenRead().propertyKey(keyName);
            tx.dataWrite().relationshipApplyChanges(relationship, (IntObjectMap)IntObjectMaps.immutable.of(key, (Object)Values.NO_VALUE));
            tx.commit();
        }
        RelationshipWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (RelationshipScanCursor relationshipCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocateRelationshipScanCursor(CursorContext.NULL);
                 PropertyCursor propertyCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                ktx.dataRead().singleRelationship(relationship, relationshipCursor);
                relationshipCursor.next();
                this.assertProperties((EntityCursor)relationshipCursor, propertyCursor, (IntObjectMap<Value>)IntObjectMaps.immutable.empty());
            }
        }));
    }

    @Test
    void relationshipApplyChangesShouldSetAndRemoveMultipleProperties() throws Exception {
        long relationship;
        int[] keys = new int[10];
        MutableIntObjectMap initialProperties = IntObjectMaps.mutable.empty();
        try (KernelTransaction tx = RelationshipWriteTestBase.beginTransaction();){
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = tx.tokenWrite().propertyKeyGetOrCreateForName("key" + i);
            }
            long sourceNode = tx.dataWrite().nodeCreate();
            long targetNode = tx.dataWrite().nodeCreate();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName(TYPE.name());
            relationship = tx.dataWrite().relationshipCreate(sourceNode, type, targetNode);
            for (int key2 : this.random.selection(keys, 0, keys.length, false)) {
                Value value2 = this.random.nextValue();
                initialProperties.put(key2, (Object)value2);
                tx.dataWrite().relationshipSetProperty(relationship, key2, value2);
            }
            tx.commit();
        }
        MutableIntObjectMap propertyChanges = IntObjectMaps.mutable.empty();
        for (int key3 : this.random.selection(keys, 1, keys.length, false)) {
            propertyChanges.put(key3, (Object)this.random.nextValue());
        }
        for (int key3 : this.random.selection(keys, 1, keys.length, false)) {
            propertyChanges.put(key3, (Object)Values.NO_VALUE);
        }
        try (KernelTransaction tx = RelationshipWriteTestBase.beginTransaction();){
            tx.dataWrite().relationshipApplyChanges(relationship, (IntObjectMap)propertyChanges);
            tx.commit();
        }
        MutableIntObjectMap expectedProperties = IntObjectMaps.mutable.empty();
        expectedProperties.putAll((IntObjectMap)initialProperties);
        propertyChanges.forEachKeyValue((IntObjectProcedure & Serializable)(key, value) -> {
            if (value == Values.NO_VALUE) {
                expectedProperties.remove(key);
            } else {
                expectedProperties.put(key, value);
            }
        });
        RelationshipWriteTestBase.transaction((ThrowingConsumer<KernelTransaction, Exception>)((ThrowingConsumer)ktx -> {
            try (RelationshipScanCursor relationshipCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocateRelationshipScanCursor(CursorContext.NULL);
                 PropertyCursor propertyCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                ktx.dataRead().singleRelationship(relationship, relationshipCursor);
                Assertions.assertThat((boolean)relationshipCursor.next()).isTrue();
                this.assertProperties((EntityCursor)relationshipCursor, propertyCursor, (IntObjectMap<Value>)expectedProperties);
            }
        }));
    }

    private static long createRelationship(RelationshipType type) {
        try (Transaction ctx = graphDb.beginTx();){
            long relationship = ctx.createNode().createRelationshipTo(ctx.createNode(), type).getId();
            ctx.commit();
            long l = relationship;
            return l;
        }
    }

    private static long createRelationshipWithProperty(RelationshipType type, String key, Object value) {
        try (Transaction ctx = graphDb.beginTx();){
            Relationship relationship = ctx.createNode().createRelationshipTo(ctx.createNode(), type);
            relationship.setProperty(key, value);
            ctx.commit();
            long l = relationship.getId();
            return l;
        }
    }

    private /* synthetic */ void lambda$relationshipApplyChangesShouldChangeProperty$1(long relationship, int key, Value changedValue, KernelTransaction ktx) throws Exception {
        try (RelationshipScanCursor relationshipCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocateRelationshipScanCursor(CursorContext.NULL);
             PropertyCursor propertyCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            ktx.dataRead().singleRelationship(relationship, relationshipCursor);
            relationshipCursor.next();
            this.assertProperties((EntityCursor)relationshipCursor, propertyCursor, (IntObjectMap<Value>)IntObjectMaps.immutable.of(key, (Object)changedValue));
        }
    }

    private /* synthetic */ void lambda$relationshipApplyChangesShouldAddProperty$0(long relationship, int key, Value value, KernelTransaction ktx) throws Exception {
        try (RelationshipScanCursor relationshipCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocateRelationshipScanCursor(CursorContext.NULL);
             PropertyCursor propertyCursor = RelationshipWriteTestBase.cursorFactory(ktx).allocatePropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            ktx.dataRead().singleRelationship(relationship, relationshipCursor);
            relationshipCursor.next();
            this.assertProperties((EntityCursor)relationshipCursor, propertyCursor, (IntObjectMap<Value>)IntObjectMaps.immutable.of(key, (Object)value));
        }
    }
}

