/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.List;
import java.util.Objects;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.kernel.impl.newapi.PartitionedScanTestSuite;

public abstract class TokenIndexScanPartitionedScanTestSuite<CURSER extends Cursor>
implements PartitionedScanTestSuite.TestSuite<TokenScanQuery, TokenReadSession, CURSER> {

    protected static final class TokenScanQuery
    implements PartitionedScanTestSuite.Query<TokenPredicate> {
        private final String name;
        private final TokenPredicate predicate;

        public TokenScanQuery(String name, TokenPredicate predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        @Override
        public String indexName() {
            return this.name;
        }

        @Override
        public TokenPredicate get() {
            return this.predicate;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TokenScanQuery that = (TokenScanQuery)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.predicate.tokenId(), that.predicate.tokenId());
        }

        public int hashCode() {
            return Objects.hash(this.name, this.predicate.tokenId());
        }

        public String toString() {
            return String.format("%s[index='%s', pred='%s']", this.getClass().getSimpleName(), this.name, this.predicate.tokenId());
        }
    }

    static abstract class WithData<CURSER extends Cursor>
    extends PartitionedScanTestSuite.WithData<TokenScanQuery, TokenReadSession, CURSER> {
        WithData(TokenIndexScanPartitionedScanTestSuite<CURSER> testSuite) {
            super(testSuite);
        }

        abstract PartitionedScanTestSuite.Queries<TokenScanQuery> createData(int var1, List<Integer> var2);
    }

    static abstract class WithoutData<CURSER extends Cursor>
    extends PartitionedScanTestSuite.WithoutData<TokenScanQuery, TokenReadSession, CURSER> {
        WithoutData(TokenIndexScanPartitionedScanTestSuite<CURSER> testSuite) {
            super(testSuite);
        }

        PartitionedScanTestSuite.Queries<TokenScanQuery> emptyQueries(EntityType entityType, List<Integer> tokenIds) {
            String tokenIndexName = this.getTokenIndexName(entityType);
            PartitionedScanTestSuite.EntityIdsMatchingQuery empty = tokenIds.stream().map(TokenPredicate::new).map(pred -> new TokenScanQuery(tokenIndexName, (TokenPredicate)pred)).collect(PartitionedScanTestSuite.EntityIdsMatchingQuery.collector());
            return new PartitionedScanTestSuite.Queries<TokenScanQuery>(empty);
        }
    }
}

