/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.EphemeralNeo4jLayoutExtension;
import org.neo4j.test.extension.Inject;

@EphemeralNeo4jLayoutExtension
class CheckPointerIntegrationTest {
    @Inject
    private EphemeralFileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    private DatabaseManagementServiceBuilder builder;

    CheckPointerIntegrationTest() {
    }

    @BeforeEach
    void setup() {
        this.builder = new TestDatabaseManagementServiceBuilder(this.databaseLayout).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction((FileSystemAbstraction)this.fs)).impermanent();
    }

    @Test
    void databaseShutdownDuringConstantCheckPointing() throws InterruptedException {
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(0L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)1).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        Thread.sleep(10L);
        managementService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldCheckPointBasedOnTime() throws Throwable {
        long millis = 200L;
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(millis)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)10000).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        GraphDatabaseService db = managementService.database("neo4j");
        try (Transaction tx = db.beginTx();){
            tx.createNode();
            tx.commit();
        }
        long endTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        while (CheckPointerIntegrationTest.checkPointInTxLog(db).isEmpty()) {
            Thread.sleep(millis);
            org.junit.jupiter.api.Assertions.assertTrue((System.currentTimeMillis() < endTime ? 1 : 0) != 0, (String)"Took too long to produce a checkpoint");
        }
        managementService.shutdown();
        managementService = this.builder.build();
        try {
            List<CheckpointInfo> checkPoints = CheckPointerIntegrationTest.checkPointsInTxLog(managementService.database("neo4j"));
            org.junit.jupiter.api.Assertions.assertTrue((checkPoints.size() >= 2 ? 1 : 0) != 0, (String)("Expected at least two (at least one for time interval and one for shutdown), was " + checkPoints.toString()));
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldCheckPointBasedOnTxCount() throws Throwable {
        int counter;
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(300L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)1).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        try {
            GraphDatabaseService db = managementService.database("neo4j");
            try (Transaction tx = db.beginTx();){
                tx.createNode();
                tx.commit();
            }
            CheckPointerIntegrationTest.triggerCheckPointAttempt(db);
            List<CheckpointInfo> checkpoints = CheckPointerIntegrationTest.checkPointsInTxLog(db);
            Assertions.assertThat(checkpoints).isNotEmpty();
            counter = checkpoints.size();
        }
        finally {
            managementService.shutdown();
        }
        managementService = this.builder.build();
        try {
            List<CheckpointInfo> checkpointInfos = CheckPointerIntegrationTest.checkPointsInTxLog(managementService.database("neo4j"));
            Assertions.assertThat((int)checkpointInfos.size()).isGreaterThanOrEqualTo(counter + 1);
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldNotCheckPointWhenThereAreNoCommits() throws Throwable {
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofSeconds(1L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)10000).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        GraphDatabaseService db = managementService.database("neo4j");
        GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)managementService.database("neo4j");
        CheckPointerIntegrationTest.getCheckPointer(databaseAPI).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("given"));
        int checkPointsBefore = CheckPointerIntegrationTest.checkPointInTxLog(db).size();
        CheckPointerIntegrationTest.triggerCheckPointAttempt(db);
        Assertions.assertThat(CheckPointerIntegrationTest.checkPointInTxLog(db)).hasSize(checkPointsBefore);
        managementService.shutdown();
        managementService = this.builder.build();
        try {
            List<CheckpointInfo> checkPoints = CheckPointerIntegrationTest.checkPointsInTxLog(managementService.database("neo4j"));
            org.junit.jupiter.api.Assertions.assertEquals((int)(checkPointsBefore + 1), (int)checkPoints.size());
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldBeAbleToStartAndShutdownMultipleTimesTheDBWithoutCommittingTransactions() throws Throwable {
        DatabaseManagementServiceBuilder databaseManagementServiceBuilder = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMinutes(300L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)10000).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L));
        DatabaseManagementService managementService = databaseManagementServiceBuilder.build();
        managementService.shutdown();
        managementService = databaseManagementServiceBuilder.build();
        managementService.shutdown();
        managementService = this.builder.build();
        try {
            List<CheckpointInfo> checkpoints = CheckPointerIntegrationTest.checkPointsInTxLog(managementService.database("neo4j"));
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)checkpoints.size());
        }
        finally {
            managementService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void tracePageCacheAccessOnCheckpoint() throws Exception {
        DatabaseManagementService managementService = this.builder.setConfig(GraphDatabaseSettings.check_point_interval_time, (Object)Duration.ofMillis(0L)).setConfig(GraphDatabaseSettings.check_point_interval_tx, (Object)1).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)ByteUnit.gibiBytes((long)1L)).build();
        try {
            GraphDatabaseAPI databaseAPI = (GraphDatabaseAPI)managementService.database("neo4j");
            PageCacheTracer cacheTracer = (PageCacheTracer)databaseAPI.getDependencyResolver().resolveDependency(PageCacheTracer.class);
            long initialFlushes = cacheTracer.flushes();
            long initialBytesWritten = cacheTracer.bytesWritten();
            long initialPins = cacheTracer.pins();
            CheckPointerIntegrationTest.getCheckPointer(databaseAPI).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("tracing"));
            Assertions.assertThat((long)cacheTracer.flushes()).isGreaterThan(initialFlushes);
            Assertions.assertThat((long)cacheTracer.bytesWritten()).isGreaterThan(initialBytesWritten);
            Assertions.assertThat((long)cacheTracer.pins()).isGreaterThan(initialPins);
        }
        finally {
            managementService.shutdown();
        }
    }

    private static void triggerCheckPointAttempt(GraphDatabaseService db) throws Exception {
        CheckPointerIntegrationTest.getCheckPointer((GraphDatabaseAPI)db).checkPointIfNeeded((TriggerInfo)new SimpleTriggerInfo("Test"));
    }

    private static CheckPointer getCheckPointer(GraphDatabaseAPI db) {
        return (CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class);
    }

    private static List<CheckpointInfo> checkPointInTxLog(GraphDatabaseService db) throws IOException {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)db).getDependencyResolver();
        LogFiles logFiles = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        return logFiles.getCheckpointFile().reachableCheckpoints();
    }

    private static List<CheckpointInfo> checkPointsInTxLog(GraphDatabaseService db) throws IOException {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)db).getDependencyResolver();
        LogFiles logFiles = (LogFiles)dependencyResolver.resolveDependency(LogFiles.class);
        return logFiles.getCheckpointFile().reachableCheckpoints();
    }
}

