/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.TestTokenScanConsumer;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.LockService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class FullScanStoreViewTracingIT {
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private LockService lockService;
    @Inject
    private StorageEngine storageEngine;
    @Inject
    private JobScheduler jobScheduler;

    FullScanStoreViewTracingIT() {
    }

    @Test
    void tracePageCacheAccess() {
        int nodeCount = 1000;
        Label label = Label.label((String)"marker");
        try (Transaction tx = this.database.beginTx();){
            for (int i = 0; i < nodeCount; ++i) {
                Node node = tx.createNode(new Label[]{label});
                node.setProperty("a", (Object)RandomStringUtils.randomAscii((int)10));
            }
            tx.commit();
        }
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        FullScanStoreView indexStoreView = new FullScanStoreView(this.lockService, () -> ((StorageEngine)this.storageEngine).newReader(), arg_0 -> ((StorageEngine)this.storageEngine).createStorageCursors(arg_0), Config.defaults(), this.jobScheduler);
        StoreScan storeScan = indexStoreView.visitNodes(ArrayUtils.EMPTY_INT_ARRAY, Predicates.ALWAYS_TRUE_INT, null, (TokenScanConsumer)new TestTokenScanConsumer(), true, true, (PageCacheTracer)pageCacheTracer, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        Assertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(103L);
        Assertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(103L);
        Assertions.assertThat((long)pageCacheTracer.hits()).isEqualTo(103L);
    }
}

