/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.lifecycle;

import java.io.IOException;
import java.util.Collections;
import org.junit.jupiter.api.Test;
import org.neo4j.batchinsert.BatchInserter;
import org.neo4j.batchinsert.BatchInserters;
import org.neo4j.graphdb.Label;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class GitHub1304Test {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private DatabaseLayout databaseLayout;

    GitHub1304Test() {
    }

    @Test
    void givenBatchInserterWhenArrayPropertyUpdated4TimesThenShouldNotFail() throws IOException {
        BatchInserter batchInserter = BatchInserters.inserter((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem);
        long nodeId = batchInserter.createNode(Collections.emptyMap(), new Label[0]);
        for (int i = 0; i < 4; ++i) {
            batchInserter.setNodeProperty(nodeId, "array", (Object)new byte[]{2, 3, 98, 1, 43, 50, 3, 33, 51, 55, 116, 16, 23, 56, 9, -10, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1});
        }
        batchInserter.getNodeProperties(nodeId);
        batchInserter.shutdown();
    }
}

