/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.TestData;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

public class TestGraphDescription
implements GraphHolder {
    private static GraphDatabaseService graphdb;
    @RegisterExtension
    public TestData<Map<String, Node>> data = TestData.producedThrough((TestData.Producer)GraphDescription.createGraphFor((GraphHolder)this));
    private static DatabaseManagementService managementService;

    @Test
    public void havingNoGraphAnnotationCreatesAnEmptyDataCollection() {
        Assertions.assertTrue((boolean)((Map)this.data.get()).isEmpty(), (String)"collection was not empty");
    }

    @Test
    @GraphDescription.Graph(value={"I know you"})
    public void canCreateGraphFromSingleString() {
        this.verifyIKnowYou("know", "I");
    }

    @Test
    @GraphDescription.Graph(value={"a TO b", "b TO c", "c TO a"})
    public void canCreateGraphFromMultipleStrings() {
        Map graph = (Map)this.data.get();
        HashSet<Node> unique = new HashSet<Node>();
        Node n = (Node)graph.get("a");
        while (unique.add(n)) {
            Transaction tx = graphdb.beginTx();
            try {
                n = tx.getNodeById(n.getId()).getSingleRelationship(RelationshipType.withName((String)"TO"), Direction.OUTGOING).getEndNode();
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        Assertions.assertEquals((int)graph.size(), (int)unique.size());
    }

    @Test
    @GraphDescription.Graph(value={"a:Person EATS b:Banana"})
    public void ensurePeopleCanEatBananas() {
        Map graph = (Map)this.data.get();
        Node a = (Node)graph.get("a");
        Node b = (Node)graph.get("b");
        try (Transaction tx = graphdb.beginTx();){
            Assertions.assertTrue((boolean)tx.getNodeById(a.getId()).hasLabel(Label.label((String)"Person")));
            Assertions.assertTrue((boolean)tx.getNodeById(b.getId()).hasLabel(Label.label((String)"Banana")));
        }
    }

    @Test
    @GraphDescription.Graph(value={"a:Person EATS b:Banana", "a EATS b:Apple"})
    public void ensurePeopleCanEatBananasAndApples() {
        Map graph = (Map)this.data.get();
        Node a = (Node)graph.get("a");
        Node b = (Node)graph.get("b");
        try (Transaction tx = graphdb.beginTx();){
            Assertions.assertTrue((boolean)tx.getNodeById(a.getId()).hasLabel(Label.label((String)"Person")), (String)"Person label missing");
            Assertions.assertTrue((boolean)tx.getNodeById(b.getId()).hasLabel(Label.label((String)"Banana")), (String)"Banana label missing");
            Assertions.assertTrue((boolean)tx.getNodeById(b.getId()).hasLabel(Label.label((String)"Apple")), (String)"Apple label missing");
        }
    }

    @GraphDescription.Graph(value={"I know you"}, nodes={@GraphDescription.NODE(name="I", properties={@GraphDescription.PROP(key="name", value="me")})})
    private void verifyIKnowYou(String type, String myName) {
        Map graph = (Map)this.data.get();
        try (Transaction tx = graphdb.beginTx();){
            Assertions.assertEquals((int)2, (int)graph.size(), (String)"Wrong graph size.");
            Node iNode = tx.getNodeById(((Node)graph.get("I")).getId());
            Assertions.assertNotNull((Object)iNode, (String)"The node 'I' was not defined");
            Node you = tx.getNodeById(((Node)graph.get("you")).getId());
            Assertions.assertNotNull((Object)you, (String)"The node 'you' was not defined");
            Assertions.assertEquals((Object)myName, (Object)iNode.getProperty("name"), (String)"'I' has wrong 'name'.");
            Assertions.assertEquals((Object)"you", (Object)you.getProperty("name"), (String)"'you' has wrong 'name'.");
            Iterator rels = iNode.getRelationships().iterator();
            Assertions.assertTrue((boolean)rels.hasNext(), (String)"'I' has too few relationships");
            Relationship rel = (Relationship)rels.next();
            Assertions.assertEquals((Object)you, (Object)rel.getOtherNode(iNode), (String)"'I' is not related to 'you'");
            Assertions.assertEquals((Object)type, (Object)rel.getType().name(), (String)"Wrong relationship type.");
            Assertions.assertFalse((boolean)rels.hasNext(), (String)"'I' has too many relationships");
            rels = you.getRelationships().iterator();
            Assertions.assertTrue((boolean)rels.hasNext(), (String)"'you' has too few relationships");
            rel = (Relationship)rels.next();
            Assertions.assertEquals((Object)iNode, (Object)rel.getOtherNode(you), (String)"'you' is not related to 'i'");
            Assertions.assertEquals((Object)type, (Object)rel.getType().name(), (String)"Wrong relationship type.");
            Assertions.assertFalse((boolean)rels.hasNext(), (String)"'you' has too many relationships");
            Assertions.assertEquals((Object)iNode, (Object)rel.getStartNode(), (String)"wrong direction");
        }
    }

    @BeforeAll
    public static void startDatabase() {
        managementService = new TestDatabaseManagementServiceBuilder().impermanent().build();
        graphdb = managementService.database("neo4j");
    }

    @AfterAll
    public static void stopDatabase() {
        if (graphdb != null) {
            managementService.shutdown();
        }
        graphdb = null;
    }

    public GraphDatabaseService graphdb() {
        return graphdb;
    }
}

