/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.function.Consumers;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.impl.transaction.log.entry.IncompleteLogHeaderException;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
public class StartOnEmptyTransactionLogIT {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private Neo4jLayout neo4jLayout;
    private DatabaseManagementServiceBuilder builder;
    private LogFiles logFiles;
    private DatabaseManagementService dbms;

    @BeforeEach
    void setup() throws IOException {
        this.builder = new TestDatabaseManagementServiceBuilder(this.neo4jLayout);
        DatabaseManagementService dbms = this.builder.build();
        dbms.shutdown();
        DatabaseLayout system = this.neo4jLayout.databaseLayout("system");
        this.logFiles = this.buildLogFiles(system);
        this.truncate(this.logFiles.getCheckpointFile().getCurrentFile(), 64);
        this.truncate(this.logFiles.getLogFile().getHighestLogFile(), 0);
        Assertions.assertThat((long)this.getTxLogFileSize()).isEqualTo(0L);
    }

    @AfterEach
    void tearDown() {
        if (this.dbms != null) {
            this.dbms.shutdown();
        }
    }

    @Test
    void shouldNotStartOnEmptyTransactionLogs() {
        RuntimeException exception = (RuntimeException)org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> this.dbms(Consumers.ignoreValue()));
        Assertions.assertThat((Throwable)exception).getRootCause().isInstanceOf(IncompleteLogHeaderException.class);
    }

    @Test
    void shouldStartOnEmptyTransactionWhenConfiguredToNotFailOnCorruptedLogFiles() throws IOException {
        this.dbms = this.dbms(builder -> builder.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false));
        Assertions.assertThat((long)this.getTxLogFileSize()).isGreaterThan(0L);
        GraphDatabaseService systemDb = this.dbms.database("system");
        Assertions.assertThatNoException().isThrownBy(() -> {
            try (Transaction tx = systemDb.beginTx();){
                tx.createNode();
                tx.commit();
            }
        });
    }

    @EnabledOnOs(value={OS.LINUX})
    @Test
    void shouldPreAllocateOnExistingButEmptyTxLogFile() throws IOException {
        long preAllocationSize = ByteUnit.kibiBytes((long)128L);
        this.dbms = this.dbms(builder -> builder.setConfig(GraphDatabaseInternalSettings.fail_on_corrupted_log_files, (Object)false).setConfig(GraphDatabaseSettings.logical_log_rotation_threshold, (Object)preAllocationSize));
        Assertions.assertThat((long)this.getTxLogFileSize()).isEqualTo(preAllocationSize);
    }

    private DatabaseManagementService dbms(Consumer<DatabaseManagementServiceBuilder> configuration) {
        configuration.accept(this.builder);
        this.dbms = this.builder.build();
        return this.dbms;
    }

    private void truncate(Path file, int size) throws IOException {
        try (StoreChannel storeChannel = this.fs.write(file);){
            storeChannel.truncate((long)size);
        }
    }

    private LogFiles buildLogFiles(DatabaseLayout databaseLayout) throws IOException {
        return LogFilesBuilder.logFilesBasedOnlyBuilder((Path)databaseLayout.getTransactionLogsDirectory(), (FileSystemAbstraction)this.fs).build();
    }

    private long getTxLogFileSize() throws IOException {
        return this.fs.getFileSize(this.logFiles.getLogFile().getHighestLogFile());
    }
}

