/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;

public class IndexingTestUtil {
    public static void assertOnlyDefaultTokenIndexesExists(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Assertions.assertThat((long)StreamSupport.stream(tx.schema().getIndexes().spliterator(), false).count()).isEqualTo(2L);
            IndexingTestUtil.assertDefaultTokenIndexesExists(db);
        }
    }

    public static void assertDefaultTokenIndexesExists(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            List lookupIndexes = StreamSupport.stream(tx.schema().getIndexes().spliterator(), false).filter(idx -> idx.getIndexType() == IndexType.LOOKUP).collect(Collectors.toList());
            Assertions.assertThat((boolean)lookupIndexes.stream().anyMatch(IndexDefinition::isNodeIndex)).isTrue();
            Assertions.assertThat((boolean)lookupIndexes.stream().anyMatch(IndexDefinition::isRelationshipIndex)).isTrue();
        }
    }

    public static void dropAllIndexes(GraphDatabaseService db) {
        IndexingTestUtil.dropIndexes(db, Predicates.alwaysTrue());
    }

    public static void dropTokenIndexes(GraphDatabaseService db) {
        IndexingTestUtil.dropIndexes(db, index -> index.isRelationshipIndex() || index.isNodeIndex());
    }

    private static void dropIndexes(GraphDatabaseService db, Predicate<IndexDefinition> condition) {
        try (Transaction tx = db.beginTx();){
            tx.schema().getIndexes().forEach(index -> {
                if (condition.test((IndexDefinition)index)) {
                    index.drop();
                }
            });
            tx.commit();
        }
    }
}

