/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.collector.Collectors2;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.WriteTestSupport;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class IndexTransactionStateTestBase
extends KernelAPIWriteTestBase<WriteTestSupport> {
    static final String INDEX_NAME = "myIndex";
    static final String DEFAULT_PROPERTY_NAME = "prop";

    IndexTransactionStateTestBase() {
    }

    @ParameterizedTest
    @MethodSource(value={"parametersForSuffixAndContains"})
    void shouldPerformStringSuffixSearch(IndexType indexType, boolean needsValues) throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexTransactionStateTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, "1suff"));
            this.entityWithProp(tx, "pluff");
            tx.commit();
        }
        this.createIndex(indexType);
        tx = IndexTransactionStateTestBase.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            expected.add(this.entityWithProp(tx, "2suff"));
            this.entityWithPropId(tx, "skruff");
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            this.assertEntityAndValueForSeek(expected, tx, index, needsValues, "pasuff", new PropertyIndexQuery[]{PropertyIndexQuery.stringSuffix((int)prop, (TextValue)Values.stringValue((String)"suff"))});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldPerformScan(IndexType indexType, boolean needsValues) throws Exception {
        long entityToChange;
        long entityToDelete;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexTransactionStateTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, "suff1"));
            expected.add(this.entityWithProp(tx, "supp"));
            entityToDelete = this.entityWithPropId(tx, "supp");
            entityToChange = this.entityWithPropId(tx, "supper");
            tx.commit();
        }
        this.createIndex(indexType);
        tx = IndexTransactionStateTestBase.beginTransaction();
        try {
            expected.add(this.entityWithProp(tx, "suff2"));
            this.deleteEntity(tx, entityToDelete);
            this.removeProperty(tx, entityToChange);
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            this.assertEntityAndValueForScan(expected, tx, index, needsValues, "noff");
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, names={"BTREE", "RANGE", "TEXT"})
    void shouldPerformEqualitySeek(IndexType indexType) throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexTransactionStateTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, "banana"));
            this.entityWithProp(tx, "apple");
            tx.commit();
        }
        this.createIndex(indexType);
        tx = IndexTransactionStateTestBase.beginTransaction();
        try {
            expected.add(this.entityWithProp(tx, "banana"));
            this.entityWithProp(tx, "dragonfruit");
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            this.assertEntityAndValueForSeek(expected, tx, index, false, "banana", new PropertyIndexQuery[]{PropertyIndexQuery.exact((int)prop, (Object)"banana")});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldPerformStringPrefixSearch(IndexType indexType, boolean needsValues) throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexTransactionStateTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, "suff1"));
            this.entityWithPropId(tx, "supp");
            tx.commit();
        }
        this.createIndex(indexType);
        tx = IndexTransactionStateTestBase.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            expected.add(this.entityWithProp(tx, "suff2"));
            this.entityWithPropId(tx, "skruff");
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            this.assertEntityAndValueForSeek(expected, tx, index, needsValues, "suffpa", new PropertyIndexQuery[]{PropertyIndexQuery.stringPrefix((int)prop, (TextValue)Values.stringValue((String)"suff"))});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldPerformStringRangeSearch(IndexType indexType, boolean needsValues) throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexTransactionStateTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, "banana"));
            this.entityWithProp(tx, "apple");
            tx.commit();
        }
        this.createIndex(indexType);
        tx = IndexTransactionStateTestBase.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            expected.add(this.entityWithProp(tx, "cherry"));
            this.entityWithProp(tx, "dragonfruit");
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            this.assertEntityAndValueForSeek(expected, tx, index, needsValues, "berry", new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldPerformStringRangeSearchWithAddedEntityInTxState(IndexType indexType, boolean needsValues) throws Exception {
        long entityToChange;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexTransactionStateTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, "banana"));
            entityToChange = this.entityWithPropId(tx, "apple");
            tx.commit();
        }
        this.createIndex(indexType);
        tx = IndexTransactionStateTestBase.beginTransaction();
        try {
            expected.add(this.entityWithProp(tx, "cherry"));
            this.entityWithProp(tx, "dragonfruit");
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            TextValue newProperty = Values.stringValue((String)"blueberry");
            this.setProperty(tx, entityToChange, (Value)newProperty);
            expected.add(Pair.of((Object)entityToChange, (Object)newProperty));
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            this.assertEntityAndValueForSeek(expected, tx, index, needsValues, "berry", new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldPerformStringRangeSearchWithChangedEntityInTxState(IndexType indexType, boolean needsValues) throws Exception {
        long entityToChange;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexTransactionStateTestBase.beginTransaction();){
            entityToChange = this.entityWithPropId(tx, "banana");
            this.entityWithPropId(tx, "apple");
            tx.commit();
        }
        this.createIndex(indexType);
        tx = IndexTransactionStateTestBase.beginTransaction();
        try {
            expected.add(this.entityWithProp(tx, "cherry"));
            this.entityWithProp(tx, "dragonfruit");
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            TextValue newProperty = Values.stringValue((String)"kiwi");
            this.setProperty(tx, entityToChange, (Value)newProperty);
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            this.assertEntityAndValueForSeek(expected, tx, index, needsValues, "berry", new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldPerformStringRangeSearchWithRemovedRemovedPropertyInTxState(IndexType indexType, boolean needsValues) throws Exception {
        long entityToChange;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexTransactionStateTestBase.beginTransaction();){
            entityToChange = this.entityWithPropId(tx, "banana");
            this.entityWithPropId(tx, "apple");
            tx.commit();
        }
        this.createIndex(indexType);
        tx = IndexTransactionStateTestBase.beginTransaction();
        try {
            expected.add(this.entityWithProp(tx, "cherry"));
            this.entityWithProp(tx, "dragonfruit");
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            this.removeProperty(tx, entityToChange);
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            this.assertEntityAndValueForSeek(expected, tx, index, needsValues, "berry", new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void shouldPerformStringRangeSearchWithDeletedEntityInTxState(IndexType indexType, boolean needsValues) throws Exception {
        long entityToChange;
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexTransactionStateTestBase.beginTransaction();){
            entityToChange = this.entityWithPropId(tx, "banana");
            this.entityWithPropId(tx, "apple");
            tx.commit();
        }
        this.createIndex(indexType);
        tx = IndexTransactionStateTestBase.beginTransaction();
        try {
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            expected.add(this.entityWithProp(tx, "cherry"));
            this.entityWithProp(tx, "dragonfruit");
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            this.deleteEntity(tx, entityToChange);
            this.assertEntityAndValueForSeek(expected, tx, index, needsValues, "berry", new PropertyIndexQuery[]{PropertyIndexQuery.range((int)prop, (String)"b", (boolean)true, (String)"d", (boolean)false)});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"parametersForSuffixAndContains"})
    void shouldPerformStringContainsSearch(IndexType indexType, boolean needsValues) throws Exception {
        HashSet<Pair<Long, Value>> expected = new HashSet<Pair<Long, Value>>();
        try (KernelTransaction tx = IndexTransactionStateTestBase.beginTransaction();){
            expected.add(this.entityWithProp(tx, "gnomebat"));
            this.entityWithPropId(tx, "fishwombat");
            tx.commit();
        }
        this.createIndex(indexType);
        tx = IndexTransactionStateTestBase.beginTransaction();
        try {
            expected.add(this.entityWithProp(tx, "homeopatic"));
            this.entityWithPropId(tx, "telephonecompany");
            IndexDescriptor index = tx.schemaRead().indexGetForName(INDEX_NAME);
            int prop = tx.tokenRead().propertyKey(DEFAULT_PROPERTY_NAME);
            this.assertEntityAndValueForSeek(expected, tx, index, needsValues, "immense", new PropertyIndexQuery[]{PropertyIndexQuery.stringContains((int)prop, (TextValue)Values.stringValue((String)"me"))});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldThrowIfTransactionTerminated() throws Exception {
        try (KernelTransaction tx = IndexTransactionStateTestBase.beginTransaction();){
            IndexTransactionStateTestBase.terminate(tx);
            org.junit.jupiter.api.Assertions.assertThrows(TransactionTerminatedException.class, () -> this.entityExists(tx, 42L));
        }
    }

    @Override
    public WriteTestSupport newTestSupport() {
        return new WriteTestSupport();
    }

    private static Stream<Arguments> parameters() {
        return Stream.of(Arguments.of((Object[])new Object[]{IndexType.BTREE, true}), Arguments.of((Object[])new Object[]{IndexType.BTREE, false}), Arguments.of((Object[])new Object[]{IndexType.RANGE, true}), Arguments.of((Object[])new Object[]{IndexType.RANGE, false}), Arguments.of((Object[])new Object[]{IndexType.TEXT, false}));
    }

    private static Stream<Arguments> parametersForSuffixAndContains() {
        return Stream.of(Arguments.of((Object[])new Object[]{IndexType.BTREE, true}), Arguments.of((Object[])new Object[]{IndexType.BTREE, false}), Arguments.of((Object[])new Object[]{IndexType.TEXT, false}));
    }

    private static void terminate(KernelTransaction transaction) {
        transaction.markForTermination((Status)Status.Transaction.Terminated);
    }

    long entityWithPropId(KernelTransaction tx, Object value) throws Exception {
        return (Long)this.entityWithProp(tx, value).first();
    }

    void assertEntityAndValue(Set<Pair<Long, Value>> expected, KernelTransaction tx, boolean needsValues, Object anotherValueFoundByQuery, EntityValueIndexCursor entities) throws Exception {
        for (Pair<Long, Value> pair : expected) {
            this.deleteEntity(tx, (Long)pair.first());
        }
        this.entityWithPropId(tx, anotherValueFoundByQuery);
        if (needsValues) {
            HashSet<Pair> found = new HashSet<Pair>();
            while (entities.next()) {
                found.add(Pair.of((Object)entities.entityReference(), (Object)entities.propertyValue(0)));
            }
            Assertions.assertThat(found).isEqualTo(expected);
        } else {
            HashSet<Long> foundIds = new HashSet<Long>();
            while (entities.next()) {
                foundIds.add(entities.entityReference());
            }
            ImmutableSet expectedIds = (ImmutableSet)expected.stream().map(Pair::first).collect(Collectors2.toImmutableSet());
            Assertions.assertThat(foundIds).isEqualTo((Object)expectedIds);
        }
    }

    abstract Pair<Long, Value> entityWithProp(KernelTransaction var1, Object var2) throws Exception;

    abstract void createIndex(IndexType var1);

    abstract void deleteEntity(KernelTransaction var1, long var2) throws Exception;

    abstract boolean entityExists(KernelTransaction var1, long var2);

    abstract void removeProperty(KernelTransaction var1, long var2) throws Exception;

    abstract void setProperty(KernelTransaction var1, long var2, Value var4) throws Exception;

    abstract void assertEntityAndValueForSeek(Set<Pair<Long, Value>> var1, KernelTransaction var2, IndexDescriptor var3, boolean var4, Object var5, PropertyIndexQuery ... var6) throws Exception;

    abstract void assertEntityAndValueForScan(Set<Pair<Long, Value>> var1, KernelTransaction var2, IndexDescriptor var3, boolean var4, Object var5) throws Exception;

    static interface EntityValueIndexCursor {
        public boolean next();

        public Value propertyValue(int var1);

        public long entityReference();
    }
}

