/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import java.util.Optional;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class MissingStoreFilesRecoveryIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;
    private DatabaseManagementService managementService;
    private RecordDatabaseLayout databaseLayout;
    private DatabaseManagementServiceBuilder serviceBuilder;
    private NamedDatabaseId defaultNamedDatabaseId;
    private static final Label testNodes = Label.label((String)"testNodes");

    MissingStoreFilesRecoveryIT() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.serviceBuilder = new TestDatabaseManagementServiceBuilder(this.testDirectory.homePath());
        this.managementService = this.serviceBuilder.build();
        GraphDatabaseAPI databaseApi = MissingStoreFilesRecoveryIT.defaultDatabase(this.managementService);
        MissingStoreFilesRecoveryIT.createSomeData(databaseApi);
        this.databaseLayout = RecordDatabaseLayout.cast((DatabaseLayout)databaseApi.databaseLayout());
        this.defaultNamedDatabaseId = (NamedDatabaseId)this.getDatabaseManager().databaseIdRepository().getByName("neo4j").get();
        this.managementService.shutdown();
    }

    @AfterEach
    void tearDown() {
        if (this.managementService != null) {
            this.managementService.shutdown();
        }
    }

    @Test
    void databaseStartFailingOnMissingFilesAndMissedTxLogs() throws IOException {
        this.fileSystem.deleteFile(this.databaseLayout.nodeStore());
        this.fileSystem.deleteRecursively(this.databaseLayout.getTransactionLogsDirectory());
        this.managementService = this.serviceBuilder.build();
        DatabaseStateService dbStateService = this.getDatabaseStateService();
        Assertions.assertTrue((boolean)dbStateService.causeOfFailure(this.defaultNamedDatabaseId).isPresent());
    }

    @Test
    void failToStartOnMissingFilesAndPartialTransactionLogs() throws IOException {
        LogFiles logFiles = this.prepareDatabaseWithTwoTxLogFiles();
        this.fileSystem.deleteFile(logFiles.getLogFile().getLogFileForVersion(0L));
        this.fileSystem.deleteFile(this.databaseLayout.nodeStore());
        DatabaseStateService dbStateService = this.getDatabaseStateService();
        Optional failure = dbStateService.causeOfFailure(this.defaultNamedDatabaseId);
        Assertions.assertFalse((boolean)failure.isPresent());
        Assertions.assertFalse((boolean)this.fileSystem.fileExists(this.databaseLayout.nodeStore()));
    }

    private LogFiles prepareDatabaseWithTwoTxLogFiles() throws IOException {
        this.managementService = this.serviceBuilder.build();
        GraphDatabaseAPI databaseApi = MissingStoreFilesRecoveryIT.defaultDatabase(this.managementService);
        LogFiles logFiles = MissingStoreFilesRecoveryIT.rotateTransactionLogs(databaseApi);
        Assertions.assertNotNull((Object)logFiles.getLogFile().getLogFileForVersion(1L));
        MissingStoreFilesRecoveryIT.createSomeData(databaseApi);
        this.managementService.shutdown();
        return logFiles;
    }

    private DatabaseManager getDatabaseManager() {
        return (DatabaseManager)MissingStoreFilesRecoveryIT.defaultDatabase(this.managementService).getDependencyResolver().resolveDependency(DatabaseManager.class);
    }

    private DatabaseStateService getDatabaseStateService() {
        return (DatabaseStateService)MissingStoreFilesRecoveryIT.defaultDatabase(this.managementService).getDependencyResolver().resolveDependency(DatabaseStateService.class);
    }

    private static GraphDatabaseAPI defaultDatabase(DatabaseManagementService managementService) {
        return (GraphDatabaseAPI)managementService.database("neo4j");
    }

    private static LogFiles rotateTransactionLogs(GraphDatabaseAPI databaseApi) throws IOException {
        LogFiles logFiles = (LogFiles)databaseApi.getDependencyResolver().resolveDependency(LogFiles.class);
        LogFile logFile = logFiles.getLogFile();
        logFile.rotate();
        return logFiles;
    }

    private static void createSomeData(GraphDatabaseAPI databaseApi) throws IOException {
        MissingStoreFilesRecoveryIT.insertData(databaseApi);
        CheckPointer checkPointer = (CheckPointer)databaseApi.getDependencyResolver().resolveDependency(CheckPointer.class);
        checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpointInTheMiddle"));
        MissingStoreFilesRecoveryIT.insertData(databaseApi);
    }

    private static void insertData(GraphDatabaseAPI databaseApi) {
        for (int i = 0; i < 100; ++i) {
            try (Transaction transaction = databaseApi.beginTx();){
                Node nodeA = transaction.createNode(new Label[]{testNodes});
                Node nodeB = transaction.createNode(new Label[]{testNodes});
                nodeA.createRelationshipTo(nodeB, RelationshipType.withName((String)String.valueOf(i)));
                transaction.commit();
                continue;
            }
        }
    }
}

