/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.OtherThread;
import org.neo4j.test.extension.OtherThreadExtension;

@ImpermanentDbmsExtension
@ExtendWith(value={OtherThreadExtension.class})
public class UniquenessConstraintValidationConcurrencyIT {
    @Inject
    private GraphDatabaseService database;
    @Inject
    private OtherThread otherThread;

    @Test
    void shouldAllowConcurrentCreationOfNonConflictingData() throws Exception {
        this.createTestConstraint();
        try (Transaction tx = this.database.beginTx();){
            tx.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
            Assertions.assertTrue((boolean)((Boolean)this.otherThread.execute(this.createNode("Label1", "key1", "value2")).get()));
        }
    }

    @Test
    void shouldPreventConcurrentCreationOfConflictingData() throws Exception {
        Future result;
        this.createTestConstraint();
        try (Transaction tx = this.database.beginTx();){
            tx.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
            try {
                result = this.otherThread.execute(this.createNode("Label1", "key1", "value1"));
            }
            finally {
                this.waitUntilWaiting();
            }
            tx.commit();
        }
        Assertions.assertFalse((boolean)((Boolean)result.get()), (String)"node creation should fail");
    }

    @Test
    void shouldAllowOtherTransactionToCompleteIfFirstTransactionRollsBack() throws Exception {
        Future result;
        this.createTestConstraint();
        try (Transaction tx = this.database.beginTx();){
            tx.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
            try {
                result = this.otherThread.execute(this.createNode("Label1", "key1", "value1"));
            }
            finally {
                this.waitUntilWaiting();
            }
            tx.rollback();
        }
        Assertions.assertTrue((boolean)((Boolean)result.get()), (String)"node creation should fail");
    }

    private void createTestConstraint() {
        try (Transaction transaction = this.database.beginTx();){
            transaction.schema().constraintFor(Label.label((String)"Label1")).assertPropertyIsUnique("key1").create();
            transaction.commit();
        }
    }

    private void waitUntilWaiting() {
        try {
            this.otherThread.get().waitUntilWaiting();
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public Callable<Boolean> createNode(String label, String propertyKey, Object propertyValue) {
        return () -> {
            Boolean bl;
            block8: {
                Transaction tx = this.database.beginTx();
                try {
                    tx.createNode(new Label[]{Label.label((String)label)}).setProperty(propertyKey, propertyValue);
                    tx.commit();
                    bl = true;
                    if (tx == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (tx != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ConstraintViolationException e) {
                        return false;
                    }
                }
                tx.close();
            }
            return bl;
        };
    }
}

