/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.values.storable.Values;

class UniquenessConstraintValidationIT {
    UniquenessConstraintValidationIT() {
    }

    @Nested
    class RangeIndexTest
    extends UniquenessConstraintValidationBaseIT {
        RangeIndexTest() {
        }

        @Override
        IndexType indexType() {
            return IndexType.RANGE;
        }
    }

    @Nested
    class BTreeIndexTest
    extends UniquenessConstraintValidationBaseIT {
        BTreeIndexTest() {
        }

        @Override
        IndexType indexType() {
            return IndexType.BTREE;
        }
    }

    static abstract class UniquenessConstraintValidationBaseIT
    extends KernelIntegrationTest {
        UniquenessConstraintValidationBaseIT() {
        }

        abstract IndexType indexType();

        @Test
        void shouldEnforceOnSetProperty() throws Exception {
            this.constrainedNode("Label1", "key1", "value1");
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            long node = UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Label1");
            UniquePropertyValueValidationException e = (UniquePropertyValueValidationException)org.junit.jupiter.api.Assertions.assertThrows(UniquePropertyValueValidationException.class, () -> {
                int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName("key1");
                transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)"value1"));
            });
            Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)transaction.tokenRead())).contains(new CharSequence[]{"`key1` = 'value1'"});
            this.commit();
        }

        @Test
        void roundingErrorsFromLongToDoubleShouldNotPreventTxFromCommitting() throws Exception {
            long propertyValue = 285414114323346805L;
            long firstNode = this.constrainedNode("label1", "key1", propertyValue);
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            long node = UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "label1");
            org.junit.jupiter.api.Assertions.assertNotEquals((long)firstNode, (long)node);
            int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName("key1");
            transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)(++propertyValue)));
            this.commit();
        }

        @Test
        void shouldEnforceUniquenessConstraintOnAddLabelForNumberPropertyOnNodeNotFromTransaction() throws Exception {
            this.constrainedNode("Label1", "key1", 1);
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            long node = UniquenessConstraintValidationBaseIT.createNode(transaction, "key1", 1);
            this.commit();
            KernelTransaction transaction2 = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            UniquePropertyValueValidationException e = (UniquePropertyValueValidationException)org.junit.jupiter.api.Assertions.assertThrows(UniquePropertyValueValidationException.class, () -> {
                int label = transaction2.tokenWrite().labelGetOrCreateForName("Label1");
                transaction2.dataWrite().nodeAddLabel(node, label);
            });
            Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)transaction2.tokenRead())).contains(new CharSequence[]{"`key1` = 1"});
            this.commit();
        }

        @Test
        void shouldEnforceUniquenessConstraintOnAddLabelForStringProperty() throws Exception {
            this.constrainedNode("Label1", "key1", "value1");
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            long node = UniquenessConstraintValidationBaseIT.createNode(transaction, "key1", "value1");
            UniquePropertyValueValidationException e = (UniquePropertyValueValidationException)org.junit.jupiter.api.Assertions.assertThrows(UniquePropertyValueValidationException.class, () -> {
                int label = transaction.tokenWrite().labelGetOrCreateForName("Label1");
                transaction.dataWrite().nodeAddLabel(node, label);
            });
            Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)transaction.tokenRead())).contains(new CharSequence[]{"`key1` = 'value1'"});
            this.commit();
        }

        @Test
        void shouldAllowRemoveAndAddConflictingDataInOneTransaction_DeleteNode() throws Exception {
            long node = this.constrainedNode("Label1", "key1", "value1");
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            transaction.dataWrite().nodeDelete(node);
            UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Label1", "key1", "value1");
            this.commit();
        }

        @Test
        void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveLabel() throws Exception {
            long node = this.constrainedNode("Label1", "key1", "value1");
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            int label = transaction.tokenWrite().labelGetOrCreateForName("Label1");
            transaction.dataWrite().nodeRemoveLabel(node, label);
            UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Label1", "key1", "value1");
            this.commit();
        }

        @Test
        void shouldAllowRemoveAndAddConflictingDataInOneTransaction_RemoveProperty() throws Exception {
            long node = this.constrainedNode("Label1", "key1", "value1");
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            int key = transaction.tokenRead().propertyKey("key1");
            transaction.dataWrite().nodeRemoveProperty(node, key);
            UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Label1", "key1", "value1");
            this.commit();
        }

        @Test
        void shouldAllowRemoveAndAddConflictingDataInOneTransaction_ChangeProperty() throws Exception {
            long node = this.constrainedNode("Label1", "key1", "value1");
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName("key1");
            transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)"value2"));
            UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Label1", "key1", "value1");
            this.commit();
        }

        @Test
        void shouldPreventConflictingDataInSameTransaction() throws Exception {
            this.constrainedNode("Label1", "key1", "value1");
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Label1", "key1", "value2");
            UniquePropertyValueValidationException e = (UniquePropertyValueValidationException)org.junit.jupiter.api.Assertions.assertThrows(UniquePropertyValueValidationException.class, () -> UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Label1", "key1", "value2"));
            Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)transaction.tokenRead())).contains(new CharSequence[]{"`key1` = 'value2'"});
            this.commit();
        }

        @Test
        void shouldAllowNoopPropertyUpdate() throws KernelException {
            long node = this.constrainedNode("Label1", "key1", "value1");
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            int key = transaction.tokenWrite().propertyKeyGetOrCreateForName("key1");
            transaction.dataWrite().nodeSetProperty(node, key, Values.of((Object)"value1"));
            this.commit();
        }

        @Test
        void shouldAllowNoopLabelUpdate() throws KernelException {
            long node = this.constrainedNode("Label1", "key1", "value1");
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            int label = transaction.tokenWrite().labelGetOrCreateForName("Label1");
            transaction.dataWrite().nodeAddLabel(node, label);
            this.commit();
        }

        @Test
        void shouldAllowCreationOfNonConflictingData() throws Exception {
            this.constrainedNode("Label1", "key1", "value1");
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            UniquenessConstraintValidationBaseIT.createNode(transaction, "key1", "value1");
            UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Label2", "key1", "value1");
            UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Label1", "key1", "value2");
            UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Label1", "key2", "value1");
            this.commit();
            transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)UniquenessConstraintValidationBaseIT.countNodes(transaction), (String)"number of nodes");
            this.rollback();
        }

        @Test
        void unrelatedNodesWithSamePropertyShouldNotInterfereWithUniquenessCheck() throws Exception {
            ConstraintDescriptor constraint = this.createConstraint("Person", "id");
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            long ourNode = UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Person", "id", 1);
            UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Item", "id", 2);
            this.commit();
            transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            TokenRead tokenRead = transaction.tokenRead();
            int propId = tokenRead.propertyKey("id");
            IndexDescriptor idx = transaction.schemaRead().indexGetForName(constraint.getName());
            UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Item", "id", 2);
            try (NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
                Assertions.assertThat((long)transaction.dataRead().lockingNodeUniqueIndexSeek(idx, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)propId, (Object)Values.of((Object)1))})).isEqualTo(ourNode);
            }
            this.commit();
        }

        @Test
        void addingUniqueNodeWithUnrelatedValueShouldNotAffectLookup() throws Exception {
            ConstraintDescriptor constraint = this.createConstraint("Person", "id");
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            long ourNode = UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Person", "id", 1);
            this.commit();
            transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            TokenRead tokenRead = transaction.tokenRead();
            int propId = tokenRead.propertyKey("id");
            IndexDescriptor idx = transaction.schemaRead().indexGetForName(constraint.getName());
            UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, "Person", "id", 2);
            try (NodeValueIndexCursor cursor = transaction.cursors().allocateNodeValueIndexCursor(transaction.cursorContext(), transaction.memoryTracker());){
                Assertions.assertThat((long)transaction.dataRead().lockingNodeUniqueIndexSeek(idx, cursor, new PropertyIndexQuery.ExactPredicate[]{PropertyIndexQuery.exact((int)propId, (Object)Values.of((Object)1))})).isEqualTo(ourNode);
            }
            this.commit();
        }

        private static long createLabeledNode(KernelTransaction transaction, String label) throws KernelException {
            long node = transaction.dataWrite().nodeCreate();
            int labelId = transaction.tokenWrite().labelGetOrCreateForName(label);
            transaction.dataWrite().nodeAddLabel(node, labelId);
            return node;
        }

        private static long createNode(KernelTransaction transaction, String key, Object value) throws KernelException {
            long node = transaction.dataWrite().nodeCreate();
            int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
            transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)value));
            return node;
        }

        private static long createLabeledNode(KernelTransaction transaction, String label, String key, Object value) throws KernelException {
            long node = UniquenessConstraintValidationBaseIT.createLabeledNode(transaction, label);
            int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
            transaction.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)value));
            return node;
        }

        private long constrainedNode(String labelName, String propertyKey, Object propertyValue) throws KernelException {
            KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
            int label = transaction.tokenWrite().labelGetOrCreateForName(labelName);
            long node = transaction.dataWrite().nodeCreate();
            transaction.dataWrite().nodeAddLabel(node, label);
            int key = transaction.tokenWrite().propertyKeyGetOrCreateForName(propertyKey);
            transaction.dataWrite().nodeSetProperty(node, key, Values.of((Object)propertyValue));
            this.commit();
            this.createConstraint(labelName, propertyKey);
            return node;
        }

        private ConstraintDescriptor createConstraint(String label, String propertyKey) throws KernelException {
            TokenWrite tokenWrite = this.tokenWriteInNewTransaction();
            int labelId = tokenWrite.labelGetOrCreateForName(label);
            int propertyKeyId = tokenWrite.propertyKeyGetOrCreateForName(propertyKey);
            this.commit();
            SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
            ConstraintDescriptor constraint = schemaWrite.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId})).withIndexType(this.indexType()));
            this.commit();
            return constraint;
        }
    }
}

