/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.ControlledPopulationIndexProvider;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension(configurationCallback="configure")
public class SchemaIndexWaitingAcceptanceTest {
    @Inject
    private GraphDatabaseService database;
    private final ControlledPopulationIndexProvider provider = new ControlledPopulationIndexProvider();

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.addExtension(SchemaIndexTestHelper.singleInstanceIndexProviderFactory((String)"test", (IndexProvider)this.provider)).noOpSystemGraphInitializer().setConfig(GraphDatabaseSettings.default_schema_provider, (Object)this.provider.getProviderDescriptor().name());
    }

    @BeforeEach
    void createSomeData() {
        try (Transaction tx = this.database.beginTx();){
            tx.createNode();
            tx.commit();
        }
    }

    @Test
    void shouldTimeoutWaitingForIndexToComeOnline() throws InterruptedException {
        IndexDefinition index;
        Barrier.Control barrier = this.provider.installPopulationLatch(ControlledPopulationIndexProvider.PopulationLatchMethod.CREATE);
        try (Transaction tx = this.database.beginTx();){
            index = tx.schema().indexFor(Label.label((String)"Person")).on("name").create();
            tx.commit();
        }
        barrier.await();
        IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                tx.schema().awaitIndexOnline(index, 1L, TimeUnit.MILLISECONDS);
            }
        });
        Assertions.assertThat((Throwable)e).hasMessageContaining("come online");
        barrier.release();
    }

    @Test
    void shouldTimeoutWaitingForIndexByNameToComeOnline() throws InterruptedException {
        Barrier.Control barrier = this.provider.installPopulationLatch(ControlledPopulationIndexProvider.PopulationLatchMethod.CREATE);
        try (Transaction tx = this.database.beginTx();){
            tx.schema().indexFor(Label.label((String)"Person")).on("name").withName("my_index").create();
            tx.commit();
        }
        barrier.await();
        IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                tx.schema().awaitIndexOnline("my_index", 1L, TimeUnit.MILLISECONDS);
            }
        });
        Assertions.assertThat((Throwable)e).hasMessageContaining("come online");
        barrier.release();
    }

    @Test
    void shouldTimeoutWaitingForAllIndexesToComeOnline() throws InterruptedException {
        Barrier.Control barrier = this.provider.installPopulationLatch(ControlledPopulationIndexProvider.PopulationLatchMethod.CREATE);
        try (Transaction tx = this.database.beginTx();){
            tx.schema().indexFor(Label.label((String)"Person")).on("name").create();
            tx.commit();
        }
        barrier.await();
        IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            try (Transaction tx = this.database.beginTx();){
                tx.schema().awaitIndexesOnline(1L, TimeUnit.MILLISECONDS);
            }
        });
        Assertions.assertThat((Throwable)e).hasMessageContaining("come online");
        barrier.release();
    }
}

