/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.ToLongFunction;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.primitive.LongList;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedLongProcedure;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestBase;
import org.neo4j.kernel.impl.newapi.KernelAPIWriteTestSupport;
import org.neo4j.kernel.impl.newapi.TestUtils;
import org.neo4j.util.concurrent.Futures;

abstract class ParallelRelationshipCursorTransactionStateTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private static final ToLongFunction<RelationshipScanCursor> REL_GET = RelationshipDataAccessor::relationshipReference;

    ParallelRelationshipCursorTransactionStateTestBase() {
    }

    @Test
    void shouldHandleEmptyDatabase() throws TransactionFailureException {
        try (KernelTransaction tx = ParallelRelationshipCursorTransactionStateTestBase.beginTransaction();){
            CursorContext cursorContext = tx.cursorContext();
            try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(cursorContext);){
                Scan scan = tx.dataRead().allRelationshipsScan();
                while (scan.reserveBatch((Cursor)cursor, 23, cursorContext, tx.securityContext().mode())) {
                    Assertions.assertFalse((boolean)cursor.next());
                }
            }
        }
    }

    @Test
    void scanShouldNotSeeDeletedRelationships() throws Exception {
        int size = 100;
        MutableLongSet created = LongSets.mutable.empty();
        MutableLongSet deleted = LongSets.mutable.empty();
        try (final KernelTransaction tx = ParallelRelationshipCursorTransactionStateTestBase.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < size; ++i) {
                created.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
                deleted.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
            }
            tx.commit();
        }
        tx = ParallelRelationshipCursorTransactionStateTestBase.beginTransaction();
        try {
            deleted.each((LongProcedure)new CheckedLongProcedure(){

                public void safeValue(long item) throws Exception {
                    tx.dataWrite().relationshipDelete(item);
                }
            });
            CursorContext cursorContext = tx.cursorContext();
            try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(cursorContext);){
                Scan scan = tx.dataRead().allRelationshipsScan();
                MutableLongSet seen = LongSets.mutable.empty();
                while (scan.reserveBatch((Cursor)cursor, 17, cursorContext, tx.createExecutionContext().accessMode())) {
                    while (cursor.next()) {
                        long relationshipId = cursor.relationshipReference();
                        Assertions.assertTrue((boolean)seen.add(relationshipId));
                        Assertions.assertTrue((boolean)created.remove(relationshipId));
                    }
                }
                Assertions.assertTrue((boolean)created.isEmpty());
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void scanShouldSeeAddedRelationships() throws Exception {
        int size = 100;
        MutableLongSet existing = ParallelRelationshipCursorTransactionStateTestBase.createRelationships(size);
        MutableLongSet added = LongSets.mutable.empty();
        try (KernelTransaction tx = ParallelRelationshipCursorTransactionStateTestBase.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < size; ++i) {
                added.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
            }
            CursorContext cursorContext = tx.cursorContext();
            try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(cursorContext);){
                Scan scan = tx.dataRead().allRelationshipsScan();
                MutableLongSet seen = LongSets.mutable.empty();
                while (scan.reserveBatch((Cursor)cursor, 17, cursorContext, tx.securityContext().mode())) {
                    while (cursor.next()) {
                        long relationshipId = cursor.relationshipReference();
                        Assertions.assertTrue((boolean)seen.add(relationshipId));
                        Assertions.assertTrue((existing.remove(relationshipId) || added.remove(relationshipId) ? 1 : 0) != 0);
                    }
                }
                Assertions.assertTrue((boolean)existing.isEmpty());
                Assertions.assertTrue((boolean)added.isEmpty());
            }
        }
    }

    @Test
    void shouldReserveBatchFromTxState() throws KernelException {
        try (KernelTransaction tx = ParallelRelationshipCursorTransactionStateTestBase.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < 11; ++i) {
                write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate());
            }
            CursorContext cursorContext = tx.cursorContext();
            AccessMode accessMode = tx.securityContext().mode();
            try (RelationshipScanCursor cursor = tx.cursors().allocateRelationshipScanCursor(cursorContext);){
                Scan scan = tx.dataRead().allRelationshipsScan();
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 5, cursorContext, accessMode));
                Assertions.assertEquals((int)5, (int)TestUtils.count((Cursor)cursor));
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 4, cursorContext, accessMode));
                Assertions.assertEquals((int)4, (int)TestUtils.count((Cursor)cursor));
                Assertions.assertTrue((boolean)scan.reserveBatch((Cursor)cursor, 6, cursorContext, accessMode));
                Assertions.assertEquals((int)2, (int)TestUtils.count((Cursor)cursor));
                while (scan.reserveBatch((Cursor)cursor, 3, cursorContext, accessMode)) {
                    Assertions.assertFalse((boolean)cursor.next());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipsFromMultipleThreads() throws InterruptedException, ExecutionException, KernelException {
        int numberOfWorkers = 4;
        ExecutorService service = Executors.newFixedThreadPool(numberOfWorkers);
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        int size = 128;
        LongArrayList ids = new LongArrayList();
        try (KernelTransaction tx = ParallelRelationshipCursorTransactionStateTestBase.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < size; ++i) {
                ids.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
            }
            Read read = tx.dataRead();
            Scan scan = read.allRelationshipsScan();
            List workerContexts = TestUtils.createContexts(tx, arg_0 -> ((CursorFactory)cursors).allocateRelationshipScanCursor(arg_0), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(size / numberOfWorkers, scan, numberOfWorkers, workerContexts, REL_GET));
            List lists = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(lists);
            LongList concat = TestUtils.concat(lists);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)concat.toSortedList());
            tx.rollback();
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipsFromMultipleThreadWithBigSizeHints() throws InterruptedException, ExecutionException, KernelException {
        int numberOfWorkers = 4;
        ExecutorService service = Executors.newFixedThreadPool(numberOfWorkers);
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        int size = 128;
        LongArrayList ids = new LongArrayList();
        try (KernelTransaction tx = ParallelRelationshipCursorTransactionStateTestBase.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < size; ++i) {
                ids.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
            }
            Read read = tx.dataRead();
            Scan scan = read.allRelationshipsScan();
            List workerContexts = TestUtils.createContexts(tx, arg_0 -> ((CursorFactory)cursors).allocateRelationshipScanCursor(arg_0), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createWorkers(100, scan, numberOfWorkers, workerContexts, REL_GET));
            List lists = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(lists);
            LongList concat = TestUtils.concat(lists);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)concat.toSortedList());
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScanAllRelationshipFromRandomlySizedWorkers() throws InterruptedException, KernelException, ExecutionException {
        ExecutorService service = Executors.newFixedThreadPool(4);
        int size = 128;
        LongArrayList ids = new LongArrayList();
        try (KernelTransaction tx = ParallelRelationshipCursorTransactionStateTestBase.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < size; ++i) {
                ids.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
            }
            Read read = tx.dataRead();
            Scan scan = read.allRelationshipsScan();
            CursorFactory cursors = testSupport.kernelToTest().cursors();
            int numberOfWorkers = 10;
            List workerContexts = TestUtils.createContexts(tx, arg_0 -> ((CursorFactory)cursors).allocateRelationshipScanCursor(arg_0), numberOfWorkers);
            List<Future<LongList>> futures = service.invokeAll(TestUtils.createRandomWorkers(scan, numberOfWorkers, workerContexts, REL_GET));
            List lists = Futures.getAllResults(futures);
            TestUtils.closeWorkContexts(workerContexts);
            TestUtils.assertDistinct(lists);
            LongList concat = TestUtils.concat(lists);
            Assertions.assertEquals((Object)ids.toSortedList(), (Object)concat.toSortedList());
            tx.rollback();
        }
        finally {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void parallelTxStateScanStressTest() throws InterruptedException, KernelException, ExecutionException {
        MutableLongSet existingRelationships = ParallelRelationshipCursorTransactionStateTestBase.createRelationships(77);
        int workers = Runtime.getRuntime().availableProcessors();
        ExecutorService threadPool = Executors.newFixedThreadPool(workers);
        CursorFactory cursors = testSupport.kernelToTest().cursors();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        try {
            for (int i = 0; i < 1000; ++i) {
                MutableLongSet allRels = LongSets.mutable.withAll((LongIterable)existingRelationships);
                try (KernelTransaction tx = ParallelRelationshipCursorTransactionStateTestBase.beginTransaction();){
                    int relationshipsInTx = random.nextInt(100);
                    Write write = tx.dataWrite();
                    int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
                    for (int j = 0; j < relationshipsInTx; ++j) {
                        allRels.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
                    }
                    Scan scan = tx.dataRead().allRelationshipsScan();
                    List workerContexts = TestUtils.createContexts(tx, arg_0 -> ((CursorFactory)cursors).allocateRelationshipScanCursor(arg_0), workers);
                    List<Future<LongList>> futures = threadPool.invokeAll(TestUtils.createRandomWorkers(scan, workers, workerContexts, REL_GET));
                    List lists = Futures.getAllResults(futures);
                    TestUtils.closeWorkContexts(workerContexts);
                    TestUtils.assertDistinct(lists);
                    LongList concat = TestUtils.concat(lists);
                    Assertions.assertEquals((Object)allRels, (Object)LongSets.immutable.withAll((LongIterable)concat), (String)String.format("relationships=%d, seen=%d, all=%d", relationshipsInTx, concat.size(), allRels.size()));
                    Assertions.assertEquals((int)allRels.size(), (int)concat.size(), (String)String.format("relationships=%d", relationshipsInTx));
                    tx.rollback();
                    continue;
                }
            }
        }
        finally {
            threadPool.shutdown();
            threadPool.awaitTermination(1L, TimeUnit.MINUTES);
        }
    }

    private static MutableLongSet createRelationships(int size) throws KernelException {
        MutableLongSet rels = LongSets.mutable.empty();
        try (KernelTransaction tx = ParallelRelationshipCursorTransactionStateTestBase.beginTransaction();){
            Write write = tx.dataWrite();
            int type = tx.tokenWrite().relationshipTypeGetOrCreateForName("R");
            for (int i = 0; i < size; ++i) {
                rels.add(write.relationshipCreate(write.nodeCreate(), type, write.nodeCreate()));
            }
            tx.commit();
        }
        return rels;
    }
}

