/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
class DenseNodeIT {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private Config config;

    DenseNodeIT() {
    }

    @Test
    void testBringingNodeOverDenseThresholdIsConsistent() {
        Node root;
        try (Transaction tx = this.db.beginTx();){
            root = tx.createNode();
            DenseNodeIT.createRelationshipsOnNode(tx, root, 40);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            root = tx.getNodeById(root.getId());
            DenseNodeIT.createRelationshipsOnNode(tx, root, 60);
            Assertions.assertEquals((int)100, (int)root.getDegree());
            Assertions.assertEquals((int)100, (int)root.getDegree(Direction.OUTGOING));
            Assertions.assertEquals((int)0, (int)root.getDegree(Direction.INCOMING));
            Assertions.assertEquals((int)25, (int)root.getDegree(RelationshipType.withName((String)"Type0")));
            Assertions.assertEquals((int)25, (int)root.getDegree(RelationshipType.withName((String)"Type1")));
            Assertions.assertEquals((int)25, (int)root.getDegree(RelationshipType.withName((String)"Type2")));
            Assertions.assertEquals((int)25, (int)root.getDegree(RelationshipType.withName((String)"Type3")));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            root = tx.getNodeById(root.getId());
            Assertions.assertEquals((int)100, (int)root.getDegree());
            Assertions.assertEquals((int)100, (int)root.getDegree(Direction.OUTGOING));
            Assertions.assertEquals((int)0, (int)root.getDegree(Direction.INCOMING));
            Assertions.assertEquals((int)25, (int)root.getDegree(RelationshipType.withName((String)"Type0")));
            Assertions.assertEquals((int)25, (int)root.getDegree(RelationshipType.withName((String)"Type1")));
            Assertions.assertEquals((int)25, (int)root.getDegree(RelationshipType.withName((String)"Type2")));
            Assertions.assertEquals((int)25, (int)root.getDegree(RelationshipType.withName((String)"Type3")));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void deletingRelationshipsFromDenseNodeIsConsistent() {
        Node root;
        try (Transaction tx = this.db.beginTx();){
            root = tx.createNode();
            DenseNodeIT.createRelationshipsOnNode(tx, root, 100);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            root = tx.getNodeById(root.getId());
            DenseNodeIT.deleteRelationshipsFromNode(root, 80);
            Assertions.assertEquals((int)20, (int)root.getDegree());
            Assertions.assertEquals((int)20, (int)root.getDegree(Direction.OUTGOING));
            Assertions.assertEquals((int)0, (int)root.getDegree(Direction.INCOMING));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            root = tx.getNodeById(root.getId());
            Assertions.assertEquals((int)20, (int)root.getDegree());
            Assertions.assertEquals((int)20, (int)root.getDegree(Direction.OUTGOING));
            Assertions.assertEquals((int)0, (int)root.getDegree(Direction.INCOMING));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void movingBilaterallyOfTheDenseNodeThresholdIsConsistent() {
        Node root;
        try (Transaction tx = this.db.beginTx();){
            root = tx.createNode();
            DenseNodeIT.createRelationshipsOnNode(tx, root, 100);
            DenseNodeIT.deleteRelationshipsFromNode(root, 80);
            Assertions.assertEquals((int)20, (int)root.getDegree());
            Assertions.assertEquals((int)20, (int)root.getDegree(Direction.OUTGOING));
            Assertions.assertEquals((int)0, (int)root.getDegree(Direction.INCOMING));
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            root = tx.getNodeById(root.getId());
            Assertions.assertEquals((int)20, (int)root.getDegree());
            Assertions.assertEquals((int)20, (int)root.getDegree(Direction.OUTGOING));
            Assertions.assertEquals((int)0, (int)root.getDegree(Direction.INCOMING));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void testBringingTwoConnectedNodesOverDenseThresholdIsConsistent() {
        Node sink;
        Node source;
        try (Transaction tx = this.db.beginTx();){
            source = tx.createNode();
            sink = tx.createNode();
            DenseNodeIT.createRelationshipsBetweenNodes(source, sink, 40);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            source = tx.getNodeById(source.getId());
            sink = tx.getNodeById(sink.getId());
            DenseNodeIT.createRelationshipsBetweenNodes(source, sink, 60);
            Assertions.assertEquals((int)100, (int)source.getDegree());
            Assertions.assertEquals((int)100, (int)source.getDegree(Direction.OUTGOING));
            Assertions.assertEquals((int)0, (int)source.getDegree(Direction.INCOMING));
            Assertions.assertEquals((int)25, (int)source.getDegree(RelationshipType.withName((String)"Type0")));
            Assertions.assertEquals((int)25, (int)source.getDegree(RelationshipType.withName((String)"Type1")));
            Assertions.assertEquals((int)25, (int)source.getDegree(RelationshipType.withName((String)"Type2")));
            Assertions.assertEquals((int)25, (int)source.getDegree(RelationshipType.withName((String)"Type3")));
            Assertions.assertEquals((int)100, (int)sink.getDegree());
            Assertions.assertEquals((int)0, (int)sink.getDegree(Direction.OUTGOING));
            Assertions.assertEquals((int)100, (int)sink.getDegree(Direction.INCOMING));
            Assertions.assertEquals((int)25, (int)sink.getDegree(RelationshipType.withName((String)"Type0")));
            Assertions.assertEquals((int)25, (int)sink.getDegree(RelationshipType.withName((String)"Type1")));
            Assertions.assertEquals((int)25, (int)sink.getDegree(RelationshipType.withName((String)"Type2")));
            Assertions.assertEquals((int)25, (int)sink.getDegree(RelationshipType.withName((String)"Type3")));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            source = tx.getNodeById(source.getId());
            sink = tx.getNodeById(sink.getId());
            Assertions.assertEquals((int)100, (int)source.getDegree());
            Assertions.assertEquals((int)100, (int)source.getDegree(Direction.OUTGOING));
            Assertions.assertEquals((int)0, (int)source.getDegree(Direction.INCOMING));
            Assertions.assertEquals((int)25, (int)source.getDegree(RelationshipType.withName((String)"Type0")));
            Assertions.assertEquals((int)25, (int)source.getDegree(RelationshipType.withName((String)"Type1")));
            Assertions.assertEquals((int)25, (int)source.getDegree(RelationshipType.withName((String)"Type2")));
            Assertions.assertEquals((int)25, (int)source.getDegree(RelationshipType.withName((String)"Type3")));
            Assertions.assertEquals((int)100, (int)sink.getDegree());
            Assertions.assertEquals((int)0, (int)sink.getDegree(Direction.OUTGOING));
            Assertions.assertEquals((int)100, (int)sink.getDegree(Direction.INCOMING));
            Assertions.assertEquals((int)25, (int)sink.getDegree(RelationshipType.withName((String)"Type0")));
            Assertions.assertEquals((int)25, (int)sink.getDegree(RelationshipType.withName((String)"Type1")));
            Assertions.assertEquals((int)25, (int)sink.getDegree(RelationshipType.withName((String)"Type2")));
            Assertions.assertEquals((int)25, (int)sink.getDegree(RelationshipType.withName((String)"Type3")));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldBeAbleToCreateRelationshipsInEmptyDenseNode() {
        Relationship rel;
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = tx.createNode();
            DenseNodeIT.createRelationshipsBetweenNodes(node, tx.createNode(), this.denseNodeThreshold(this.db) + 1);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.getNodeById(node.getId()).getRelationships().forEach(Relationship::delete);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Transaction tx = this.db.beginTx();){
            rel = tx.getNodeById(node.getId()).createRelationshipTo(tx.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            node = tx.getNodeById(node.getId());
            rel = tx.getRelationshipById(rel.getId());
            Assertions.assertEquals((Object)rel, (Object)Iterables.single((Iterable)node.getRelationships()));
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private int denseNodeThreshold(GraphDatabaseAPI db) {
        return (Integer)this.config.get(GraphDatabaseSettings.dense_node_threshold);
    }

    private static void deleteRelationshipsFromNode(Node root, int numberOfRelationships) {
        int deleted = 0;
        try (ResourceIterator iterator = Iterators.asResourceIterator(root.getRelationships().iterator());){
            while (iterator.hasNext()) {
                Relationship relationship = (Relationship)iterator.next();
                relationship.delete();
                if (++deleted != numberOfRelationships) continue;
                break;
            }
        }
    }

    private static void createRelationshipsOnNode(Transaction tx, Node root, int numberOfRelationships) {
        for (int i = 0; i < numberOfRelationships; ++i) {
            root.createRelationshipTo(tx.createNode(), RelationshipType.withName((String)("Type" + i % 4))).setProperty("" + i, (Object)i);
        }
    }

    private static void createRelationshipsBetweenNodes(Node source, Node sink, int numberOfRelationships) {
        for (int i = 0; i < numberOfRelationships; ++i) {
            source.createRelationshipTo(sink, RelationshipType.withName((String)("Type" + i % 4))).setProperty("" + i, (Object)i);
        }
    }
}

