/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class TransactionLogsInSeparateLocationIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fileSystem;

    TransactionLogsInSeparateLocationIT() {
    }

    @Test
    void databaseWithTransactionLogsInSeparateAbsoluteLocation() throws IOException {
        Path txDirectory = this.testDirectory.directory("transaction-logs");
        Config config = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.testDirectory.homePath()).set(GraphDatabaseSettings.transaction_logs_root_path, (Object)txDirectory.toAbsolutePath()).build();
        DatabaseLayout layout = DatabaseLayout.of((Config)config);
        StorageEngineFactory storageEngineFactory = TransactionLogsInSeparateLocationIT.performTransactions(txDirectory.toAbsolutePath(), layout.databaseDirectory());
        this.verifyTransactionLogs(layout.getTransactionLogsDirectory(), layout.databaseDirectory(), storageEngineFactory);
    }

    private static StorageEngineFactory performTransactions(Path txPath, Path storeDir) {
        DatabaseManagementService managementService = new TestDatabaseManagementServiceBuilder(storeDir).setConfig(GraphDatabaseSettings.transaction_logs_root_path, (Object)txPath).build();
        GraphDatabaseService database = managementService.database("neo4j");
        for (int i = 0; i < 10; ++i) {
            try (Transaction transaction = database.beginTx();){
                Node node = transaction.createNode();
                node.setProperty("a", (Object)"b");
                node.setProperty("c", (Object)"d");
                transaction.commit();
                continue;
            }
        }
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)((GraphDatabaseAPI)database).getDependencyResolver().resolveDependency(StorageEngineFactory.class);
        managementService.shutdown();
        return storageEngineFactory;
    }

    private void verifyTransactionLogs(Path txDirectory, Path storeDir, StorageEngineFactory storageEngineFactory) throws IOException {
        LogFiles storeDirLogs = LogFilesBuilder.logFilesBasedOnlyBuilder((Path)storeDir, (FileSystemAbstraction)this.fileSystem).build();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)storeDirLogs.getLogFile().versionExists(0L));
        LogFiles txDirectoryLogs = LogFilesBuilder.logFilesBasedOnlyBuilder((Path)txDirectory, (FileSystemAbstraction)this.fileSystem).build();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)txDirectoryLogs.getLogFile().versionExists(0L));
        try (PhysicalLogVersionedStoreChannel physicalLogVersionedStoreChannel = txDirectoryLogs.getLogFile().openForVersion(0L);){
            Assertions.assertThat((long)physicalLogVersionedStoreChannel.size()).isGreaterThan(0L);
        }
    }
}

