/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.helpers.CachingExpandInto;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@DbmsExtension(configurationCallback="config")
class CachingExpandIntoTest {
    private static final MemoryTracker MEMORY_TRACKER = EmptyMemoryTracker.INSTANCE;
    @Inject
    private Kernel kernel;
    private static final int DENSE_THRESHOLD = 10;
    private static final TokenHolders tokenHolders = (TokenHolders)Mockito.mock(TokenHolders.class);
    private static final QueryExecutionEngine engine = (QueryExecutionEngine)Mockito.mock(QueryExecutionEngine.class);
    private static final TransactionalContextFactory contextFactory = (TransactionalContextFactory)Mockito.mock(TransactionalContextFactory.class);
    private static final DatabaseAvailabilityGuard availabilityGuard = (DatabaseAvailabilityGuard)Mockito.mock(DatabaseAvailabilityGuard.class);

    CachingExpandIntoTest() {
    }

    @ExtensionCallback
    void config(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.dense_node_threshold, (Object)10);
    }

    private KernelTransaction transaction() throws TransactionFailureException {
        KernelTransaction kernelTransaction = this.kernel.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);
        new TransactionImpl(tokenHolders, contextFactory, availabilityGuard, engine, kernelTransaction, null, null);
        return kernelTransaction;
    }

    @Test
    void shouldFindConnectingRelationshipBetweenTwoDenseNodesWhereStartNodeHasHigherDegree() throws KernelException {
        long r3;
        long r2;
        long r1;
        long end;
        long start;
        try (KernelTransaction tx = this.transaction();){
            start = CachingExpandIntoTest.nodeWithDegree(tx, 43);
            end = CachingExpandIntoTest.nodeWithDegree(tx, 11);
            r1 = CachingExpandIntoTest.relate(tx, start, "R1", end);
            r2 = CachingExpandIntoTest.relate(tx, start, "R2", end);
            r3 = CachingExpandIntoTest.relate(tx, end, "R3", start);
            tx.commit();
        }
        Assertions.assertThat((Object)this.connections(start, Direction.OUTGOING, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(new long[]{r1, r2}));
        Assertions.assertThat((Object)this.connections(start, Direction.OUTGOING, end, "R1")).isEqualTo((Object)LongSets.immutable.of(r1));
        Assertions.assertThat((Object)this.connections(start, Direction.INCOMING, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(r3));
        Assertions.assertThat((Object)this.connections(start, Direction.INCOMING, end, "R1")).isEqualTo((Object)LongSets.immutable.empty());
        Assertions.assertThat((Object)this.connections(start, Direction.BOTH, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(new long[]{r1, r2, r3}));
        Assertions.assertThat((Object)this.connections(start, Direction.BOTH, end, "R2", "R3")).isEqualTo((Object)LongSets.immutable.of(new long[]{r2, r3}));
    }

    @Test
    void shouldFindConnectingRelationshipBetweenTwoDenseNodesWhereEndNodeHasHigherDegree() throws KernelException {
        long r3;
        long r2;
        long r1;
        long end;
        long start;
        try (KernelTransaction tx = this.transaction();){
            start = CachingExpandIntoTest.nodeWithDegree(tx, 11);
            end = CachingExpandIntoTest.nodeWithDegree(tx, 43);
            r1 = CachingExpandIntoTest.relate(tx, start, "R1", end);
            r2 = CachingExpandIntoTest.relate(tx, start, "R2", end);
            r3 = CachingExpandIntoTest.relate(tx, end, "R3", start);
            tx.commit();
        }
        Assertions.assertThat((Object)this.connections(start, Direction.OUTGOING, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(new long[]{r1, r2}));
        Assertions.assertThat((Object)this.connections(start, Direction.OUTGOING, end, "R1")).isEqualTo((Object)LongSets.immutable.of(r1));
        Assertions.assertThat((Object)this.connections(start, Direction.INCOMING, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(r3));
        Assertions.assertThat((Object)this.connections(start, Direction.INCOMING, end, "R1")).isEqualTo((Object)LongSets.immutable.empty());
        Assertions.assertThat((Object)this.connections(start, Direction.BOTH, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(new long[]{r1, r2, r3}));
        Assertions.assertThat((Object)this.connections(start, Direction.BOTH, end, "R2", "R3")).isEqualTo((Object)LongSets.immutable.of(new long[]{r2, r3}));
    }

    @Test
    void shouldFindConnectingRelationshipBetweenSparseAndDenseNodes() throws KernelException {
        long r3;
        long r2;
        long r1;
        long end;
        long start;
        try (KernelTransaction tx = this.transaction();){
            start = CachingExpandIntoTest.nodeWithDegree(tx, 0);
            end = CachingExpandIntoTest.nodeWithDegree(tx, 44);
            r1 = CachingExpandIntoTest.relate(tx, start, "R1", end);
            r2 = CachingExpandIntoTest.relate(tx, start, "R2", end);
            r3 = CachingExpandIntoTest.relate(tx, end, "R3", start);
            tx.commit();
        }
        Assertions.assertThat((Object)this.connections(start, Direction.OUTGOING, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(new long[]{r1, r2}));
        Assertions.assertThat((Object)this.connections(start, Direction.OUTGOING, end, "R1")).isEqualTo((Object)LongSets.immutable.of(r1));
        Assertions.assertThat((Object)this.connections(start, Direction.INCOMING, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(r3));
        Assertions.assertThat((Object)this.connections(start, Direction.INCOMING, end, "R1")).isEqualTo((Object)LongSets.immutable.empty());
        Assertions.assertThat((Object)this.connections(start, Direction.BOTH, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(new long[]{r1, r2, r3}));
        Assertions.assertThat((Object)this.connections(start, Direction.BOTH, end, "R2", "R3")).isEqualTo((Object)LongSets.immutable.of(new long[]{r2, r3}));
    }

    @Test
    void shouldFindConnectingRelationshipBetweenDenseAndSparseNodes() throws KernelException {
        long r3;
        long r2;
        long r1;
        long end;
        long start;
        try (KernelTransaction tx = this.transaction();){
            start = CachingExpandIntoTest.nodeWithDegree(tx, 56);
            end = CachingExpandIntoTest.nodeWithDegree(tx, 0);
            r1 = CachingExpandIntoTest.relate(tx, start, "R1", end);
            r2 = CachingExpandIntoTest.relate(tx, start, "R2", end);
            r3 = CachingExpandIntoTest.relate(tx, end, "R3", start);
            tx.commit();
        }
        Assertions.assertThat((Object)this.connections(start, Direction.OUTGOING, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(new long[]{r1, r2}));
        Assertions.assertThat((Object)this.connections(start, Direction.OUTGOING, end, "R1")).isEqualTo((Object)LongSets.immutable.of(r1));
        Assertions.assertThat((Object)this.connections(start, Direction.INCOMING, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(r3));
        Assertions.assertThat((Object)this.connections(start, Direction.INCOMING, end, "R1")).isEqualTo((Object)LongSets.immutable.empty());
        Assertions.assertThat((Object)this.connections(start, Direction.BOTH, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(new long[]{r1, r2, r3}));
        Assertions.assertThat((Object)this.connections(start, Direction.BOTH, end, "R2", "R3")).isEqualTo((Object)LongSets.immutable.of(new long[]{r2, r3}));
    }

    @Test
    void shouldFindConnectingRelationshipBetweenTwoSparseNodes() throws KernelException {
        long r3;
        long r2;
        long r1;
        long end;
        long start;
        try (KernelTransaction tx = this.transaction();){
            start = CachingExpandIntoTest.nodeWithDegree(tx, 0);
            end = CachingExpandIntoTest.nodeWithDegree(tx, 0);
            r1 = CachingExpandIntoTest.relate(tx, start, "R1", end);
            r2 = CachingExpandIntoTest.relate(tx, start, "R2", end);
            r3 = CachingExpandIntoTest.relate(tx, end, "R3", start);
            tx.commit();
        }
        Assertions.assertThat((Object)this.connections(start, Direction.OUTGOING, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(new long[]{r1, r2}));
        Assertions.assertThat((Object)this.connections(start, Direction.OUTGOING, end, "R1")).isEqualTo((Object)LongSets.immutable.of(r1));
        Assertions.assertThat((Object)this.connections(start, Direction.INCOMING, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(r3));
        Assertions.assertThat((Object)this.connections(start, Direction.INCOMING, end, "R1")).isEqualTo((Object)LongSets.immutable.empty());
        Assertions.assertThat((Object)this.connections(start, Direction.BOTH, end, new String[0])).isEqualTo((Object)LongSets.immutable.of(new long[]{r1, r2, r3}));
        Assertions.assertThat((Object)this.connections(start, Direction.BOTH, end, "R2", "R3")).isEqualTo((Object)LongSets.immutable.of(new long[]{r2, r3}));
    }

    @Test
    void shouldBeAbleToReuseWithoutTypes() throws KernelException {
        long r3;
        long r2;
        long r1;
        long end;
        long start;
        try (KernelTransaction tx = this.transaction();){
            start = CachingExpandIntoTest.nodeWithDegree(tx, 43);
            end = CachingExpandIntoTest.nodeWithDegree(tx, 11);
            TokenWrite tokenWrite = tx.tokenWrite();
            int t1 = tokenWrite.relationshipTypeGetOrCreateForName("R1");
            int t2 = tokenWrite.relationshipTypeGetOrCreateForName("R2");
            int t3 = tokenWrite.relationshipTypeGetOrCreateForName("R3");
            Write write = tx.dataWrite();
            r1 = write.relationshipCreate(start, t1, end);
            r2 = write.relationshipCreate(start, t2, end);
            r3 = write.relationshipCreate(end, t3, start);
            tx.commit();
        }
        tx = this.transaction();
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());
             RelationshipTraversalCursor traversalCursor = tx.cursors().allocateRelationshipTraversalCursor(tx.cursorContext());){
            CachingExpandInto expandInto = new CachingExpandInto(tx.queryContext(), Direction.OUTGOING, MEMORY_TRACKER);
            Assertions.assertThat((Object)CachingExpandIntoTest.toSet(expandInto.connectingRelationships(nodeCursor, traversalCursor, start, null, end))).isEqualTo((Object)LongSets.immutable.of(new long[]{r1, r2}));
            Assertions.assertThat((Object)CachingExpandIntoTest.toSet(expandInto.connectingRelationships(nodeCursor, traversalCursor, end, null, start))).isEqualTo((Object)LongSets.immutable.of(r3));
            Assertions.assertThat((Object)CachingExpandIntoTest.toSet(expandInto.connectingRelationships(nodeCursor, traversalCursor, start, null, end))).isEqualTo((Object)LongSets.immutable.of(new long[]{r1, r2}));
            Assertions.assertThat((Object)CachingExpandIntoTest.toSet(expandInto.connectingRelationships(nodeCursor, traversalCursor, end, null, start))).isEqualTo((Object)LongSets.immutable.of(r3));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldBeAbleToReuseWithTypes() throws KernelException {
        long r3;
        long r1;
        int t3;
        int t1;
        long end;
        long start;
        try (KernelTransaction tx = this.transaction();){
            start = CachingExpandIntoTest.nodeWithDegree(tx, 43);
            end = CachingExpandIntoTest.nodeWithDegree(tx, 11);
            TokenWrite tokenWrite = tx.tokenWrite();
            t1 = tokenWrite.relationshipTypeGetOrCreateForName("R1");
            int t2 = tokenWrite.relationshipTypeGetOrCreateForName("R2");
            t3 = tokenWrite.relationshipTypeGetOrCreateForName("R3");
            Write write = tx.dataWrite();
            r1 = write.relationshipCreate(start, t1, end);
            write.relationshipCreate(start, t2, end);
            r3 = write.relationshipCreate(end, t3, start);
            tx.commit();
        }
        tx = this.transaction();
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());
             RelationshipTraversalCursor traversalCursor = tx.cursors().allocateRelationshipTraversalCursor(tx.cursorContext());){
            int[] types = new int[]{t1, t3};
            CachingExpandInto expandInto = new CachingExpandInto(tx.queryContext(), Direction.OUTGOING, MEMORY_TRACKER);
            Assertions.assertThat((Object)CachingExpandIntoTest.toSet(expandInto.connectingRelationships(nodeCursor, traversalCursor, start, types, end))).isEqualTo((Object)LongSets.immutable.of(r1));
            Assertions.assertThat((Object)CachingExpandIntoTest.toSet(expandInto.connectingRelationships(nodeCursor, traversalCursor, end, types, start))).isEqualTo((Object)LongSets.immutable.of(r3));
            Assertions.assertThat((Object)CachingExpandIntoTest.toSet(expandInto.connectingRelationships(nodeCursor, traversalCursor, start, types, end))).isEqualTo((Object)LongSets.immutable.of(r1));
            Assertions.assertThat((Object)CachingExpandIntoTest.toSet(expandInto.connectingRelationships(nodeCursor, traversalCursor, end, types, start))).isEqualTo((Object)LongSets.immutable.of(r3));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldBeAbleToPreformAllCursorMethodsFromReused() throws KernelException {
        long r3;
        long r2;
        int t3;
        int t2;
        long end;
        long start;
        try (KernelTransaction tx = this.transaction();){
            start = CachingExpandIntoTest.nodeWithDegree(tx, 43);
            end = CachingExpandIntoTest.nodeWithDegree(tx, 11);
            TokenWrite tokenWrite = tx.tokenWrite();
            int t1 = tokenWrite.relationshipTypeGetOrCreateForName("R1");
            t2 = tokenWrite.relationshipTypeGetOrCreateForName("R2");
            t3 = tokenWrite.relationshipTypeGetOrCreateForName("R3");
            int prop = tokenWrite.propertyKeyGetOrCreateForName("prop");
            Write write = tx.dataWrite();
            long r1 = write.relationshipCreate(start, t1, end);
            r2 = write.relationshipCreate(start, t2, end);
            r3 = write.relationshipCreate(end, t3, start);
            write.relationshipSetProperty(r1, prop, (Value)Values.stringValue((String)"Relationship 1"));
            write.relationshipSetProperty(r2, prop, (Value)Values.stringValue((String)"Relationship 2"));
            write.relationshipSetProperty(r3, prop, (Value)Values.stringValue((String)"Relationship 3"));
            tx.commit();
        }
        tx = this.transaction();
        try (NodeCursor nodes = tx.cursors().allocateNodeCursor(tx.cursorContext());
             RelationshipTraversalCursor traversal = tx.cursors().allocateRelationshipTraversalCursor(tx.cursorContext());
             PropertyCursor properties = tx.cursors().allocatePropertyCursor(tx.cursorContext(), tx.memoryTracker());){
            int[] types = new int[]{t2, t3};
            CachingExpandInto expandInto = new CachingExpandInto(tx.queryContext(), Direction.INCOMING, MEMORY_TRACKER);
            RelationshipTraversalCursor cursor = expandInto.connectingRelationships(nodes, traversal, start, types, end);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(r3);
            Assertions.assertThat((long)cursor.sourceNodeReference()).isEqualTo(end);
            Assertions.assertThat((long)cursor.targetNodeReference()).isEqualTo(start);
            Assertions.assertThat((long)cursor.otherNodeReference()).isEqualTo(end);
            Assertions.assertThat((int)cursor.type()).isEqualTo(t3);
            cursor.properties(properties);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)properties.next());
            Assertions.assertThat((Object)properties.propertyValue()).isEqualTo((Object)Values.stringValue((String)"Relationship 3"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)properties.next());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            cursor = expandInto.connectingRelationships(nodes, traversal, start, types, end);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(r3);
            Assertions.assertThat((long)cursor.sourceNodeReference()).isEqualTo(end);
            Assertions.assertThat((long)cursor.targetNodeReference()).isEqualTo(start);
            Assertions.assertThat((long)cursor.otherNodeReference()).isEqualTo(end);
            Assertions.assertThat((int)cursor.type()).isEqualTo(t3);
            cursor.properties(properties);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)properties.next());
            Assertions.assertThat((Object)properties.propertyValue()).isEqualTo((Object)Values.stringValue((String)"Relationship 3"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)properties.next());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            cursor = expandInto.connectingRelationships(nodes, traversal, end, types, start);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(r2);
            Assertions.assertThat((long)cursor.sourceNodeReference()).isEqualTo(start);
            Assertions.assertThat((long)cursor.targetNodeReference()).isEqualTo(end);
            Assertions.assertThat((long)cursor.otherNodeReference()).isEqualTo(start);
            Assertions.assertThat((int)cursor.type()).isEqualTo(t2);
            cursor.properties(properties);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)properties.next());
            Assertions.assertThat((Object)properties.propertyValue()).isEqualTo((Object)Values.stringValue((String)"Relationship 2"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)properties.next());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
            cursor = expandInto.connectingRelationships(nodes, traversal, end, types, start);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertThat((long)cursor.relationshipReference()).isEqualTo(r2);
            Assertions.assertThat((long)cursor.sourceNodeReference()).isEqualTo(start);
            Assertions.assertThat((long)cursor.targetNodeReference()).isEqualTo(end);
            Assertions.assertThat((long)cursor.otherNodeReference()).isEqualTo(start);
            Assertions.assertThat((int)cursor.type()).isEqualTo(t2);
            cursor.properties(properties);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)properties.next());
            Assertions.assertThat((Object)properties.propertyValue()).isEqualTo((Object)Values.stringValue((String)"Relationship 2"));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)properties.next());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)cursor.next());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldComputeDegreeWithoutType() throws Exception {
        long node;
        try (KernelTransaction tx = this.transaction();){
            Write write = tx.dataWrite();
            node = CachingExpandIntoTest.nodeWithDegree(tx, 42);
            CachingExpandIntoTest.relate(tx, node, "R1", write.nodeCreate());
            CachingExpandIntoTest.relate(tx, node, "R2", write.nodeCreate());
            CachingExpandIntoTest.relate(tx, write.nodeCreate(), "R3", node);
            CachingExpandIntoTest.relate(tx, node, "R4", node);
            tx.commit();
        }
        tx = this.transaction();
        try {
            Read read = tx.dataRead();
            CursorFactory cursors = tx.cursors();
            try (NodeCursor nodes = cursors.allocateNodeCursor(tx.cursorContext());){
                CachingExpandInto expand = new CachingExpandInto(tx.queryContext(), Direction.OUTGOING, MEMORY_TRACKER);
                read.singleNode(node, nodes);
                Assertions.assertThat((boolean)nodes.next()).isTrue();
                Assertions.assertThat((boolean)nodes.supportsFastDegreeLookup()).isTrue();
                Degrees degrees = nodes.degrees(RelationshipSelection.ALL_RELATIONSHIPS);
                Assertions.assertThat((int)degrees.outgoingDegree()).isEqualTo(45);
                Assertions.assertThat((int)degrees.incomingDegree()).isEqualTo(2);
                Assertions.assertThat((int)degrees.totalDegree()).isEqualTo(46);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldComputeDegreeWithType() throws Exception {
        int loop;
        int in;
        int out;
        long node;
        try (KernelTransaction tx = this.transaction();){
            Write write = tx.dataWrite();
            node = CachingExpandIntoTest.denseNode(tx);
            TokenWrite tokenWrite = tx.tokenWrite();
            out = tokenWrite.relationshipTypeGetOrCreateForName("OUT");
            in = tokenWrite.relationshipTypeGetOrCreateForName("IN");
            loop = tokenWrite.relationshipTypeGetOrCreateForName("LOOP");
            write.relationshipCreate(node, out, write.nodeCreate());
            write.relationshipCreate(node, out, write.nodeCreate());
            write.relationshipCreate(write.nodeCreate(), in, node);
            write.relationshipCreate(node, loop, node);
            tx.commit();
        }
        tx = this.transaction();
        try {
            Read read = tx.dataRead();
            CursorFactory cursors = tx.cursors();
            try (NodeCursor nodes = cursors.allocateNodeCursor(tx.cursorContext());){
                CachingExpandInto expand = new CachingExpandInto(tx.queryContext(), Direction.OUTGOING, MEMORY_TRACKER);
                read.singleNode(node, nodes);
                Assertions.assertThat((boolean)nodes.next()).isTrue();
                Assertions.assertThat((boolean)nodes.supportsFastDegreeLookup()).isTrue();
                Degrees degrees = nodes.degrees(RelationshipSelection.ALL_RELATIONSHIPS);
                Assertions.assertThat((int)degrees.outgoingDegree(out)).isEqualTo(2);
                Assertions.assertThat((int)degrees.outgoingDegree(in)).isEqualTo(0);
                Assertions.assertThat((int)degrees.outgoingDegree(loop)).isEqualTo(1);
                Assertions.assertThat((int)degrees.incomingDegree(out)).isEqualTo(0);
                Assertions.assertThat((int)degrees.incomingDegree(in)).isEqualTo(1);
                Assertions.assertThat((int)degrees.incomingDegree(loop)).isEqualTo(1);
                Assertions.assertThat((int)degrees.totalDegree(out)).isEqualTo(2);
                Assertions.assertThat((int)degrees.totalDegree(in)).isEqualTo(1);
                Assertions.assertThat((int)degrees.totalDegree(loop)).isEqualTo(1);
            }
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldReturnCorrectNodeReferences() throws KernelException {
        int relType;
        long nodeB;
        long nodeA;
        try (KernelTransaction tx = this.transaction();){
            nodeA = tx.dataWrite().nodeCreate();
            nodeB = tx.dataWrite().nodeCreate();
            relType = tx.tokenWrite().relationshipTypeGetOrCreateForName("KNOWS");
            tx.dataWrite().relationshipCreate(nodeA, relType, nodeB);
            tx.commit();
        }
        int[] relTypes = new int[]{relType};
        try (KernelTransaction tx = this.transaction();
             NodeCursor nodeCursor = tx.cursors().allocateNodeCursor(tx.cursorContext());
             RelationshipTraversalCursor traversalCursor = tx.cursors().allocateRelationshipTraversalCursor(tx.cursorContext());){
            CachingExpandInto expandInto = new CachingExpandInto(tx.queryContext(), Direction.BOTH, MEMORY_TRACKER);
            RelationshipTraversalCursor cursor = expandInto.connectingRelationships(nodeCursor, traversalCursor, nodeA, relTypes, nodeB);
            Assertions.assertThat((String)cursor.getClass().getSimpleName()).doesNotContain(new CharSequence[]{"FromCachedSelectionCursor"});
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            this.testNodeReferences(cursor, nodeA, nodeB, nodeA);
            Assertions.assertThat((boolean)cursor.next()).isFalse();
            cursor = expandInto.connectingRelationships(nodeCursor, traversalCursor, nodeA, relTypes, nodeB);
            Assertions.assertThat((String)cursor.getClass().getSimpleName()).contains(new CharSequence[]{"FromCachedSelectionCursor"});
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            this.testNodeReferences(cursor, nodeA, nodeB, nodeA);
            Assertions.assertThat((boolean)cursor.next()).isFalse();
            expandInto = new CachingExpandInto(tx.queryContext(), Direction.BOTH, MEMORY_TRACKER);
            cursor = expandInto.connectingRelationships(nodeCursor, traversalCursor, nodeB, relTypes, nodeA);
            Assertions.assertThat((String)cursor.getClass().getSimpleName()).doesNotContain(new CharSequence[]{"FromCachedSelectionCursor"});
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            this.testNodeReferences(cursor, nodeA, nodeB, nodeB);
            Assertions.assertThat((boolean)cursor.next()).isFalse();
            cursor = expandInto.connectingRelationships(nodeCursor, traversalCursor, nodeB, relTypes, nodeA);
            Assertions.assertThat((String)cursor.getClass().getSimpleName()).contains(new CharSequence[]{"FromCachedSelectionCursor"});
            Assertions.assertThat((boolean)cursor.next()).isTrue();
            this.testNodeReferences(cursor, nodeA, nodeB, nodeB);
            Assertions.assertThat((boolean)cursor.next()).isFalse();
        }
    }

    private void testNodeReferences(RelationshipTraversalCursor cursor, long source, long target, long origin) {
        long other = source == origin ? target : source;
        Assertions.assertThat((long)cursor.sourceNodeReference()).isEqualTo(source);
        Assertions.assertThat((long)cursor.targetNodeReference()).isEqualTo(target);
        Assertions.assertThat((long)cursor.originNodeReference()).isEqualTo(origin);
        Assertions.assertThat((long)cursor.otherNodeReference()).isEqualTo(other);
    }

    /*
     * Exception decompiling
     */
    private LongSet connections(long start, Direction direction, long end, String ... types) throws TransactionFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static LongSet toSet(RelationshipTraversalCursor connections) {
        MutableLongSet rels = LongSets.mutable.empty();
        while (connections.next()) {
            rels.add(connections.relationshipReference());
        }
        return rels;
    }

    private static long denseNode(KernelTransaction tx) throws KernelException {
        return CachingExpandIntoTest.nodeWithDegree(tx, 11);
    }

    private static long relate(KernelTransaction tx, long start, String rel, long end) throws KernelException {
        return tx.dataWrite().relationshipCreate(start, tx.tokenWrite().relationshipTypeGetOrCreateForName(rel), end);
    }

    private static long nodeWithDegree(KernelTransaction tx, int degree) throws KernelException {
        Write write = tx.dataWrite();
        long node = write.nodeCreate();
        for (int i = 0; i < degree; ++i) {
            CachingExpandIntoTest.relate(tx, node, "JUNK", write.nodeCreate());
        }
        return node;
    }
}

