/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.ByteUnit;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class FailedIndexRestartIT {
    private static final String ROBOT = "Robot";
    private static final String GENDER = "gender";
    @Inject
    private GraphDatabaseService database;
    @Inject
    private DbmsController dbmsController;

    @Test
    void failedIndexUpdatesAfterRestart() {
        Label robot = Label.label((String)ROBOT);
        String megaProperty = RandomStringUtils.randomAlphanumeric((int)((int)ByteUnit.mebiBytes((long)16L)));
        FailedIndexRestartIT.createNodeWithProperty(this.database, robot, megaProperty);
        try (Transaction tx = this.database.beginTx();){
            tx.schema().indexFor(robot).on(GENDER).create();
            tx.commit();
        }
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> FailedIndexRestartIT.awaitIndexesOnline(this.database));
        MatcherAssert.assertThat((Object)ExceptionUtils.getRootCause((Throwable)e).getMessage(), (Matcher)Matchers.containsString((String)"Property value is too large to index"));
        FailedIndexRestartIT.createNodeWithProperty(this.database, robot, megaProperty);
        try (Transaction transaction = this.database.beginTx();){
            Assertions.assertEquals((long)2L, (long)Iterators.count((Iterator)transaction.findNodes(robot)));
        }
        this.dbmsController.restartDbms();
        FailedIndexRestartIT.createNodeWithProperty(this.database, robot, megaProperty);
        transaction = this.database.beginTx();
        try {
            Assertions.assertEquals((long)3L, (long)Iterators.count((Iterator)transaction.findNodes(robot)));
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private static void createNodeWithProperty(GraphDatabaseService db, Label label, String propertyValue) {
        try (Transaction tx = db.beginTx();){
            Node node = tx.createNode(new Label[]{label});
            node.setProperty(GENDER, (Object)propertyValue);
            tx.commit();
        }
    }

    private static void awaitIndexesOnline(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            tx.schema().awaitIndexesOnline(3L, TimeUnit.MINUTES);
        }
    }
}

