/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.collection.RawIterator;
import org.neo4j.cypher.internal.ExecutionEngineQueryCacheMonitor;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.index.IndexSamplingMode;
import org.neo4j.kernel.impl.api.integrationtest.CommunityProcedureITBase;
import org.neo4j.kernel.internal.Version;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.VirtualValues;

class BuiltInProceduresIT
extends CommunityProcedureITBase {
    BuiltInProceduresIT() {
    }

    @Test
    void listAllLabels() throws Throwable {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId = transaction.dataWrite().nodeCreate();
        int labelId = transaction.tokenWrite().labelGetOrCreateForName("MyLabel");
        transaction.dataWrite().nodeAddLabel(nodeId, labelId);
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{{Values.stringValue((String)"MyLabel")}});
    }

    @Test
    void databaseInfo() throws ProcedureException {
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "info"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        List procedureResult = Iterators.asList((RawIterator)stream);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)procedureResult.isEmpty());
        Object[] dbInfoRow = (AnyValue[])procedureResult.get(0);
        Assertions.assertThat((Object[])dbInfoRow).contains((Object[])new AnyValue[]{Values.stringValue((String)this.db.databaseName())});
        Assertions.assertThat((Object[])dbInfoRow).hasSize(3);
    }

    @Test
    void dbmsInfo() throws ProcedureException {
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"dbms", "info"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        List procedureResult = Iterators.asList((RawIterator)stream);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)procedureResult.isEmpty());
        Object[] dbmsInfoRow = (AnyValue[])procedureResult.get(0);
        Assertions.assertThat((Object[])dbmsInfoRow).contains((Object[])new AnyValue[]{Values.stringValue((String)"system")});
        Assertions.assertThat((Object[])dbmsInfoRow).hasSize(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=6L, unit=TimeUnit.MINUTES)
    void listAllLabelsMustNotBlockOnConstraintCreatingTransaction() throws Throwable {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        long nodeId = transaction.dataWrite().nodeCreate();
        int labelId = transaction.tokenWrite().labelGetOrCreateForName("MyLabel");
        int propKey = transaction.tokenWrite().propertyKeyCreateForName("prop", false);
        transaction.dataWrite().nodeAddLabel(nodeId, labelId);
        this.commit();
        CountDownLatch constraintLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        FutureTask<Void> createConstraintTask = new FutureTask<Void>(() -> {
            SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
            try (Resource ignore = this.captureTransaction();){
                IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propKey})).withName("constraint name");
                schemaWrite.uniquePropertyConstraintCreate(prototype);
                constraintLatch.countDown();
                commitLatch.await();
            }
            this.rollback();
            return null;
        });
        Thread constraintCreator = new Thread(createConstraintTask);
        constraintCreator.start();
        constraintLatch.await();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "labels"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        try {
            Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{{Values.stringValue((String)"MyLabel")}});
        }
        finally {
            commitLatch.countDown();
        }
        createConstraintTask.get();
        constraintCreator.join();
    }

    @Test
    void listPropertyKeys() throws Throwable {
        TokenWrite ops = this.tokenWriteInNewTransaction();
        ops.propertyKeyGetOrCreateForName("MyProp");
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "propertyKeys"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{{Values.stringValue((String)"MyProp")}});
    }

    @Test
    void listRelationshipTypes() throws Throwable {
        KernelTransaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int relType = transaction.tokenWrite().relationshipTypeGetOrCreateForName("MyRelType");
        long startNodeId = transaction.dataWrite().nodeCreate();
        long endNodeId = transaction.dataWrite().nodeCreate();
        transaction.dataWrite().relationshipCreate(startNodeId, relType, endNodeId);
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "relationshipTypes"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{{Values.stringValue((String)"MyRelType")}});
    }

    @Test
    void failWhenCallingNonExistingProcedures() {
        org.junit.jupiter.api.Assertions.assertThrows(ProcedureException.class, () -> this.procs().procedureCallDbms(-1, new AnyValue[0], ProcedureCallContext.EMPTY));
    }

    @Test
    void listAllComponents() throws Throwable {
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"dbms", "components"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        Assertions.assertThat((List)Iterators.asList((RawIterator)stream)).containsExactly((Object[])new AnyValue[][]{{Values.stringValue((String)"Neo4j Kernel"), VirtualValues.list((AnyValue[])new AnyValue[]{Values.stringValue((String)Version.getNeo4jVersion())}), Values.stringValue((String)"community")}});
        this.commit();
    }

    @Test
    void listAllIndexes() throws Throwable {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int labelId1 = transaction.tokenWrite().labelGetOrCreateForName("Person");
        int labelId2 = transaction.tokenWrite().labelGetOrCreateForName("Age");
        int propertyKeyId1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        int propertyKeyId2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("bar");
        LabelSchemaDescriptor personFooDescriptor = SchemaDescriptors.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1});
        LabelSchemaDescriptor ageFooDescriptor = SchemaDescriptors.forLabel((int)labelId2, (int[])new int[]{propertyKeyId1});
        LabelSchemaDescriptor personFooBarDescriptor = SchemaDescriptors.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1, propertyKeyId2});
        transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)personFooDescriptor).withName("person foo index"));
        transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)ageFooDescriptor).withName("constraint name"));
        transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)personFooBarDescriptor).withName("person foo bar index"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        transaction = this.newTransaction();
        IndexDescriptor personFooIndex = (IndexDescriptor)Iterators.single((Iterator)transaction.schemaRead().index((SchemaDescriptor)personFooDescriptor));
        IndexDescriptor ageFooIndex = (IndexDescriptor)Iterators.single((Iterator)transaction.schemaRead().index((SchemaDescriptor)ageFooDescriptor));
        IndexDescriptor personFooBarIndex = (IndexDescriptor)Iterators.single((Iterator)transaction.schemaRead().index((SchemaDescriptor)personFooBarDescriptor));
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "indexes"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        HashSet<AnyValue[]> result = new HashSet<AnyValue[]>();
        while (stream.hasNext()) {
            result.add((AnyValue[])stream.next());
        }
        Assertions.assertThat(result).contains((Object[])new AnyValue[][]{BuiltInProceduresIT.dbIndexesResult(ageFooIndex.getId(), ageFooIndex.getName(), "ONLINE", 100.0, "UNIQUE", "BTREE", "NODE", Collections.singletonList("Age"), Collections.singletonList("foo"), ageFooIndex.getIndexProvider().name()), BuiltInProceduresIT.dbIndexesResult(personFooIndex.getId(), personFooIndex.getName(), "ONLINE", 100.0, "NONUNIQUE", "BTREE", "NODE", Collections.singletonList("Person"), Collections.singletonList("foo"), personFooIndex.getIndexProvider().name()), BuiltInProceduresIT.dbIndexesResult(personFooBarIndex.getId(), personFooBarIndex.getName(), "ONLINE", 100.0, "NONUNIQUE", "BTREE", "NODE", Collections.singletonList("Person"), Arrays.asList("foo", "bar"), personFooBarIndex.getIndexProvider().name())});
        this.commit();
    }

    private static AnyValue[] dbIndexesResult(long id, String name, String state, Double populationPercent, String uniqueness, String type, String entityType, List<String> labelsOrTypes, List<String> properties, String provider) {
        ListValue labelsOrTypesList = VirtualValues.list((AnyValue[])((AnyValue[])labelsOrTypes.stream().map(Values::stringValue).toArray(AnyValue[]::new)));
        ListValue propertiesList = VirtualValues.list((AnyValue[])((AnyValue[])properties.stream().map(Values::stringValue).toArray(AnyValue[]::new)));
        return new AnyValue[]{Values.longValue((long)id), Values.stringValue((String)name), Values.stringValue((String)state), Values.doubleValue((double)populationPercent), Values.stringValue((String)uniqueness), Values.stringValue((String)type), Values.stringValue((String)entityType), labelsOrTypesList, propertiesList, Values.stringValue((String)provider)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=6L, unit=TimeUnit.MINUTES)
    void listAllIndexesMustNotBlockOnConstraintCreatingTransaction() throws Throwable {
        KernelTransaction transaction = this.newTransaction(LoginContext.AUTH_DISABLED);
        int labelId1 = transaction.tokenWrite().labelGetOrCreateForName("Person");
        int labelId2 = transaction.tokenWrite().labelGetOrCreateForName("Age");
        int propertyKeyId1 = transaction.tokenWrite().propertyKeyGetOrCreateForName("foo");
        int propertyKeyId2 = transaction.tokenWrite().propertyKeyGetOrCreateForName("bar");
        int propertyKeyId3 = transaction.tokenWrite().propertyKeyGetOrCreateForName("baz");
        LabelSchemaDescriptor personFooDescriptor = SchemaDescriptors.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1});
        LabelSchemaDescriptor ageFooDescriptor = SchemaDescriptors.forLabel((int)labelId2, (int[])new int[]{propertyKeyId1});
        LabelSchemaDescriptor personFooBarDescriptor = SchemaDescriptors.forLabel((int)labelId1, (int[])new int[]{propertyKeyId1, propertyKeyId2});
        LabelSchemaDescriptor personBazDescriptor = SchemaDescriptors.forLabel((int)labelId1, (int[])new int[]{propertyKeyId3});
        transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)personFooDescriptor).withName("person foo index"));
        transaction.schemaWrite().uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)ageFooDescriptor).withName("age foo constraint"));
        transaction.schemaWrite().indexCreate(IndexPrototype.forSchema((SchemaDescriptor)personFooBarDescriptor).withName("person foo bar index"));
        this.commit();
        try (Transaction tx = this.db.beginTx();){
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        CountDownLatch constraintLatch = new CountDownLatch(1);
        CountDownLatch commitLatch = new CountDownLatch(1);
        AtomicLong personBazIndexId = new AtomicLong();
        FutureTask<Void> createConstraintTask = new FutureTask<Void>(() -> {
            SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
            try (Resource ignore = this.captureTransaction();){
                ConstraintDescriptor personBazConstraint = schemaWrite.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)personBazDescriptor).withName("person baz constraint"));
                personBazIndexId.set(personBazConstraint.asIndexBackedConstraint().ownedIndexId());
                constraintLatch.countDown();
                commitLatch.await();
            }
            this.rollback();
            return null;
        });
        Thread constraintCreator = new Thread(createConstraintTask);
        constraintCreator.start();
        constraintLatch.await();
        transaction = this.newTransaction();
        SchemaReadCore schemaRead = transaction.schemaRead().snapshot();
        IndexDescriptor personFooIndex = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)personFooDescriptor));
        IndexDescriptor ageFooIndex = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)ageFooDescriptor));
        IndexDescriptor personFooBarIndex = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)personFooBarDescriptor));
        IndexDescriptor personBazIndex = (IndexDescriptor)Iterators.single((Iterator)schemaRead.index((SchemaDescriptor)personBazDescriptor));
        this.commit();
        RawIterator stream = this.procs().procedureCallRead(this.procs().procedureGet(ProcedureSignature.procedureName((String[])new String[]{"db", "indexes"})).id(), new AnyValue[0], ProcedureCallContext.EMPTY);
        HashSet<Object[]> result = new HashSet<Object[]>();
        while (stream.hasNext()) {
            result.add((Object[])stream.next());
        }
        try {
            Assertions.assertThat(result).contains((Object[])new Object[][]{BuiltInProceduresIT.dbIndexesResult(ageFooIndex.getId(), ageFooIndex.getName(), "ONLINE", 100.0, "UNIQUE", "BTREE", "NODE", Collections.singletonList("Age"), Collections.singletonList("foo"), ageFooIndex.getIndexProvider().name()), BuiltInProceduresIT.dbIndexesResult(personFooIndex.getId(), personFooIndex.getName(), "ONLINE", 100.0, "NONUNIQUE", "BTREE", "NODE", Collections.singletonList("Person"), Collections.singletonList("foo"), personFooIndex.getIndexProvider().name()), BuiltInProceduresIT.dbIndexesResult(personFooBarIndex.getId(), personFooBarIndex.getName(), "ONLINE", 100.0, "NONUNIQUE", "BTREE", "NODE", Collections.singletonList("Person"), Arrays.asList("foo", "bar"), personFooBarIndex.getIndexProvider().name()), BuiltInProceduresIT.dbIndexesResult(personBazIndex.getId(), personBazIndex.getName(), "POPULATING", 100.0, "UNIQUE", "BTREE", "NODE", Collections.singletonList("Person"), Collections.singletonList("baz"), personBazIndex.getIndexProvider().name())});
            this.commit();
        }
        finally {
            commitLatch.countDown();
        }
        createConstraintTask.get();
        constraintCreator.join();
    }

    @Test
    void prepareForReplanningShouldEmptyQueryCache() {
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("MATCH (n) RETURN n").close();
            transaction.commit();
        }
        ReplanMonitor monitor = this.replanMonitor();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.prepareForReplanning()").close();
            transaction.commit();
        }
        Assertions.assertThat((long)monitor.numberOfFlushedItems()).isEqualTo(2L);
    }

    @Test
    void prepareForReplanningShouldTriggerIndexesSampling() {
        ReplanMonitor monitor = this.replanMonitor();
        try (Transaction transaction = this.db.beginTx();){
            transaction.execute("CALL db.prepareForReplanning()").close();
            transaction.commit();
        }
        IndexSamplingMode mode = monitor.samplingMode();
        org.junit.jupiter.api.Assertions.assertNotEquals((long)0L, (long)mode.millisToWaitForCompletion());
        Assertions.assertThat((long)mode.millisToWaitForCompletion()).isGreaterThan(0L);
    }

    private ReplanMonitor replanMonitor() {
        Monitors monitors = (Monitors)this.dependencyResolver.resolveDependency(Monitors.class);
        ReplanMonitor monitorListener = new ReplanMonitor();
        monitors.addMonitorListener((Object)monitorListener, new String[0]);
        return monitorListener;
    }

    private static class ReplanMonitor
    extends IndexMonitor.MonitorAdapter
    implements ExecutionEngineQueryCacheMonitor {
        private long numberOfFlushedItems = -1L;
        private IndexSamplingMode samplingMode;

        private ReplanMonitor() {
        }

        public void cacheFlushDetected(long sizeBeforeFlush) {
            this.numberOfFlushedItems = sizeBeforeFlush;
        }

        public void indexSamplingTriggered(IndexSamplingMode mode) {
            this.samplingMode = mode;
        }

        long numberOfFlushedItems() {
            return this.numberOfFlushedItems;
        }

        IndexSamplingMode samplingMode() {
            return this.samplingMode;
        }
    }
}

