/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.MyRelTypes;

class TestNeo4j
extends AbstractNeo4jTestCase {
    TestNeo4j() {
    }

    @Test
    void testBasicNodeRelationships() {
        try (Transaction transaction = TestNeo4j.getGraphDb().beginTx();){
            Node firstNode = transaction.createNode();
            Assertions.assertNotNull((Object)firstNode, (String)"Failure creating first node");
            Node secondNode = transaction.createNode();
            Assertions.assertNotNull((Object)secondNode, (String)"Failure creating second node");
            Relationship rel = firstNode.createRelationshipTo(secondNode, (RelationshipType)MyRelTypes.TEST);
            Assertions.assertNotNull((Object)rel, (String)"Relationship is null");
            RelationshipType relType = rel.getType();
            Assertions.assertNotNull((Object)relType, (String)"Relationship's type is is null");
            try (ResourceIterator iterator = Iterators.asResourceIterator(firstNode.getRelationships(new RelationshipType[]{relType}).iterator());){
                Assertions.assertTrue((boolean)iterator.hasNext());
            }
            iterator = Iterators.asResourceIterator(secondNode.getRelationships(new RelationshipType[]{relType}).iterator());
            try {
                Assertions.assertTrue((boolean)iterator.hasNext());
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
            ResourceIterable allRels = (ResourceIterable)firstNode.getRelationships();
            Assertions.assertTrue((boolean)TestNeo4j.objectExistsInIterable(rel, (ResourceIterable<Relationship>)allRels));
            allRels = (ResourceIterable)firstNode.getRelationships(new RelationshipType[]{relType});
            Assertions.assertTrue((boolean)TestNeo4j.objectExistsInIterable(rel, (ResourceIterable<Relationship>)allRels));
            allRels = (ResourceIterable)secondNode.getRelationships();
            Assertions.assertTrue((boolean)TestNeo4j.objectExistsInIterable(rel, (ResourceIterable<Relationship>)allRels));
            allRels = (ResourceIterable)secondNode.getRelationships(new RelationshipType[]{relType});
            Assertions.assertTrue((boolean)TestNeo4j.objectExistsInIterable(rel, (ResourceIterable<Relationship>)allRels));
            Object[] relNodes = rel.getNodes();
            Assertions.assertEquals((int)2, (int)relNodes.length, (String)"A relationship should always be connected to exactly two nodes");
            Assertions.assertTrue((boolean)TestNeo4j.objectExistsInArray(firstNode, relNodes), (String)"Relationship says that it isn't connected to firstNode");
            Assertions.assertTrue((boolean)TestNeo4j.objectExistsInArray(secondNode, relNodes), (String)"Relationship says that it isn't connected to secondNode");
            Assertions.assertEquals((Object)rel.getOtherNode(firstNode), (Object)secondNode, (String)"The other node should be secondNode but it isn't");
            Assertions.assertEquals((Object)rel.getOtherNode(secondNode), (Object)firstNode, (String)"The other node should be firstNode but it isn't");
            rel.delete();
            secondNode.delete();
            firstNode.delete();
            transaction.commit();
        }
    }

    private static boolean objectExistsInIterable(Relationship rel, ResourceIterable<Relationship> allRels) {
        try (ResourceIterator resourceIterator = allRels.iterator();){
            while (resourceIterator.hasNext()) {
                Relationship iteratedRel = (Relationship)resourceIterator.next();
                if (!rel.equals(iteratedRel)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static boolean objectExistsInArray(Object obj, Object[] objArray) {
        for (Object o : objArray) {
            if (!o.equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Test
    void testRandomPropertyName() {
        try (Transaction transaction = TestNeo4j.getGraphDb().beginTx();){
            Node node1 = transaction.createNode();
            String key = "random_" + new Random(System.currentTimeMillis()).nextLong();
            node1.setProperty(key, (Object)"value");
            Assertions.assertEquals((Object)"value", (Object)node1.getProperty(key));
            node1.delete();
            transaction.commit();
        }
    }

    @Test
    void testNodeChangePropertyArray() {
        Node node;
        try (Transaction tx = TestNeo4j.getGraphDb().beginTx();){
            node = tx.createNode();
            tx.commit();
        }
        tx = TestNeo4j.getGraphDb().beginTx();
        try {
            tx.getNodeById(node.getId()).setProperty("test", (Object)new String[]{"value1"});
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = TestNeo4j.getGraphDb().beginTx();
        try {
            tx.getNodeById(node.getId()).setProperty("test", (Object)new String[]{"value1", "value2"});
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = TestNeo4j.getGraphDb().beginTx();
        try {
            String[] value = (String[])tx.getNodeById(node.getId()).getProperty("test");
            Assertions.assertEquals((int)1, (int)value.length);
            Assertions.assertEquals((Object)"value1", (Object)value[0]);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void testGetAllNodes() {
        long highId = TestNeo4j.getIdGenerator((IdType)RecordIdType.NODE).getHighestPossibleIdInUse();
        if (highId >= 0L && highId < 10000L) {
            Node newNode;
            long count;
            boolean found = false;
            try (Transaction transaction = TestNeo4j.getGraphDb().beginTx();){
                count = Iterables.count((Iterable)transaction.getAllNodes());
                newNode = transaction.createNode();
                transaction.commit();
            }
            long oldCount = count;
            count = 0L;
            try (Transaction transaction = TestNeo4j.getGraphDb().beginTx();){
                for (Node node : transaction.getAllNodes()) {
                    ++count;
                    if (!node.equals(newNode)) continue;
                    found = true;
                }
                Assertions.assertTrue((boolean)found);
                Assertions.assertEquals((long)count, (long)(oldCount + 1L));
                ResourceIterator allNodesIterator = transaction.getAllNodes().iterator();
                Assertions.assertNotNull((Object)allNodesIterator.next());
                allNodesIterator.close();
                transaction.getNodeById(newNode.getId()).delete();
                transaction.commit();
            }
            found = false;
            transaction = TestNeo4j.getGraphDb().beginTx();
            try {
                count = 0L;
                for (Node node : transaction.getAllNodes()) {
                    ++count;
                    if (!node.equals(newNode)) continue;
                    found = true;
                }
                Assertions.assertFalse((boolean)found);
                Assertions.assertEquals((long)count, (long)oldCount);
                transaction.commit();
            }
            finally {
                if (transaction != null) {
                    transaction.close();
                }
            }
        }
    }

    @Test
    void testMultipleShutdown() {
        TestNeo4j.getManagementService().shutdown();
        TestNeo4j.getManagementService().shutdown();
    }
}

